/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.plugin;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.ServiceLoader;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.core.classloading.ComponentClassLoader;
import org.apache.flink.core.plugin.PluginDescriptor;
import org.apache.flink.util.ArrayUtils;
import org.apache.flink.util.TemporaryClassLoaderContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class PluginLoader
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(PluginLoader.class);
    private final String pluginId;
    private final URLClassLoader pluginClassLoader;

    @VisibleForTesting
    public PluginLoader(String pluginId, URLClassLoader pluginClassLoader) {
        this.pluginId = pluginId;
        this.pluginClassLoader = pluginClassLoader;
    }

    @VisibleForTesting
    public static URLClassLoader createPluginClassLoader(PluginDescriptor pluginDescriptor, ClassLoader parentClassLoader, String[] alwaysParentFirstPatterns) {
        return new PluginClassLoader(pluginDescriptor.getPluginResourceURLs(), parentClassLoader, ArrayUtils.concat(alwaysParentFirstPatterns, pluginDescriptor.getLoaderExcludePatterns()));
    }

    public static PluginLoader create(PluginDescriptor pluginDescriptor, ClassLoader parentClassLoader, String[] alwaysParentFirstPatterns) {
        return new PluginLoader(pluginDescriptor.getPluginId(), PluginLoader.createPluginClassLoader(pluginDescriptor, parentClassLoader, alwaysParentFirstPatterns));
    }

    public <P> Iterator<P> load(Class<P> service) {
        try (TemporaryClassLoaderContext ignored = TemporaryClassLoaderContext.of(this.pluginClassLoader);){
            ContextClassLoaderSettingIterator<P> contextClassLoaderSettingIterator = new ContextClassLoaderSettingIterator<P>(ServiceLoader.load(service, this.pluginClassLoader).iterator(), this.pluginClassLoader);
            return contextClassLoaderSettingIterator;
        }
    }

    @Override
    public void close() {
        try {
            this.pluginClassLoader.close();
        }
        catch (IOException e) {
            LOG.warn("An error occurred while closing the classloader for plugin {}.", (Object)this.pluginId);
        }
    }

    private static final class PluginClassLoader
    extends ComponentClassLoader {
        PluginClassLoader(URL[] pluginResourceURLs, ClassLoader flinkClassLoader, String[] allowedFlinkPackages) {
            super(pluginResourceURLs, flinkClassLoader, allowedFlinkPackages, new String[0]);
        }
    }

    static class ContextClassLoaderSettingIterator<P>
    implements Iterator<P> {
        private final Iterator<P> delegate;
        private final ClassLoader pluginClassLoader;

        ContextClassLoaderSettingIterator(Iterator<P> delegate, ClassLoader pluginClassLoader) {
            this.delegate = delegate;
            this.pluginClassLoader = pluginClassLoader;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public P next() {
            try (TemporaryClassLoaderContext ignored = TemporaryClassLoaderContext.of(this.pluginClassLoader);){
                P p = this.delegate.next();
                return p;
            }
        }
    }
}

