/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api.bridge.scala.internal;

import java.net.URL;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.EnvironmentSettings;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.bridge.internal.AbstractStreamTableEnvironmentImpl;
import org.apache.flink.table.api.bridge.scala.internal.StreamTableEnvironmentImpl;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.CatalogStore;
import org.apache.flink.table.catalog.CatalogStoreHolder;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.catalog.GenericInMemoryCatalog;
import org.apache.flink.table.delegation.Executor;
import org.apache.flink.table.delegation.Planner;
import org.apache.flink.table.factories.CatalogStoreFactory;
import org.apache.flink.table.factories.PlannerFactoryUtil;
import org.apache.flink.table.factories.TableFactoryUtil;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.table.resource.ResourceManager;
import org.apache.flink.util.FlinkUserCodeClassLoaders;
import org.apache.flink.util.MutableURLClassLoader;

public final class StreamTableEnvironmentImpl$ {
    public static StreamTableEnvironmentImpl$ MODULE$;

    static {
        new StreamTableEnvironmentImpl$();
    }

    public StreamTableEnvironmentImpl create(org.apache.flink.streaming.api.scala.StreamExecutionEnvironment executionEnvironment, EnvironmentSettings settings) {
        MutableURLClassLoader userClassLoader = FlinkUserCodeClassLoaders.create((URL[])new URL[0], (ClassLoader)settings.getUserClassLoader(), (ReadableConfig)settings.getConfiguration());
        Executor executor = AbstractStreamTableEnvironmentImpl.lookupExecutor((ClassLoader)userClassLoader, (StreamExecutionEnvironment)executionEnvironment.getWrappedStreamExecutionEnvironment());
        TableConfig tableConfig = TableConfig.getDefault();
        tableConfig.setRootConfiguration(executor.getConfiguration());
        tableConfig.addConfiguration(settings.getConfiguration());
        ResourceManager resourceManager = new ResourceManager((ReadableConfig)settings.getConfiguration(), userClassLoader);
        ModuleManager moduleManager = new ModuleManager();
        CatalogStoreFactory catalogStoreFactory = TableFactoryUtil.findAndCreateCatalogStoreFactory((Configuration)settings.getConfiguration(), (ClassLoader)userClassLoader);
        CatalogStoreFactory.Context catalogStoreFactoryContext = TableFactoryUtil.buildCatalogStoreFactoryContext((Configuration)settings.getConfiguration(), (ClassLoader)userClassLoader);
        catalogStoreFactory.open(catalogStoreFactoryContext);
        CatalogStore catalogStore = settings.getCatalogStore() != null ? settings.getCatalogStore() : catalogStoreFactory.createCatalogStore();
        CatalogManager catalogManager = CatalogManager.newBuilder().classLoader((ClassLoader)userClassLoader).config((ReadableConfig)tableConfig).defaultCatalog(settings.getBuiltInCatalogName(), (Catalog)new GenericInMemoryCatalog(settings.getBuiltInCatalogName(), settings.getBuiltInDatabaseName())).executionConfig(executionEnvironment.getConfig()).catalogModificationListeners(TableFactoryUtil.findCatalogModificationListenerList((ReadableConfig)tableConfig.getConfiguration(), (ClassLoader)userClassLoader)).catalogStoreHolder(CatalogStoreHolder.newBuilder().catalogStore(catalogStore).factory(catalogStoreFactory).config((ReadableConfig)tableConfig).classloader((ClassLoader)userClassLoader).build()).build();
        FunctionCatalog functionCatalog = new FunctionCatalog((ReadableConfig)tableConfig, resourceManager, catalogManager, moduleManager);
        Planner planner = PlannerFactoryUtil.createPlanner((Executor)executor, (TableConfig)tableConfig, (ClassLoader)userClassLoader, (ModuleManager)moduleManager, (CatalogManager)catalogManager, (FunctionCatalog)functionCatalog);
        return new StreamTableEnvironmentImpl(catalogManager, moduleManager, resourceManager, functionCatalog, tableConfig, executionEnvironment, planner, executor, settings.isStreamingMode());
    }

    private StreamTableEnvironmentImpl$() {
        MODULE$ = this;
    }
}

