/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.flink.kubernetes;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.yaml.snakeyaml.Yaml;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;
import scala.util.control.Breaks$;

public final class PodTemplateParser$ {
    public static PodTemplateParser$ MODULE$;
    private final String POD_TEMPLATE_INIT_CONTENT;

    static {
        new PodTemplateParser$();
    }

    public String POD_TEMPLATE_INIT_CONTENT() {
        return this.POD_TEMPLATE_INIT_CONTENT;
    }

    public String getInitPodTemplateContent() {
        return this.POD_TEMPLATE_INIT_CONTENT().concat("spec:\n");
    }

    public String completeInitPodTemplate(String podTemplateContent) {
        if (podTemplateContent == null || podTemplateContent.trim().isEmpty()) {
            return this.POD_TEMPLATE_INIT_CONTENT();
        }
        Yaml yaml = new Yaml();
        Map root = (Map)yaml.load(podTemplateContent);
        LinkedHashMap<String, Object> res = new LinkedHashMap<String, Object>(root){
            {
                this.put("apiVersion", root$1.getOrDefault("apiVersion", "v1"));
                this.put("kind", root$1.getOrDefault("kind", "Pod"));
                this.put("metadata", root$1.getOrDefault("metadata", new LinkedHashMap<String, Object>(null){
                    {
                        this.put("name", "pod-template");
                    }
                }));
            }
        };
        Object object = root.containsKey("spec") && BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !((Map)root.get("spec")).isEmpty()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false)) ? res.put("spec", root.get("spec")) : BoxedUnit.UNIT;
        return yaml.dumpAsMap((Object)res);
    }

    public String completeHostAliasSpec(Map<String, String> hosts, String podTemplateContent) {
        String string;
        if (hosts.isEmpty()) {
            return podTemplateContent;
        }
        try {
            String content = this.completeInitPodTemplate(podTemplateContent);
            ArrayList<LinkedHashMap<String, Object>> hostAlias = this.covertHostsMapToHostAliasNode(hosts);
            Yaml yaml = new Yaml();
            Map root = (Map)yaml.load(content);
            if (!root.containsKey("spec")) {
                LinkedHashMap<String, ArrayList<LinkedHashMap<String, Object>>> spec = new LinkedHashMap<String, ArrayList<LinkedHashMap<String, Object>>>();
                spec.put("hostAliases", hostAlias);
                root.put("spec", spec);
                return yaml.dumpAsMap((Object)root);
            }
            Map spec = (Map)root.get("spec");
            spec.put("hostAliases", hostAlias);
            string = yaml.dumpAsMap((Object)root);
        }
        catch (Throwable throwable) {
            string = podTemplateContent;
        }
        return string;
    }

    private ArrayList<LinkedHashMap<String, Object>> covertHostsMapToHostAliasNode(Map<String, String> hosts) {
        return new ArrayList<LinkedHashMap<String, Object>>((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(hosts).asScala()).map((Function1 & Serializable & scala.Serializable)e -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)((String)e._1()).trim()), (Object)((String)e._2()).trim()), Map$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)x$1 -> (String)x$1._2()).mapValues((Function1 & Serializable & scala.Serializable)x$2 -> x$2.keys()).toList().map((Function1 & Serializable & scala.Serializable)e -> {
            void var1_1;
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("ip", e._1());
            map.put("hostnames", new ArrayList((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)e._2()).toList()).asJava()));
            return var1_1;
        }, List$.MODULE$.canBuildFrom())).asJava());
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, String> extractHostAliasMap(String podTemplateContent) {
        void var2_2;
        LinkedHashMap<String, String> hosts = new LinkedHashMap<String, String>(0);
        if (podTemplateContent == null || podTemplateContent.isEmpty()) {
            return hosts;
        }
        try {
            Yaml yaml = new Yaml();
            Map root = (Map)yaml.load(podTemplateContent);
            if (!root.containsKey("spec")) {
                return hosts;
            }
            Map spec = (Map)root.get("spec");
            if (!spec.containsKey("hostAliases")) {
                return hosts;
            }
            List hostAliases = (List)spec.get("hostAliases");
            if (CollectionUtils.isEmpty((Collection)hostAliases)) {
                return hosts;
            }
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(hostAliases).asScala()).foreach((Function1 & Serializable & scala.Serializable)hostAlias -> {
                Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    if (!hostAlias.containsKey("ip") && !hostAlias.containsKey("hostnames")) {
                        throw Breaks$.MODULE$.break();
                    }
                    String ip = (String)hostAlias.get("ip");
                    if (StringUtils.isBlank((CharSequence)ip)) {
                        throw Breaks$.MODULE$.break();
                    }
                    List hostnames = (List)hostAlias.get("hostnames");
                    ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(hostnames).asScala()).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)PodTemplateParser$.$anonfun$extractHostAliasMap$3(x$3)))).foreach((Function1 & Serializable & scala.Serializable)x$4 -> hosts$1.put(x$4, ip));
                });
                return BoxedUnit.UNIT;
            });
        }
        catch (Throwable throwable) {
            return new LinkedHashMap<String, String>(0);
        }
        return var2_2;
    }

    public String previewHostAliasSpec(Map<String, String> hosts) {
        ArrayList<LinkedHashMap<String, Object>> hostAlias = this.covertHostsMapToHostAliasNode(hosts);
        LinkedHashMap<String, ArrayList<LinkedHashMap<String, Object>>> root = new LinkedHashMap<String, ArrayList<LinkedHashMap<String, Object>>>();
        root.put("hostAliases", hostAlias);
        Yaml yaml = new Yaml();
        return yaml.dumpAsMap(root);
    }

    public static final /* synthetic */ boolean $anonfun$extractHostAliasMap$3(String x$3) {
        return StringUtils.isNotBlank((CharSequence)x$3);
    }

    private PodTemplateParser$() {
        MODULE$ = this;
        this.POD_TEMPLATE_INIT_CONTENT = new StringOps(Predef$.MODULE$.augmentString("apiVersion: v1\n      |kind: Pod\n      |metadata:\n      |  name: pod-template\n      |")).stripMargin();
    }
}

