/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.sink;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.api.common.state.ListStateDescriptor;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.array.BytePrimitiveArraySerializer;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.runtime.state.StateInitializationContext;
import org.apache.flink.shaded.guava30.com.google.common.collect.Iterables;
import org.apache.flink.streaming.api.operators.util.SimpleVersionedListState;
import org.apache.flink.streaming.runtime.operators.sink.SinkWriterStateHandler;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.function.FunctionWithException;

@Internal
final class StatefulSinkWriterStateHandler<WriterStateT>
implements SinkWriterStateHandler<WriterStateT> {
    private static final ListStateDescriptor<byte[]> WRITER_RAW_STATES_DESC = new ListStateDescriptor("writer_raw_states", (TypeSerializer)BytePrimitiveArraySerializer.INSTANCE);
    private final SimpleVersionedSerializer<WriterStateT> writerStateSimpleVersionedSerializer;
    private final Collection<String> previousSinkStateNames;
    private List<ListState<WriterStateT>> previousSinkStates = new ArrayList<ListState<WriterStateT>>();
    private ListState<WriterStateT> writerState;

    public StatefulSinkWriterStateHandler(SimpleVersionedSerializer<WriterStateT> writerStateSimpleVersionedSerializer, Collection<String> previousSinkStateNames) {
        this.writerStateSimpleVersionedSerializer = writerStateSimpleVersionedSerializer;
        this.previousSinkStateNames = previousSinkStateNames;
    }

    @Override
    public List<WriterStateT> initializeState(StateInitializationContext context) throws Exception {
        ListState rawState = context.getOperatorStateStore().getListState(WRITER_RAW_STATES_DESC);
        this.writerState = new SimpleVersionedListState<WriterStateT>((ListState<byte[]>)rawState, this.writerStateSimpleVersionedSerializer);
        List writerStates = CollectionUtil.iterableToList((Iterable)((Iterable)this.writerState.get()));
        ArrayList states = new ArrayList(writerStates);
        for (String previousSinkStateName : this.previousSinkStateNames) {
            ListStateDescriptor preSinkStateDesc = new ListStateDescriptor(previousSinkStateName, (TypeSerializer)BytePrimitiveArraySerializer.INSTANCE);
            ListState preRawState = context.getOperatorStateStore().getListState(preSinkStateDesc);
            SimpleVersionedListState<WriterStateT> previousSinkState = new SimpleVersionedListState<WriterStateT>((ListState<byte[]>)preRawState, this.writerStateSimpleVersionedSerializer);
            this.previousSinkStates.add(previousSinkState);
            Iterables.addAll(states, (Iterable)previousSinkState.get());
        }
        return states;
    }

    @Override
    public void snapshotState(FunctionWithException<Long, List<WriterStateT>, Exception> stateExtractor, long checkpointId) throws Exception {
        this.writerState.update((List)stateExtractor.apply((Object)checkpointId));
        this.previousSinkStates.forEach(State::clear);
    }
}

