/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.api.model.RootPaths;
import io.fabric8.kubernetes.client.Adapters;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.ExtensionAdapter;
import io.fabric8.kubernetes.client.HttpClientAware;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.base.BaseOperation;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.kubernetes.client.utils.HttpClientUtils;
import io.fabric8.kubernetes.client.utils.Utils;
import java.net.URL;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.flink.kubernetes.shaded.okhttp3.ConnectionPool;
import org.apache.flink.kubernetes.shaded.okhttp3.Dispatcher;
import org.apache.flink.kubernetes.shaded.okhttp3.OkHttpClient;

public abstract class BaseClient
implements Client,
HttpClientAware {
    protected OkHttpClient httpClient;
    private URL masterUrl;
    private String apiVersion;
    private String namespace;
    private Config configuration;

    public BaseClient() {
        this(new ConfigBuilder().build());
    }

    public BaseClient(String masterUrl) {
        this(((ConfigBuilder)new ConfigBuilder().withMasterUrl(masterUrl)).build());
    }

    public BaseClient(Config config) {
        this(HttpClientUtils.createHttpClient(config), config);
    }

    public BaseClient(OkHttpClient httpClient, Config config) {
        try {
            this.httpClient = httpClient;
            this.namespace = config.getNamespace();
            this.configuration = config;
            this.apiVersion = config.getApiVersion();
            if (config.getMasterUrl() == null) {
                throw new KubernetesClientException("Unknown Kubernetes master URL - please set with the builder, or set with either system property \"kubernetes.master\" or environment variable \"" + Utils.convertSystemPropertyNameToEnvVar("kubernetes.master") + "\"");
            }
            this.masterUrl = new URL(config.getMasterUrl());
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public void close() {
        ExecutorService executorService;
        ConnectionPool connectionPool = this.httpClient.connectionPool();
        Dispatcher dispatcher = this.httpClient.dispatcher();
        ExecutorService executorService2 = executorService = this.httpClient.dispatcher() != null ? this.httpClient.dispatcher().executorService() : null;
        if (dispatcher != null) {
            dispatcher.cancelAll();
        }
        if (connectionPool != null) {
            connectionPool.evictAll();
        }
        if (executorService != null) {
            executorService.shutdownNow();
        }
    }

    @Override
    public URL getMasterUrl() {
        return this.masterUrl;
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public Config getConfiguration() {
        return this.configuration;
    }

    @Override
    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    @Override
    public <C> Boolean isAdaptable(Class<C> type) {
        ExtensionAdapter<C> adapter = Adapters.get(type);
        if (adapter != null) {
            return adapter.isAdaptable(this);
        }
        return false;
    }

    @Override
    public <C> C adapt(Class<C> type) {
        ExtensionAdapter<C> adapter = Adapters.get(type);
        if (adapter != null) {
            return adapter.adapt(this);
        }
        throw new IllegalStateException("No adapter available for type:" + type);
    }

    @Override
    public RootPaths rootPaths() {
        return new BaseOperation(new OperationContext().withOkhttpClient(this.httpClient).withConfig(this.configuration)){}.getRootPaths();
    }

    @Override
    public boolean supportsApiPath(String apiPath) {
        List<String> paths;
        RootPaths rootPaths = this.rootPaths();
        if (rootPaths != null && (paths = rootPaths.getPaths()) != null) {
            for (String path : paths) {
                if (!path.equals(apiPath)) continue;
                return true;
            }
        }
        return false;
    }
}

