/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.serialization;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.serialization.Encoder;

@PublicEvolving
public class SimpleStringEncoder<IN>
implements Encoder<IN> {
    private static final long serialVersionUID = -6865107843734614452L;
    private String charsetName;
    private transient Charset charset;

    public SimpleStringEncoder() {
        this("UTF-8");
    }

    public SimpleStringEncoder(String charsetName) {
        this.charsetName = charsetName;
    }

    @Override
    public void encode(IN element, OutputStream stream) throws IOException {
        if (this.charset == null) {
            this.charset = Charset.forName(this.charsetName);
        }
        stream.write(element.toString().getBytes(this.charset));
        stream.write(10);
    }
}

