/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.flink.annotation.Public;
import org.apache.flink.api.java.Utils;
import org.apache.flink.api.java.utils.AbstractParameterTool;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.Preconditions;

@Public
public class ParameterTool
extends AbstractParameterTool {
    private static final long serialVersionUID = 1L;
    protected final Map<String, String> data;

    public static ParameterTool fromArgs(String[] args) {
        HashMap<String, String> map = new HashMap<String, String>(args.length / 2);
        int i = 0;
        while (i < args.length) {
            String key = Utils.getKeyFromArgs(args, i);
            if (key.isEmpty()) {
                throw new IllegalArgumentException("The input " + Arrays.toString(args) + " contains an empty argument");
            }
            if (++i >= args.length) {
                map.put(key, "__NO_VALUE_KEY");
                continue;
            }
            if (NumberUtils.isNumber((String)args[i])) {
                map.put(key, args[i]);
                ++i;
                continue;
            }
            if (args[i].startsWith("--") || args[i].startsWith("-")) {
                map.put(key, "__NO_VALUE_KEY");
                continue;
            }
            map.put(key, args[i]);
            ++i;
        }
        return ParameterTool.fromMap(map);
    }

    public static ParameterTool fromPropertiesFile(String path) throws IOException {
        File propertiesFile = new File(path);
        return ParameterTool.fromPropertiesFile(propertiesFile);
    }

    public static ParameterTool fromPropertiesFile(File file) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException("Properties file " + file.getAbsolutePath() + " does not exist");
        }
        try (FileInputStream fis = new FileInputStream(file);){
            ParameterTool parameterTool = ParameterTool.fromPropertiesFile(fis);
            return parameterTool;
        }
    }

    public static ParameterTool fromPropertiesFile(InputStream inputStream) throws IOException {
        Properties props = new Properties();
        props.load(inputStream);
        return ParameterTool.fromMap(props);
    }

    public static ParameterTool fromMap(Map<String, String> map) {
        Preconditions.checkNotNull(map, (String)"Unable to initialize from empty map");
        return new ParameterTool(map);
    }

    public static ParameterTool fromSystemProperties() {
        return ParameterTool.fromMap(System.getProperties());
    }

    private ParameterTool(Map<String, String> data) {
        this.data = Collections.unmodifiableMap(new HashMap<String, String>(data));
        this.defaultData = new ConcurrentHashMap(data.size());
        this.unrequestedParameters = Collections.newSetFromMap(new ConcurrentHashMap(data.size()));
        this.unrequestedParameters.addAll(data.keySet());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParameterTool that = (ParameterTool)o;
        return Objects.equals(this.data, that.data) && Objects.equals(this.defaultData, that.defaultData) && Objects.equals(this.unrequestedParameters, that.unrequestedParameters);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.defaultData, this.unrequestedParameters);
    }

    @Override
    public int getNumberOfParameters() {
        return this.data.size();
    }

    @Override
    public String get(String key) {
        this.addToDefaults(key, null);
        this.unrequestedParameters.remove(key);
        return this.data.get(key);
    }

    @Override
    public boolean has(String value) {
        this.addToDefaults(value, null);
        this.unrequestedParameters.remove(value);
        return this.data.containsKey(value);
    }

    public Configuration getConfiguration() {
        Configuration conf = new Configuration();
        for (Map.Entry<String, String> entry : this.data.entrySet()) {
            conf.setString(entry.getKey(), entry.getValue());
        }
        return conf;
    }

    public Properties getProperties() {
        Properties props = new Properties();
        props.putAll(this.data);
        return props;
    }

    public void createPropertiesFile(String pathToFile) throws IOException {
        this.createPropertiesFile(pathToFile, true);
    }

    public void createPropertiesFile(String pathToFile, boolean overwrite) throws IOException {
        File file = new File(pathToFile);
        if (file.exists()) {
            if (overwrite) {
                file.delete();
            } else {
                throw new RuntimeException("File " + pathToFile + " exists and overwriting is not allowed");
            }
        }
        Properties defaultProps = new Properties();
        defaultProps.putAll((Map<?, ?>)this.defaultData);
        try (FileOutputStream out = new FileOutputStream(file);){
            defaultProps.store(out, "Default file created by Flink's ParameterUtil.createPropertiesFile()");
        }
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return new ParameterTool(this.data);
    }

    public ParameterTool mergeWith(ParameterTool other) {
        HashMap<String, String> resultData = new HashMap<String, String>(this.data.size() + other.data.size());
        resultData.putAll(this.data);
        resultData.putAll(other.data);
        ParameterTool ret = new ParameterTool(resultData);
        HashSet<String> requestedParametersLeft = new HashSet<String>(this.data.keySet());
        requestedParametersLeft.removeAll(this.unrequestedParameters);
        HashSet<String> requestedParametersRight = new HashSet<String>(other.data.keySet());
        requestedParametersRight.removeAll(other.unrequestedParameters);
        ret.unrequestedParameters.removeAll(requestedParametersLeft);
        ret.unrequestedParameters.removeAll(requestedParametersRight);
        return ret;
    }

    @Override
    public Map<String, String> toMap() {
        return this.data;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.defaultData = new ConcurrentHashMap(this.data.size());
        this.unrequestedParameters = Collections.newSetFromMap(new ConcurrentHashMap(this.data.size()));
    }
}

