/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.sink;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.flink.api.connector.sink.Committer;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.streaming.runtime.operators.sink.AbstractStreamingCommitterHandler;
import org.apache.flink.util.Preconditions;

final class StreamingCommitterHandler<CommT>
extends AbstractStreamingCommitterHandler<CommT, CommT> {
    private final Committer<CommT> committer;

    public StreamingCommitterHandler(Committer<CommT> committer, SimpleVersionedSerializer<CommT> committableSerializer) {
        super(committableSerializer);
        this.committer = (Committer)Preconditions.checkNotNull(committer);
    }

    @Override
    List<CommT> prepareCommit(List<CommT> input) {
        return this.prependRecoveredCommittables((List)Preconditions.checkNotNull(input));
    }

    @Override
    List<CommT> commit(List<CommT> committables) throws IOException, InterruptedException {
        return this.committer.commit((List)Preconditions.checkNotNull(committables));
    }

    @Override
    public void close() throws Exception {
        this.committer.close();
        super.close();
    }

    @Override
    public Collection<CommT> notifyCheckpointCompleted(long checkpointId) throws IOException, InterruptedException {
        return this.commitUpTo(checkpointId);
    }
}

