/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.operators.sink;

import java.io.IOException;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.connector.sink.Committer;
import org.apache.flink.api.connector.sink.GlobalCommitter;
import org.apache.flink.api.connector.sink.Sink;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.streaming.api.operators.AbstractStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.OneInputStreamOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;
import org.apache.flink.streaming.runtime.operators.sink.BatchCommitterHandler;
import org.apache.flink.streaming.runtime.operators.sink.CommitterHandler;
import org.apache.flink.streaming.runtime.operators.sink.CommitterOperator;
import org.apache.flink.streaming.runtime.operators.sink.GlobalBatchCommitterHandler;
import org.apache.flink.streaming.runtime.operators.sink.GlobalStreamingCommitterHandler;
import org.apache.flink.streaming.runtime.operators.sink.NoopCommitterHandler;
import org.apache.flink.util.Preconditions;

@Internal
public final class CommitterOperatorFactory<CommT, GlobalCommT>
extends AbstractStreamOperatorFactory<byte[]>
implements OneInputStreamOperatorFactory<byte[], byte[]> {
    private final Sink<?, CommT, ?, GlobalCommT> sink;
    private final boolean batch;

    public CommitterOperatorFactory(Sink<?, CommT, ?, GlobalCommT> sink, boolean batch) {
        this.sink = sink;
        this.batch = batch;
    }

    @Override
    public <T extends StreamOperator<byte[]>> T createStreamOperator(StreamOperatorParameters<byte[]> parameters) {
        SimpleVersionedSerializer committableSerializer = (SimpleVersionedSerializer)this.sink.getCommittableSerializer().orElseThrow(this::noSerializerFound);
        try {
            Optional committer;
            CommitterHandler<CommT, GlobalCommT> committerHandler = this.getGlobalCommitterHandler();
            if (this.batch && (committer = this.sink.createCommitter()).isPresent()) {
                committerHandler = new BatchCommitterHandler<CommT, GlobalCommT>((Committer)committer.get(), committerHandler);
            }
            Preconditions.checkState((!(committerHandler instanceof NoopCommitterHandler) ? 1 : 0) != 0, (Object)"committer operator without commmitter");
            CommitterOperator<CommT, GlobalCommT> committerOperator = new CommitterOperator<CommT, GlobalCommT>(this.processingTimeService, committableSerializer, committerHandler);
            committerOperator.setup(parameters.getContainingTask(), parameters.getStreamConfig(), parameters.getOutput());
            return (T)committerOperator;
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot create commit operator of " + this.sink, e);
        }
    }

    private IllegalStateException noSerializerFound() {
        return new IllegalStateException(this.sink.getClass() + " does not implement getCommittableSerializer which is needed for any (global) committer.");
    }

    private CommitterHandler<CommT, GlobalCommT> getGlobalCommitterHandler() throws IOException {
        Optional globalCommitter = this.sink.createGlobalCommitter();
        if (!globalCommitter.isPresent()) {
            return NoopCommitterHandler.getInstance();
        }
        if (this.batch) {
            return new GlobalBatchCommitterHandler((GlobalCommitter)globalCommitter.get());
        }
        SimpleVersionedSerializer serializer = (SimpleVersionedSerializer)this.sink.getGlobalCommittableSerializer().orElseThrow(this::noGlobalSerializerFound);
        return new GlobalStreamingCommitterHandler((GlobalCommitter)globalCommitter.get(), serializer);
    }

    private IllegalStateException noGlobalSerializerFound() {
        return new IllegalStateException(this.sink.getClass() + " does not implement getGlobalCommittableSerializer which is needed for streaming global committers.");
    }

    @Override
    public Class<? extends StreamOperator> getStreamOperatorClass(ClassLoader classLoader) {
        return CommitterOperator.class;
    }
}

