/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.system.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.streampark.console.base.domain.ResponseCode;
import org.apache.streampark.console.base.domain.RestRequest;
import org.apache.streampark.console.base.domain.RestResponse;
import org.apache.streampark.console.base.exception.ApiAlertException;
import org.apache.streampark.console.core.annotation.PermissionScope;
import org.apache.streampark.console.core.enums.LoginType;
import org.apache.streampark.console.core.service.ServiceHelper;
import org.apache.streampark.console.system.entity.Team;
import org.apache.streampark.console.system.entity.User;
import org.apache.streampark.console.system.service.TeamService;
import org.apache.streampark.console.system.service.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"user"})
public class UserController {
    private static final Logger log = LoggerFactory.getLogger(UserController.class);
    @Autowired
    private UserService userService;
    @Autowired
    private TeamService teamService;
    @Autowired
    private ServiceHelper serviceHelper;

    @PostMapping(value={"list"})
    @RequiresPermissions(value={"user:view"})
    public RestResponse userList(RestRequest restRequest, User user) {
        IPage<User> userList = this.userService.page(user, restRequest);
        return RestResponse.success(userList);
    }

    @PostMapping(value={"post"})
    @RequiresPermissions(value={"user:add"})
    public RestResponse addUser(@Valid User user) throws Exception {
        user.setLoginType(LoginType.PASSWORD);
        this.userService.createUser(user);
        return RestResponse.success();
    }

    @PutMapping(value={"update"})
    @PermissionScope(user="#user.id")
    @RequiresPermissions(value={"user:update"})
    public RestResponse updateUser(@Valid User user) throws Exception {
        this.userService.updateUser(user);
        return RestResponse.success();
    }

    @DeleteMapping(value={"delete"})
    @PermissionScope(user="#userId")
    @RequiresPermissions(value={"user:delete"})
    public RestResponse deleteUser(Long userId) throws Exception {
        this.userService.deleteUser(userId);
        return RestResponse.success();
    }

    @RequiresPermissions(value={"token:add"})
    @PostMapping(value={"getNoTokenUser"})
    public RestResponse getNoTokenUser() {
        List<User> userList = this.userService.getNoTokenUser();
        return RestResponse.success(userList);
    }

    @PostMapping(value={"check/name"})
    public RestResponse checkUserName(@NotBlank(message="{required}") @NotBlank(message="{required}") String username) {
        boolean result = this.userService.findByName(username) == null;
        return RestResponse.success(result);
    }

    @PermissionScope(user="#user.id")
    @PutMapping(value={"password"})
    public RestResponse updatePassword(User user) throws Exception {
        this.userService.updatePassword(user);
        return RestResponse.success();
    }

    @PutMapping(value={"password/reset"})
    @RequiresPermissions(value={"user:reset"})
    public RestResponse resetPassword(@NotBlank(message="{required}") @NotBlank(message="{required}") String username) throws Exception {
        String newPass = this.userService.resetPassword(username);
        return RestResponse.success(newPass);
    }

    @PostMapping(value={"initTeam"})
    public RestResponse initTeam(Long teamId, Long userId) {
        Team team = (Team)this.teamService.getById(teamId);
        if (team == null) {
            return RestResponse.fail("teamId is invalid", ResponseCode.CODE_FAIL_ALERT);
        }
        this.userService.setLastTeam(teamId, userId);
        return RestResponse.success();
    }

    @PostMapping(value={"setTeam"})
    public RestResponse setTeam(Long teamId) {
        Team team = (Team)this.teamService.getById(teamId);
        if (team == null) {
            return RestResponse.fail("TeamId is invalid, set team failed.", ResponseCode.CODE_FAIL_ALERT);
        }
        User user = this.serviceHelper.getLoginUser();
        ApiAlertException.throwIfNull(user, "Current login user is null, set team failed.");
        this.userService.setLastTeam(teamId, user.getUserId());
        user.dataMasking();
        Map<String, Object> infoMap = this.userService.generateFrontendUserInfo(user, teamId, null);
        return new RestResponse().data(infoMap);
    }

    @PostMapping(value={"appOwners"})
    public RestResponse appOwners(Long teamId) {
        List<User> userList = this.userService.findByAppOwner(teamId);
        userList.forEach(User::dataMasking);
        return RestResponse.success(userList);
    }
}

