/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.base.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GZipUtils {
    private static final Logger log = LoggerFactory.getLogger(GZipUtils.class);

    private GZipUtils() {
    }

    public static File decompress(String tarZipSource, String targetDir) {
        File unFile = null;
        ArchiveStreamFactory archiveStreamFactory = new ArchiveStreamFactory();
        try (FileInputStream inputStream = new FileInputStream(tarZipSource);
             BufferedInputStream bufInput = new BufferedInputStream(inputStream);
             GZIPInputStream gzipInput = new GZIPInputStream(bufInput);
             ArchiveInputStream archiveInput = archiveStreamFactory.createArchiveInputStream("tar", (InputStream)gzipInput);){
            TarArchiveEntry entry = (TarArchiveEntry)archiveInput.getNextEntry();
            while (entry != null) {
                String entryName = entry.getName();
                if (entry.isDirectory()) {
                    GZipUtils.createDir(targetDir, entryName, 1);
                    if (unFile == null) {
                        unFile = new File(targetDir + entryName.replaceAll("/.*$", ""));
                    }
                } else if (entry.isFile()) {
                    String fullFileName = GZipUtils.createDir(targetDir, entryName, 2);
                    try (FileOutputStream outputStream = new FileOutputStream(fullFileName);
                         BufferedOutputStream bufOutput = new BufferedOutputStream(outputStream);){
                        int b = -1;
                        while ((b = archiveInput.read()) != -1) {
                            bufOutput.write(b);
                        }
                    }
                }
                entry = (TarArchiveEntry)archiveInput.getNextEntry();
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return unFile;
    }

    private static String createDir(String baseDir, String entry, int type) {
        String[] items = entry.split("/");
        String fullFilePath = baseDir;
        for (int i = 0; i < items.length; ++i) {
            File tmpFile;
            String item = items[i];
            fullFilePath = fullFilePath + File.separator + item;
            if (type == 2) {
                if (i == items.length - 1 || (tmpFile = new File(fullFilePath)).exists()) continue;
                tmpFile.mkdir();
                continue;
            }
            tmpFile = new File(fullFilePath);
            if (tmpFile.exists()) continue;
            tmpFile.mkdir();
        }
        File fullFile = new File(fullFilePath);
        return fullFile.getAbsolutePath();
    }
}

