/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.flink.kubernetes.helper;

import com.google.common.base.Charsets;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodStatus;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.Filterable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Listable;
import io.fabric8.kubernetes.client.dsl.Loggable;
import io.fabric8.kubernetes.client.dsl.Nameable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Prettyable;
import io.fabric8.kubernetes.client.dsl.Terminateable;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.apache.streampark.common.util.Logger;
import org.apache.streampark.common.util.SystemPropertyUtils$;
import org.apache.streampark.common.util.Utils$;
import org.apache.streampark.flink.kubernetes.KubernetesRetriever$;
import scala.Function0;
import scala.Function1;
import scala.collection.JavaConversions$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.java8.JFunction0;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class KubernetesDeploymentHelper$
implements Logger {
    public static KubernetesDeploymentHelper$ MODULE$;
    private transient org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger;
    private final String org$apache$streampark$common$util$Logger$$prefix;

    static {
        new KubernetesDeploymentHelper$();
    }

    public String logName() {
        return Logger.logName$((Logger)this);
    }

    public org.apache.streampark.shaded.org.slf4j.Logger logger() {
        return Logger.logger$((Logger)this);
    }

    public void logInfo(Function0<String> msg) {
        Logger.logInfo$((Logger)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logger.logInfo$((Logger)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logger.logDebug$((Logger)this, msg);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logger.logDebug$((Logger)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logger.logTrace$((Logger)this, msg);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logger.logTrace$((Logger)this, msg, (Throwable)throwable);
    }

    public void logWarn(Function0<String> msg) {
        Logger.logWarn$((Logger)this, msg);
    }

    public void logWarn(Function0<String> msg, Throwable throwable) {
        Logger.logWarn$((Logger)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logger.logError$((Logger)this, msg);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logger.logError$((Logger)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logger.isTraceEnabled$((Logger)this);
    }

    public org.apache.streampark.shaded.org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger() {
        return this.org$apache$streampark$common$util$Logger$$_logger;
    }

    public void org$apache$streampark$common$util$Logger$$_logger_$eq(org.apache.streampark.shaded.org.slf4j.Logger x$1) {
        this.org$apache$streampark$common$util$Logger$$_logger = x$1;
    }

    public String org$apache$streampark$common$util$Logger$$prefix() {
        return this.org$apache$streampark$common$util$Logger$$prefix;
    }

    public final void org$apache$streampark$common$util$Logger$_setter_$org$apache$streampark$common$util$Logger$$prefix_$eq(String x$1) {
        this.org$apache$streampark$common$util$Logger$$prefix = x$1;
    }

    private List<Pod> getPods(String nameSpace, String deploymentName) {
        KubernetesClient x$1 = KubernetesRetriever$.MODULE$.newK8sClient();
        Function1 & Serializable & scala.Serializable x$2 = (Function1 & Serializable & scala.Serializable)client -> (List)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(((PodList)((Listable)((Filterable)client.pods().inNamespace(nameSpace)).withLabels(((Deployment)((Gettable)((Nameable)client.apps().deployments().inNamespace(nameSpace)).withName(deploymentName)).get()).getSpec().getSelector().getMatchLabels())).list()).getItems()).toList()).getOrElse((Function0 & Serializable & scala.Serializable)() -> List$.MODULE$.empty());
        Null$ x$3 = Utils$.MODULE$.using$default$3((AutoCloseable)x$1, (Function1)x$2);
        return (List)Utils$.MODULE$.using((AutoCloseable)x$1, (Function1)x$2, null);
    }

    public boolean isDeploymentError(String nameSpace, String deploymentName) {
        return BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            List<Pod> pods = MODULE$.getPods(nameSpace, deploymentName);
            PodStatus podStatus = ((Pod)pods.head()).getStatus();
            String string = podStatus.getPhase();
            boolean bl = "Unknown".equals(string) ? true : ("Failed".equals(string) ? true : ("Pending".equals(string) ? false : ((ContainerStatus)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(podStatus.getContainerStatuses()).head()).getLastState().getTerminated() != null));
            return bl;
        }).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> true));
    }

    private void deleteDeployment(String nameSpace, String deploymentName) {
        KubernetesClient x$1 = KubernetesRetriever$.MODULE$.newK8sClient();
        Function1 & Serializable & scala.Serializable x$2 = (Function1 & Serializable & scala.Serializable)client -> {
            NonNamespaceOperation map = (NonNamespaceOperation)client.apps().deployments().inNamespace(nameSpace);
            ((Deletable)map.withLabel("app", deploymentName)).delete();
            return ((Deletable)map.withName(deploymentName)).delete();
        };
        Null$ x$3 = Utils$.MODULE$.using$default$3((AutoCloseable)x$1, (Function1)x$2);
        Utils$.MODULE$.using((AutoCloseable)x$1, (Function1)x$2, null);
    }

    private void deleteConfigMap(String nameSpace, String deploymentName) {
        KubernetesClient x$1 = KubernetesRetriever$.MODULE$.newK8sClient();
        Function1 & Serializable & scala.Serializable x$2 = (Function1 & Serializable & scala.Serializable)client -> {
            NonNamespaceOperation map = (NonNamespaceOperation)client.configMaps().inNamespace(nameSpace);
            ((Deletable)map.withLabel("app", deploymentName)).delete();
            return ((Deletable)map.withName(deploymentName)).delete();
        };
        Null$ x$3 = Utils$.MODULE$.using$default$3((AutoCloseable)x$1, (Function1)x$2);
        Utils$.MODULE$.using((AutoCloseable)x$1, (Function1)x$2, null);
    }

    public void delete(String nameSpace, String deploymentName) {
        this.deleteDeployment(nameSpace, deploymentName);
        this.deleteConfigMap(nameSpace, deploymentName);
    }

    public boolean checkConnection() {
        boolean bl;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> new DefaultKubernetesClient());
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            DefaultKubernetesClient client = (DefaultKubernetesClient)success.value();
            client.close();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public String watchDeploymentLog(String nameSpace, String jobName, String jobId) {
        KubernetesClient x$1 = KubernetesRetriever$.MODULE$.newK8sClient();
        Function1 & Serializable & scala.Serializable x$2 = (Function1 & Serializable & scala.Serializable)client -> {
            String path = MODULE$.getJobLog(jobId);
            File file = new File(path);
            String log = ((Loggable)((Nameable)client.apps().deployments().inNamespace(nameSpace)).withName(jobName)).getLog();
            Files.asCharSink((File)file, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)log);
            return path;
        };
        Null$ x$3 = Utils$.MODULE$.using$default$3((AutoCloseable)x$1, (Function1)x$2);
        return (String)Utils$.MODULE$.using((AutoCloseable)x$1, (Function1)x$2, null);
    }

    public String watchPodTerminatedLog(String nameSpace, String jobName, String jobId) {
        return (String)Utils$.MODULE$.using((AutoCloseable)KubernetesRetriever$.MODULE$.newK8sClient(), (Function1 & Serializable & scala.Serializable)client -> (String)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            String podName = ((Pod)MODULE$.getPods(nameSpace, jobName).head()).getMetadata().getName();
            String path = MODULE$.getJobErrorLog(jobId);
            File file = new File(path);
            String log = ((Loggable)((Prettyable)((Terminateable)((Nameable)client.pods().inNamespace(nameSpace)).withName(podName)).terminated()).withPrettyOutput()).getLog();
            Files.asCharSink((File)file, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)log);
            return path;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> null), (Function1 & Serializable & scala.Serializable)error -> {
            throw error;
        });
    }

    public String getJobLog(String jobId) {
        String tmpPath = SystemPropertyUtils$.MODULE$.getTmpdir();
        return new StringBuilder(5).append(tmpPath).append("/").append(jobId).append(".log").toString();
    }

    public String getJobErrorLog(String jobId) {
        String tmpPath = SystemPropertyUtils$.MODULE$.getTmpdir();
        return new StringBuilder(9).append(tmpPath).append("/").append(jobId).append("_err.log").toString();
    }

    private KubernetesDeploymentHelper$() {
        MODULE$ = this;
        Logger.$init$((Logger)this);
    }
}

