/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.runner;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.streampark.common.conf.CommonConfig;
import org.apache.streampark.common.conf.ConfigConst;
import org.apache.streampark.common.conf.InternalConfigHolder;
import org.apache.streampark.common.conf.InternalOption;
import org.apache.streampark.common.conf.Workspace;
import org.apache.streampark.common.enums.StorageType;
import org.apache.streampark.common.fs.FsOperator;
import org.apache.streampark.common.util.SystemPropertyUtils;
import org.apache.streampark.common.util.Utils;
import org.apache.streampark.console.base.util.WebUtils;
import org.apache.streampark.console.core.bean.MavenConfig;
import org.apache.streampark.console.core.entity.FlinkEnv;
import org.apache.streampark.console.core.service.SettingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Order
@Component
public class EnvInitializer
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(EnvInitializer.class);
    @Autowired
    private ApplicationContext context;
    @Autowired
    private SettingService settingService;
    private final Set<StorageType> initialized = new HashSet<StorageType>(2);
    private final FileFilter fileFilter = p -> !".gitkeep".equals(p.getName());
    private static final Pattern PATTERN_FLINK_SHIMS_JAR = Pattern.compile("^streampark-flink-shims_flink-(1.1[2-8])_(2.11|2.12)-(.*).jar$", 34);

    public void run(ApplicationArguments args) throws Exception {
        Optional<String> profile = Arrays.stream(this.context.getEnvironment().getActiveProfiles()).findFirst();
        if ("test".equals(profile.orElse(null))) {
            return;
        }
        String appHome = WebUtils.getAppHome();
        if (appHome == null) {
            throw new ExceptionInInitializerError(String.format("[StreamPark] System initialization check failed, The system initialization check failed. If started local for development and debugging, please ensure the -D%s parameter is clearly specified, more detail: https://streampark.apache.org/docs/user-guide/development", ConfigConst.KEY_APP_HOME()));
        }
        this.initInternalConfig(this.context.getEnvironment());
        String hadoopUserName = (String)InternalConfigHolder.get((InternalOption)CommonConfig.STREAMPARK_HADOOP_USER_NAME());
        this.overrideSystemProp(ConfigConst.KEY_HADOOP_USER_NAME(), hadoopUserName);
        this.storageInitialize(StorageType.LFS);
    }

    private void initInternalConfig(Environment springEnv) {
        InternalConfigHolder.keys().stream().filter(arg_0 -> ((Environment)springEnv).containsProperty(arg_0)).forEach(key -> {
            InternalOption config = InternalConfigHolder.getConfig((String)key);
            Utils.notNull((Object)config);
            InternalConfigHolder.set((InternalOption)config, (Object)springEnv.getProperty(key, config.classType()));
        });
        MavenConfig.fromSetting().updateConfig();
        InternalConfigHolder.log();
    }

    private void overrideSystemProp(String key, String defaultValue) {
        String value = this.context.getEnvironment().getProperty(key, defaultValue);
        log.info("initialize system properties: key:{}, value:{}", (Object)key, (Object)value);
        SystemPropertyUtils.set((String)key, (String)value);
    }

    public synchronized void storageInitialize(StorageType storageType) {
        File client;
        String appJars;
        String appSavePoints;
        String appBackups;
        String appWorkspace;
        String appUploads;
        String localDist;
        if (this.initialized.contains(storageType)) {
            return;
        }
        String mkdirLog = "storage initialize, now mkdir [{}] starting ...";
        FsOperator fsOperator = FsOperator.of((StorageType)storageType);
        Workspace workspace = Workspace.of((StorageType)storageType);
        if (storageType.equals((Object)StorageType.LFS) && !fsOperator.exists(localDist = Workspace.APP_LOCAL_DIST())) {
            log.info("storage initialize, now mkdir [{}] starting ...", (Object)localDist);
            fsOperator.mkdirs(localDist);
        }
        if (!fsOperator.exists(appUploads = workspace.APP_UPLOADS())) {
            log.info("storage initialize, now mkdir [{}] starting ...", (Object)appUploads);
            fsOperator.mkdirs(appUploads);
        }
        if (!fsOperator.exists(appWorkspace = workspace.APP_WORKSPACE())) {
            log.info("storage initialize, now mkdir [{}] starting ...", (Object)appWorkspace);
            fsOperator.mkdirs(appWorkspace);
        }
        if (!fsOperator.exists(appBackups = workspace.APP_BACKUPS())) {
            log.info("storage initialize, now mkdir [{}] starting ...", (Object)appBackups);
            fsOperator.mkdirs(appBackups);
        }
        if (!fsOperator.exists(appSavePoints = workspace.APP_SAVEPOINTS())) {
            log.info("storage initialize, now mkdir [{}] starting ...", (Object)appSavePoints);
            fsOperator.mkdirs(appSavePoints);
        }
        if (!fsOperator.exists(appJars = workspace.APP_JARS())) {
            log.info("storage initialize, now mkdir [{}] starting ...", (Object)appJars);
            fsOperator.mkdirs(appJars);
        }
        Utils.required(((client = WebUtils.getAppClientDir()).exists() && client.listFiles().length > 0 ? 1 : 0) != 0, (Object)client.getAbsolutePath().concat(" is not exists or empty directory "));
        String appClient = workspace.APP_CLIENT();
        fsOperator.mkCleanDirs(appClient);
        for (File file : client.listFiles(this.fileFilter)) {
            log.info("load client:{} to {}", (Object)file.getName(), (Object)appClient);
            fsOperator.upload(file.getAbsolutePath(), appClient);
        }
        String appPlugins = workspace.APP_PLUGINS();
        fsOperator.mkCleanDirs(appPlugins);
        File plugins = WebUtils.getAppPluginsDir();
        for (File file : plugins.listFiles(this.fileFilter)) {
            log.info("load plugin:{} to {}", (Object)file.getName(), (Object)appPlugins);
            fsOperator.upload(file.getAbsolutePath(), appPlugins);
        }
        File[] shims = WebUtils.getAppLibDir().listFiles(pathname -> pathname.getName().matches(PATTERN_FLINK_SHIMS_JAR.pattern()));
        Utils.required((shims != null && shims.length > 0 ? 1 : 0) != 0, (Object)"streampark-flink-shims jar not exist");
        String appShims = workspace.APP_SHIMS();
        fsOperator.delete(appShims);
        for (File file : shims) {
            Matcher matcher = PATTERN_FLINK_SHIMS_JAR.matcher(file.getName());
            if (!matcher.matches()) continue;
            String version = matcher.group(1);
            String shimsPath = appShims.concat("/flink-").concat(version);
            fsOperator.mkdirs(shimsPath);
            log.info("load shims:{} to {}", (Object)file.getName(), (Object)shimsPath);
            fsOperator.upload(file.getAbsolutePath(), shimsPath);
        }
        String localMavenRepo = Workspace.MAVEN_LOCAL_PATH();
        if (FsOperator.lfs().exists(localMavenRepo)) {
            FsOperator.lfs().mkdirs(localMavenRepo);
        }
        this.initialized.add(storageType);
    }

    public void checkFlinkEnv(StorageType storageType, FlinkEnv flinkEnv) throws IOException {
        File flinkLocalDir;
        String flinkLocalHome = flinkEnv.getFlinkHome();
        if (flinkLocalHome == null) {
            throw new ExceptionInInitializerError("[StreamPark] FLINK_HOME is undefined,Make sure that Flink is installed.");
        }
        Workspace workspace = Workspace.of((StorageType)storageType);
        String appFlink = workspace.APP_FLINK();
        FsOperator fsOperator = FsOperator.of((StorageType)storageType);
        if (!fsOperator.exists(appFlink)) {
            log.info("checkFlinkEnv, now mkdir [{}] starting ...", (Object)appFlink);
            fsOperator.mkdirs(appFlink);
        }
        if (Files.isSymbolicLink((flinkLocalDir = new File(flinkLocalHome)).toPath())) {
            flinkLocalDir = flinkLocalDir.getCanonicalFile();
        }
        String flinkName = flinkLocalDir.getName();
        String flinkHome = appFlink.concat("/").concat(flinkName);
        if (!fsOperator.exists(flinkHome)) {
            log.info("{} is not exists,upload beginning....", (Object)flinkHome);
            fsOperator.upload(flinkLocalHome, flinkHome, false, true);
        }
    }
}

