/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.streampark.common.util.HadoopUtils;
import org.apache.streampark.console.base.domain.RestResponse;
import org.apache.streampark.console.core.bean.DockerConfig;
import org.apache.streampark.console.core.bean.ResponseResult;
import org.apache.streampark.console.core.bean.SenderEmail;
import org.apache.streampark.console.core.entity.Setting;
import org.apache.streampark.console.core.service.SettingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="SETTING_TAG")
@Validated
@RestController
@RequestMapping(value={"flink/setting"})
public class SettingController {
    private static final Logger log = LoggerFactory.getLogger(SettingController.class);
    @Autowired
    private SettingService settingService;

    @Operation(summary="List settings")
    @PostMapping(value={"all"})
    @RequiresPermissions(value={"setting:view"})
    public RestResponse all() {
        LambdaQueryWrapper query = (LambdaQueryWrapper)new LambdaQueryWrapper().orderByAsc(Setting::getOrderNum);
        List setting = this.settingService.list((Wrapper)query);
        return RestResponse.success(setting);
    }

    @Operation(summary="Get setting")
    @PostMapping(value={"get"})
    public RestResponse get(String key) {
        Setting setting = this.settingService.get(key);
        return RestResponse.success(setting);
    }

    @Operation(summary="Update setting")
    @PostMapping(value={"update"})
    @RequiresPermissions(value={"setting:update"})
    public RestResponse update(Setting setting) {
        boolean updated = this.settingService.update(setting);
        return RestResponse.success(updated);
    }

    @Operation(summary="get Docker config")
    @PostMapping(value={"docker"})
    @RequiresPermissions(value={"setting:view"})
    public RestResponse docker() {
        DockerConfig dockerConfig = DockerConfig.fromSetting();
        return RestResponse.success(dockerConfig);
    }

    @Operation(summary="check docker setting")
    @PostMapping(value={"check/docker"})
    @RequiresPermissions(value={"setting:view"})
    public RestResponse checkDocker(DockerConfig dockerConfig) {
        ResponseResult result = this.settingService.checkDocker(dockerConfig);
        return RestResponse.success(result);
    }

    @Operation(summary="Update docker setting")
    @PostMapping(value={"update/docker"})
    @RequiresPermissions(value={"setting:update"})
    public RestResponse updateDocker(DockerConfig dockerConfig) {
        boolean updated = this.settingService.updateDocker(dockerConfig);
        return RestResponse.success(updated);
    }

    @Operation(summary="get sender email")
    @PostMapping(value={"email"})
    @RequiresPermissions(value={"setting:view"})
    public RestResponse email() {
        SenderEmail senderEmail = this.settingService.getSenderEmail();
        return RestResponse.success(senderEmail);
    }

    @Operation(summary="check email")
    @PostMapping(value={"check/email"})
    @RequiresPermissions(value={"setting:view"})
    public RestResponse checkEmail(SenderEmail senderEmail) {
        ResponseResult result = this.settingService.checkEmail(senderEmail);
        return RestResponse.success(result);
    }

    @Operation(summary="Update sender email")
    @PostMapping(value={"update/email"})
    @RequiresPermissions(value={"setting:update"})
    public RestResponse updateEmail(SenderEmail senderEmail) {
        boolean updated = this.settingService.updateEmail(senderEmail);
        return RestResponse.success(updated);
    }

    @Operation(summary="Check hadoop status")
    @PostMapping(value={"check/hadoop"})
    public RestResponse checkHadoop() {
        try {
            HadoopUtils.hdfs().getStatus();
            return RestResponse.success(true);
        }
        catch (Exception e) {
            return RestResponse.success(false).message(e.getMessage());
        }
    }
}

