/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.source;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.eventtime.TimestampAssigner;
import org.apache.flink.api.common.eventtime.Watermark;
import org.apache.flink.api.common.eventtime.WatermarkGenerator;
import org.apache.flink.api.common.eventtime.WatermarkOutput;
import org.apache.flink.api.connector.source.SourceOutput;
import org.apache.flink.streaming.api.operators.source.WatermarkToDataOutput;
import org.apache.flink.streaming.runtime.io.PushingAsyncDataInput;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.ExceptionInChainedOperatorException;
import org.apache.flink.util.Preconditions;

@Internal
public class SourceOutputWithWatermarks<T>
implements SourceOutput<T> {
    private final PushingAsyncDataInput.DataOutput<T> recordsOutput;
    private final TimestampAssigner<T> timestampAssigner;
    private final WatermarkGenerator<T> watermarkGenerator;
    private final WatermarkOutput onEventWatermarkOutput;
    private final WatermarkOutput periodicWatermarkOutput;
    private final StreamRecord<T> reusingRecord;

    protected SourceOutputWithWatermarks(PushingAsyncDataInput.DataOutput<T> recordsOutput, WatermarkOutput onEventWatermarkOutput, WatermarkOutput periodicWatermarkOutput, TimestampAssigner<T> timestampAssigner, WatermarkGenerator<T> watermarkGenerator) {
        this.recordsOutput = (PushingAsyncDataInput.DataOutput)Preconditions.checkNotNull(recordsOutput);
        this.onEventWatermarkOutput = (WatermarkOutput)Preconditions.checkNotNull((Object)onEventWatermarkOutput);
        this.periodicWatermarkOutput = (WatermarkOutput)Preconditions.checkNotNull((Object)periodicWatermarkOutput);
        this.timestampAssigner = (TimestampAssigner)Preconditions.checkNotNull(timestampAssigner);
        this.watermarkGenerator = (WatermarkGenerator)Preconditions.checkNotNull(watermarkGenerator);
        this.reusingRecord = new StreamRecord<Object>(null);
    }

    public final void collect(T record) {
        this.collect(record, Long.MIN_VALUE);
    }

    public final void collect(T record, long timestamp) {
        try {
            long assignedTimestamp = this.timestampAssigner.extractTimestamp(record, timestamp);
            this.recordsOutput.emitRecord(this.reusingRecord.replace(record, assignedTimestamp));
            this.watermarkGenerator.onEvent(record, assignedTimestamp, this.onEventWatermarkOutput);
        }
        catch (ExceptionInChainedOperatorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExceptionInChainedOperatorException(e);
        }
    }

    public final void emitWatermark(Watermark watermark) {
        this.onEventWatermarkOutput.emitWatermark(watermark);
    }

    public final void markIdle() {
        this.onEventWatermarkOutput.markIdle();
    }

    public void markActive() {
        this.onEventWatermarkOutput.markActive();
    }

    public final void emitPeriodicWatermark() {
        this.watermarkGenerator.onPeriodicEmit(this.periodicWatermarkOutput);
    }

    public static <E> SourceOutputWithWatermarks<E> createWithSameOutputs(PushingAsyncDataInput.DataOutput<E> recordsAndWatermarksOutput, TimestampAssigner<E> timestampAssigner, WatermarkGenerator<E> watermarkGenerator) {
        WatermarkToDataOutput watermarkOutput = new WatermarkToDataOutput(recordsAndWatermarksOutput);
        return new SourceOutputWithWatermarks<E>(recordsAndWatermarksOutput, watermarkOutput, watermarkOutput, timestampAssigner, watermarkGenerator);
    }

    public static <E> SourceOutputWithWatermarks<E> createWithSeparateOutputs(PushingAsyncDataInput.DataOutput<E> recordsOutput, WatermarkOutput onEventWatermarkOutput, WatermarkOutput periodicWatermarkOutput, TimestampAssigner<E> timestampAssigner, WatermarkGenerator<E> watermarkGenerator) {
        return new SourceOutputWithWatermarks<E>(recordsOutput, onEventWatermarkOutput, periodicWatermarkOutput, timestampAssigner, watermarkGenerator);
    }
}

