/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.metrics;

import java.util.Collection;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.state.internal.InternalReducingState;
import org.apache.flink.runtime.state.metrics.AbstractLatencyTrackState;
import org.apache.flink.runtime.state.metrics.LatencyTrackingStateConfig;
import org.apache.flink.runtime.state.metrics.StateLatencyMetricBase;
import org.apache.flink.util.function.ThrowingRunnable;

class LatencyTrackingReducingState<K, N, T>
extends AbstractLatencyTrackState<K, N, T, InternalReducingState<K, N, T>, ReducingStateLatencyMetrics>
implements InternalReducingState<K, N, T> {
    LatencyTrackingReducingState(String stateName, InternalReducingState<K, N, T> original, LatencyTrackingStateConfig latencyTrackingStateConfig) {
        super(original, new ReducingStateLatencyMetrics(stateName, latencyTrackingStateConfig.getMetricGroup(), latencyTrackingStateConfig.getSampleInterval(), latencyTrackingStateConfig.getHistorySize(), latencyTrackingStateConfig.isStateNameAsVariable()));
    }

    public T get() throws Exception {
        if (((ReducingStateLatencyMetrics)this.latencyTrackingStateMetric).trackLatencyOnGet()) {
            return this.trackLatencyWithException(() -> ((InternalReducingState)this.original).get(), "reducingStateGetLatency");
        }
        return (T)((InternalReducingState)this.original).get();
    }

    public void add(T value) throws Exception {
        if (((ReducingStateLatencyMetrics)this.latencyTrackingStateMetric).trackLatencyOnAdd()) {
            this.trackLatencyWithException((ThrowingRunnable<Exception>)((ThrowingRunnable)() -> ((InternalReducingState)this.original).add(value)), "reducingStateAddLatency");
        } else {
            ((InternalReducingState)this.original).add(value);
        }
    }

    @Override
    public T getInternal() throws Exception {
        return (T)((InternalReducingState)this.original).getInternal();
    }

    @Override
    public void updateInternal(T valueToStore) throws Exception {
        ((InternalReducingState)this.original).updateInternal(valueToStore);
    }

    @Override
    public void mergeNamespaces(N target, Collection<N> sources) throws Exception {
        if (((ReducingStateLatencyMetrics)this.latencyTrackingStateMetric).trackLatencyOnMergeNamespace()) {
            this.trackLatencyWithException((ThrowingRunnable<Exception>)((ThrowingRunnable)() -> ((InternalReducingState)this.original).mergeNamespaces(target, sources)), "reducingStateMergeNamespacesLatency");
        } else {
            ((InternalReducingState)this.original).mergeNamespaces(target, sources);
        }
    }

    protected static class ReducingStateLatencyMetrics
    extends StateLatencyMetricBase {
        private static final String REDUCING_STATE_GET_LATENCY = "reducingStateGetLatency";
        private static final String REDUCING_STATE_ADD_LATENCY = "reducingStateAddLatency";
        private static final String REDUCING_STATE_MERGE_NAMESPACES_LATENCY = "reducingStateMergeNamespacesLatency";
        private int getCount = 0;
        private int addCount = 0;
        private int mergeNamespaceCount = 0;

        ReducingStateLatencyMetrics(String stateName, MetricGroup metricGroup, int sampleInterval, int historySize, boolean stateNameAsVariable) {
            super(stateName, metricGroup, sampleInterval, historySize, stateNameAsVariable);
        }

        int getGetCount() {
            return this.getCount;
        }

        int getAddCount() {
            return this.addCount;
        }

        int getMergeNamespaceCount() {
            return this.mergeNamespaceCount;
        }

        private boolean trackLatencyOnGet() {
            this.getCount = this.loopUpdateCounter(this.getCount);
            return this.getCount == 1;
        }

        private boolean trackLatencyOnAdd() {
            this.addCount = this.loopUpdateCounter(this.addCount);
            return this.addCount == 1;
        }

        private boolean trackLatencyOnMergeNamespace() {
            this.mergeNamespaceCount = this.loopUpdateCounter(this.mergeNamespaceCount);
            return this.mergeNamespaceCount == 1;
        }
    }
}

