/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.streampark.common.util.DeflaterUtils;
import org.apache.streampark.console.base.domain.RestRequest;
import org.apache.streampark.console.base.exception.ApiAlertException;
import org.apache.streampark.console.base.mybatis.pager.MybatisPager;
import org.apache.streampark.console.core.entity.Application;
import org.apache.streampark.console.core.entity.FlinkSql;
import org.apache.streampark.console.core.entity.Variable;
import org.apache.streampark.console.core.enums.ReleaseState;
import org.apache.streampark.console.core.mapper.VariableMapper;
import org.apache.streampark.console.core.service.ApplicationService;
import org.apache.streampark.console.core.service.CommonService;
import org.apache.streampark.console.core.service.FlinkSqlService;
import org.apache.streampark.console.core.service.VariableService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(propagation=Propagation.SUPPORTS, readOnly=true, rollbackFor={Exception.class})
public class VariableServiceImpl
extends ServiceImpl<VariableMapper, Variable>
implements VariableService {
    private static final Logger log = LoggerFactory.getLogger(VariableServiceImpl.class);
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\$\\{([A-Za-z])+([A-Za-z0-9._-])+\\}");
    private static final String PLACEHOLDER_START = "${";
    private static final String PLACEHOLDER_END = "}";
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private FlinkSqlService flinkSqlService;
    @Autowired
    private CommonService commonService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createVariable(Variable variable) {
        if (this.findByVariableCode(variable.getTeamId(), variable.getVariableCode()) != null) {
            throw new ApiAlertException("Sorry, the variable code already exists.");
        }
        variable.setCreatorId(this.commonService.getUserId());
        this.save(variable);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteVariable(Variable variable) {
        if (this.isDependByApplications(variable)) {
            throw new ApiAlertException("Sorry, the variable is actually used.");
        }
        this.removeById(variable);
    }

    @Override
    public IPage<Variable> page(Variable variable, RestRequest request) {
        if (variable.getTeamId() == null) {
            return null;
        }
        Page page = new MybatisPager().getDefaultPage(request);
        return ((VariableMapper)this.baseMapper).page(page, variable);
    }

    @Override
    public IPage<Application> dependAppsPage(Variable variable, RestRequest request) {
        List<Application> applications = this.getDependApplicationsByCode(variable);
        Page page = new Page();
        if (CollectionUtils.isEmpty(applications)) {
            return page;
        }
        page.setCurrent((long)request.getPageNum());
        page.setSize((long)request.getPageSize());
        page.setTotal((long)applications.size());
        int fromIndex = (request.getPageNum() - 1) * request.getPageSize();
        int toIndex = request.getPageNum() * request.getPageSize();
        toIndex = Math.min(toIndex, applications.size());
        page.setRecords(applications.subList(fromIndex, toIndex));
        return page;
    }

    @Override
    public void updateVariable(Variable variable) {
        if (variable.getId() == null) {
            throw new ApiAlertException("Sorry, the variable id cannot be null.");
        }
        Variable findVariable = (Variable)((VariableMapper)this.baseMapper).selectById(variable.getId());
        if (findVariable == null) {
            throw new ApiAlertException("Sorry, the variable does not exist.");
        }
        if (!findVariable.getVariableCode().equals(variable.getVariableCode())) {
            throw new ApiAlertException("Sorry, the variable code cannot be updated.");
        }
        ((VariableMapper)this.baseMapper).updateById(variable);
        List<Application> applications = this.getDependApplicationsByCode(variable);
        if (CollectionUtils.isNotEmpty(applications)) {
            this.applicationService.update((Wrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().in(Application::getId, (Collection)applications.stream().map(Application::getId).collect(Collectors.toList()))).set(Application::getRelease, (Object)ReleaseState.NEED_RESTART.get()));
        }
    }

    @Override
    public Variable findByVariableCode(Long teamId, String variableCode) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Variable::getVariableCode, (Object)variableCode)).eq(Variable::getTeamId, (Object)teamId);
        return (Variable)((VariableMapper)this.baseMapper).selectOne((Wrapper)queryWrapper);
    }

    @Override
    public List<Variable> findByTeamId(Long teamId) {
        return this.findByTeamId(teamId, null);
    }

    @Override
    public List<Variable> findByTeamId(Long teamId, String keyword) {
        return ((VariableMapper)this.baseMapper).selectByTeamId(teamId, keyword);
    }

    @Override
    public String replaceVariable(Long teamId, String mixed) {
        if (StringUtils.isEmpty((CharSequence)mixed)) {
            return mixed;
        }
        List<Variable> variables = this.findByTeamId(teamId);
        if (CollectionUtils.isEmpty(variables)) {
            return mixed;
        }
        Map<String, String> variableMap = variables.stream().collect(Collectors.toMap(Variable::getVariableCode, Variable::getVariableValue));
        String restore = mixed;
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(restore);
        while (matcher.find()) {
            String placeholder = matcher.group();
            String variableCode = this.getCodeFromPlaceholder(placeholder);
            String variableValue = variableMap.get(variableCode);
            if (!StringUtils.isNotEmpty((CharSequence)variableValue)) continue;
            restore = restore.replace(placeholder, variableValue);
        }
        return restore;
    }

    private boolean isDependByApplications(Variable variable) {
        return CollectionUtils.isNotEmpty(this.getDependApplicationsByCode(variable));
    }

    private List<Application> getDependApplicationsByCode(Variable variable) {
        ArrayList<Application> dependApplications = new ArrayList<Application>();
        List<Application> applications = this.applicationService.getByTeamId(variable.getTeamId());
        Map<Long, Application> applicationMap = applications.stream().collect(Collectors.toMap(Application::getId, application -> application));
        for (Application app : applications) {
            if (!this.isDepend(variable.getVariableCode(), app.getArgs())) continue;
            dependApplications.add(app);
        }
        List<FlinkSql> flinkSqls = this.flinkSqlService.getByTeamId(variable.getTeamId());
        for (FlinkSql flinkSql : flinkSqls) {
            Application app;
            if (!this.isDepend(variable.getVariableCode(), DeflaterUtils.unzipString((String)flinkSql.getSql())) || dependApplications.contains(app = applicationMap.get(flinkSql.getAppId()))) continue;
            dependApplications.add(applicationMap.get(flinkSql.getAppId()));
        }
        return dependApplications;
    }

    private boolean isDepend(String variableCode, String mixed) {
        if (StringUtils.isEmpty((CharSequence)mixed)) {
            return false;
        }
        String placeholder = String.format("%s%s%s", PLACEHOLDER_START, variableCode, PLACEHOLDER_END);
        return mixed.contains(placeholder);
    }

    private String getCodeFromPlaceholder(String placeholder) {
        return placeholder.substring(PLACEHOLDER_START.length(), placeholder.length() - PLACEHOLDER_END.length());
    }

    @Override
    public boolean existsByTeamId(Long teamId) {
        return ((VariableMapper)this.baseMapper).existsByTeamId(teamId);
    }
}

