/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.flink.kubernetes.watcher;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.hc.client5.http.fluent.Request;
import org.apache.hc.core5.util.Timeout;
import org.apache.streampark.flink.kubernetes.ChangeEventBus;
import org.apache.streampark.flink.kubernetes.FlinkK8sWatchController;
import org.apache.streampark.flink.kubernetes.IngressController$;
import org.apache.streampark.flink.kubernetes.JobStatusWatcherConfig;
import org.apache.streampark.flink.kubernetes.KubernetesRetriever$;
import org.apache.streampark.flink.kubernetes.enums.FlinkJobState$;
import org.apache.streampark.flink.kubernetes.enums.FlinkK8sExecuteMode$;
import org.apache.streampark.flink.kubernetes.event.FlinkJobStatusChangeEvent;
import org.apache.streampark.flink.kubernetes.helper.KubernetesDeploymentHelper$;
import org.apache.streampark.flink.kubernetes.model.ClusterKey;
import org.apache.streampark.flink.kubernetes.model.JobStatusCV;
import org.apache.streampark.flink.kubernetes.model.JobStatusCV$;
import org.apache.streampark.flink.kubernetes.model.TrackId;
import org.apache.streampark.flink.kubernetes.model.TrackId$;
import org.apache.streampark.flink.kubernetes.watcher.FlinkHistoryArchives$;
import org.apache.streampark.flink.kubernetes.watcher.FlinkJobStatusWatcher$;
import org.apache.streampark.flink.kubernetes.watcher.FlinkWatcher;
import org.apache.streampark.flink.kubernetes.watcher.JobDetail;
import org.apache.streampark.flink.kubernetes.watcher.JobDetails;
import org.apache.streampark.flink.kubernetes.watcher.JobDetails$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.NonLocalReturnControl;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\t}b\u0001\u0002\u0012$\u0001AB\u0001b\u0011\u0001\u0003\u0002\u0003\u0006I\u0001\u0012\u0005\t\u0011\u0002\u0011)\u0019!C\u0002\u0013\"AQ\n\u0001B\u0001B\u0003%!\n\u0003\u0005O\u0001\t\u0015\r\u0011b\u0001P\u0011!\u0019\u0006A!A!\u0002\u0013\u0001\u0006\"\u0002+\u0001\t\u0003)\u0006bB.\u0001\u0005\u0004%I\u0001\u0018\u0005\u0007M\u0002\u0001\u000b\u0011B/\t\u000f\u001d\u0004!\u0019!C\u0006Q\"1a\u000e\u0001Q\u0001\n%Dqa\u001c\u0001C\u0002\u0013%\u0001\u000f\u0003\u0004u\u0001\u0001\u0006I!\u001d\u0005\nk\u0002\u0001\r\u00111A\u0005\nYD1\"a\u0004\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0012!Iq\u0010\u0001a\u0001\u0002\u0003\u0006Ka\u001e\u0005\b\u0003K\u0001A\u0011IA\u0014\u0011\u001d\tI\u0003\u0001C!\u0003OAq!a\u000b\u0001\t\u0003\n9\u0003C\u0004\u0002.\u0001!\t%a\n\t\u000f\u0005=\u0002\u0001\"\u0001\u00022!A\u0011\u0011\r\u0001\u0005\u0012\u0015\n\u0019\u0007C\u0004\u0002 \u0002!\t!!)\t\u000f\u0005\u001d\u0006\u0001\"\u0003\u0002*\"9\u0011Q\u0018\u0001\u0005\n\u0005}\u0006bBAc\u0001\u0011%\u0011q\u0019\u0005\t\u0003'\u0004\u0001\u0015\"\u0003\u0002V\u001e9\u0011Q`\u0012\t\u0002\u0005}hA\u0002\u0012$\u0011\u0003\u0011\t\u0001\u0003\u0004U9\u0011\u0005!1\u0001\u0005\n\u0005\u000ba\"\u0019!C\u0005\u0005\u000fA\u0001Ba\u0007\u001dA\u0003%!\u0011\u0002\u0005\b\u0005;aB\u0011\u0001B\u0010\u0011%\u0011I\u0003HI\u0001\n\u0003\u0011YCA\u000bGY&t7NS8c'R\fG/^:XCR\u001c\u0007.\u001a:\u000b\u0005\u0011*\u0013aB<bi\u000eDWM\u001d\u0006\u0003M\u001d\n!b[;cKJtW\r^3t\u0015\tA\u0013&A\u0003gY&t7N\u0003\u0002+W\u0005Q1\u000f\u001e:fC6\u0004\u0018M]6\u000b\u00051j\u0013AB1qC\u000eDWMC\u0001/\u0003\ry'oZ\u0002\u0001'\u0011\u0001\u0011gN \u0011\u0005I*T\"A\u001a\u000b\u0003Q\nQa]2bY\u0006L!AN\u001a\u0003\r\u0005s\u0017PU3g!\tAT(D\u0001:\u0015\tQ4(\u0001\u0003vi&d'B\u0001\u001f*\u0003\u0019\u0019w.\\7p]&\u0011a(\u000f\u0002\u0007\u0019><w-\u001a:\u0011\u0005\u0001\u000bU\"A\u0012\n\u0005\t\u001b#\u0001\u0004$mS:\\w+\u0019;dQ\u0016\u0014\u0018\u0001B2p]\u001a\u0004\"!\u0012$\u000e\u0003\u0015J!aR\u0013\u0003-){'m\u0015;biV\u001cx+\u0019;dQ\u0016\u00148i\u001c8gS\u001e\fqb^1uG\"\u001cuN\u001c;s_2dWM]\u000b\u0002\u0015B\u0011QiS\u0005\u0003\u0019\u0016\u0012qC\u00127j].\\\u0005h],bi\u000eD7i\u001c8ue>dG.\u001a:\u0002!]\fGo\u00195D_:$(o\u001c7mKJ\u0004\u0013\u0001C3wK:$()^:\u0016\u0003A\u0003\"!R)\n\u0005I+#AD\"iC:<W-\u0012<f]R\u0014Uo]\u0001\nKZ,g\u000e\u001e\"vg\u0002\na\u0001P5oSRtDC\u0001,[)\r9\u0006,\u0017\t\u0003\u0001\u0002AQ\u0001\u0013\u0004A\u0004)CQA\u0014\u0004A\u0004ACqa\u0011\u0004\u0011\u0002\u0003\u0007A)A\tue\u0006\u001c7\u000eV1tW\u0016CXm\u0019)p_2,\u0012!\u0018\t\u0003=\u0012l\u0011a\u0018\u0006\u0003A\u0006\f!bY8oGV\u0014(/\u001a8u\u0015\tQ$MC\u0001d\u0003\u0011Q\u0017M^1\n\u0005\u0015|&aD#yK\u000e,Ho\u001c:TKJ4\u0018nY3\u0002%Q\u0014\u0018mY6UCN\\W\t_3d!>|G\u000eI\u0001\u0012iJ\f7m\u001b+bg.,\u00050Z2vi>\u0014X#A5\u0011\u0005)dW\"A6\u000b\u0005\u0001\u001c\u0014BA7l\u0005})\u00050Z2vi&|gnQ8oi\u0016DH/\u0012=fGV$xN]*feZL7-Z\u0001\u0013iJ\f7m\u001b+bg.,\u00050Z2vi>\u0014\b%A\u0005uS6,'/\u0012=fGV\t\u0011\u000f\u0005\u0002_e&\u00111o\u0018\u0002\u0019'\u000eDW\rZ;mK\u0012,\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0017A\u0003;j[\u0016\u0014X\t_3dA\u0005iA/[7feN\u001b\u0007.\u001a3vY\u0016,\u0012a\u001e\u0019\u0003qv\u00042AX=|\u0013\tQxLA\bTG\",G-\u001e7fI\u001a+H/\u001e:f!\taX\u0010\u0004\u0001\u0005\u0015y|\u0011\u0011!A\u0001\u0006\u0003\t\tAA\u0002`IE\na\u0002^5nKJ\u001c6\r[3ek2,\u0007%\u0005\u0003\u0002\u0004\u0005%\u0001c\u0001\u001a\u0002\u0006%\u0019\u0011qA\u001a\u0003\u000f9{G\u000f[5oOB\u0019!'a\u0003\n\u0007\u000551GA\u0002B]f\f\u0011\u0003^5nKJ\u001c6\r[3ek2,w\fJ3r)\u0011\t\u0019\"!\u0007\u0011\u0007I\n)\"C\u0002\u0002\u0018M\u0012A!\u00168ji\"I\u00111\u0004\b\u0002\u0002\u0003\u0007\u0011QD\u0001\u0004q\u0012\n\u0004\u0007BA\u0010\u0003G\u0001BAX=\u0002\"A\u0019A0a\t\u0005\u0017y\fI\"!A\u0001\u0002\u000b\u0005\u0011\u0011A\u0001\bI>\u001cF/\u0019:u)\t\t\u0019\"\u0001\u0004e_N#x\u000e]\u0001\bI>\u001cEn\\:f\u0003\u001d!wnV1uG\"\fq\u0002^8vG\"\u001cVm]:j_:TuN\u0019\u000b\u0005\u0003g\t)\u0005E\u00033\u0003k\tI$C\u0002\u00028M\u0012aa\u00149uS>t\u0007\u0003BA\u001e\u0003\u0003j!!!\u0010\u000b\u0007\u0005}R%A\u0003n_\u0012,G.\u0003\u0003\u0002D\u0005u\"a\u0003&pEN#\u0018\r^;t\u0007ZCq!a\u0012\u0015\u0001\u0004\tI%A\u0004ue\u0006\u001c7.\u00133\u0011\t\u0005m\u00121J\u0005\u0005\u0003\u001b\niDA\u0004Ue\u0006\u001c7.\u00133)\t\u0005\u0015\u0013\u0011\u000b\t\u0005\u0003'\ni&\u0004\u0002\u0002V)!\u0011qKA-\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003\u00037\nQA[1wCbLA!a\u0018\u0002V\t9aj\u001c8ok2d\u0017A\u0005;pk\u000eD7+Z:tS>t\u0017\t\u001c7K_\n$\u0002\"!\u001a\u0002r\u00055\u00151\u0013\t\u0006e\u0005\u001d\u00141N\u0005\u0004\u0003S\u001a$!B!se\u0006L\bc\u0002\u001a\u0002n\u0005%\u0013\u0011H\u0005\u0004\u0003_\u001a$A\u0002+va2,'\u0007C\u0004\u0002tU\u0001\r!!\u001e\u0002\u0013\rdWo\u001d;fe&#\u0007\u0003BA<\u0003\u000bsA!!\u001f\u0002\u0002B\u0019\u00111P\u001a\u000e\u0005\u0005u$bAA@_\u00051AH]8pizJ1!a!4\u0003\u0019\u0001&/\u001a3fM&!\u0011qQAE\u0005\u0019\u0019FO]5oO*\u0019\u00111Q\u001a)\t\u0005E\u0014\u0011\u000b\u0005\b\u0003\u001f+\u0002\u0019AA;\u0003%q\u0017-\\3ta\u0006\u001cW\r\u000b\u0003\u0002\u000e\u0006E\u0003bBAK+\u0001\u0007\u0011qS\u0001\u0006CB\u0004\u0018\n\u001a\t\u0004e\u0005e\u0015bAANg\t!Aj\u001c8hQ\u0011\t\u0019*!\u0015\u0002'Q|Wo\u00195BaBd\u0017nY1uS>t'j\u001c2\u0015\t\u0005M\u00121\u0015\u0005\b\u0003\u000f2\u0002\u0019AA%Q\u0011\t\u0019+!\u0015\u0002\u001f1L7\u000f\u001e&pEN$U\r^1jYN$B!a+\u00024B)!'!\u000e\u0002.B\u0019\u0001)a,\n\u0007\u0005E6E\u0001\u0006K_\n$U\r^1jYNDq!!.\u0018\u0001\u0004\t9,\u0001\u0006dYV\u001cH/\u001a:LKf\u0004B!a\u000f\u0002:&!\u00111XA\u001f\u0005)\u0019E.^:uKJ\\U-_\u0001\u0015G\u0006dGNS8cg>3XM\u001d<jK^\u001c\u0018\t]5\u0015\t\u0005-\u0016\u0011\u0019\u0005\b\u0003\u0007D\u0002\u0019AA;\u0003\u001d\u0011Xm\u001d;Ve2\f\u0011&\u001b8gKJ\f\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8GY&t7NS8c'R\fG/\u001a$s_6\\\u0005h]#wK:$H\u0003BAe\u0003\u001f$B!a\r\u0002L\"9\u0011QZ\rA\u0004\u0005]\u0015\u0001\u00049pY2,U.\u001b;US6,\u0007bBA$3\u0001\u0007\u0011\u0011\n\u0015\u0005\u0003\u001f\f\t&A\u000fj]\u001a,'oU5mK:$xJ\u001d'pgR4%o\\7Qe\u0016\u001c\u0015m\u00195f)\u0011\t9.!<\u0011\t\u0005e\u0017Q\u001d\b\u0005\u00037\f\t/\u0004\u0002\u0002^*\u0019\u0011q\\\u0013\u0002\u000b\u0015tW/\\:\n\t\u0005\r\u0018Q\\\u0001\u000e\r2Lgn\u001b&pEN#\u0018\r^3\n\t\u0005\u001d\u0018\u0011\u001e\u0002\u0006-\u0006dW/Z\u0005\u0004\u0003W\u001c$aC#ok6,'/\u0019;j_:Dq!a<\u001b\u0001\u0004\tI$\u0001\u0005qe\u0016\u001c\u0015m\u00195fQ\r\u0001\u00111\u001f\t\u0005\u0003k\fI0\u0004\u0002\u0002x*\u0019\u0001-!\u0016\n\t\u0005m\u0018q\u001f\u0002\u000b)\"\u0014X-\u00193TC\u001a,\u0017!\u0006$mS:\\'j\u001c2Ti\u0006$Xo],bi\u000eDWM\u001d\t\u0003\u0001r\u0019\"\u0001H\u0019\u0015\u0005\u0005}\u0018aD3gM\u0016\u001cG/\u00128e'R\fG/Z:\u0016\u0005\t%\u0001C\u0002B\u0006\u0005+\t9N\u0004\u0003\u0003\u000e\tEa\u0002BA>\u0005\u001fI\u0011\u0001N\u0005\u0004\u0005'\u0019\u0014a\u00029bG.\fw-Z\u0005\u0005\u0005/\u0011IBA\u0002TKFT1Aa\u00054\u0003A)gMZ3di\u0016sGm\u0015;bi\u0016\u001c\b%A\u000fj]\u001a,'O\u00127j].TuNY*uCR,gI]8n!\u0016\u00148/[:u)\u0019\t9N!\t\u0003&!9!1\u0005\u0011A\u0002\u0005]\u0017aB2veJ,g\u000e\u001e\u0005\b\u0005O\u0001\u0003\u0019AAl\u0003!\u0001(/\u001a<j_V\u001c\u0018a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0003.)\u001aAIa\f,\u0005\tE\u0002\u0003\u0002B\u001a\u0005wi!A!\u000e\u000b\t\t]\"\u0011H\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u00164\u0013\u0011\u0011iD!\u000e\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
@ThreadSafe
public class FlinkJobStatusWatcher
implements org.apache.streampark.common.util.Logger,
FlinkWatcher {
    private final JobStatusWatcherConfig conf;
    private final FlinkK8sWatchController watchController;
    private final ChangeEventBus eventBus;
    private final ExecutorService trackTaskExecPool;
    private final ExecutionContextExecutorService trackTaskExecutor;
    private final ScheduledExecutorService timerExec;
    private ScheduledFuture<?> timerSchedule;
    private final AtomicBoolean org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$$started;
    private transient Logger org$apache$streampark$common$util$Logger$$_logger;
    private final String org$apache$streampark$common$util$Logger$$prefix;

    public static JobStatusWatcherConfig $lessinit$greater$default$1() {
        return FlinkJobStatusWatcher$.MODULE$.$lessinit$greater$default$1();
    }

    public static Enumeration.Value inferFlinkJobStateFromPersist(Enumeration.Value value, Enumeration.Value value2) {
        return FlinkJobStatusWatcher$.MODULE$.inferFlinkJobStateFromPersist(value, value2);
    }

    @Override
    public void start() {
        FlinkWatcher.start$(this);
    }

    @Override
    public void stop() {
        FlinkWatcher.stop$(this);
    }

    @Override
    public void close() {
        FlinkWatcher.close$(this);
    }

    @Override
    public void restart() {
        FlinkWatcher.restart$(this);
    }

    @Override
    public Runnable funcToRunnable(Function0<BoxedUnit> fun) {
        return FlinkWatcher.funcToRunnable$(this, fun);
    }

    public String logName() {
        return org.apache.streampark.common.util.Logger.logName$((org.apache.streampark.common.util.Logger)this);
    }

    public Logger logger() {
        return org.apache.streampark.common.util.Logger.logger$((org.apache.streampark.common.util.Logger)this);
    }

    public void logInfo(Function0<String> msg) {
        org.apache.streampark.common.util.Logger.logInfo$((org.apache.streampark.common.util.Logger)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        org.apache.streampark.common.util.Logger.logInfo$((org.apache.streampark.common.util.Logger)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        org.apache.streampark.common.util.Logger.logDebug$((org.apache.streampark.common.util.Logger)this, msg);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        org.apache.streampark.common.util.Logger.logDebug$((org.apache.streampark.common.util.Logger)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        org.apache.streampark.common.util.Logger.logTrace$((org.apache.streampark.common.util.Logger)this, msg);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        org.apache.streampark.common.util.Logger.logTrace$((org.apache.streampark.common.util.Logger)this, msg, (Throwable)throwable);
    }

    public void logWarn(Function0<String> msg) {
        org.apache.streampark.common.util.Logger.logWarn$((org.apache.streampark.common.util.Logger)this, msg);
    }

    public void logWarn(Function0<String> msg, Throwable throwable) {
        org.apache.streampark.common.util.Logger.logWarn$((org.apache.streampark.common.util.Logger)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        org.apache.streampark.common.util.Logger.logError$((org.apache.streampark.common.util.Logger)this, msg);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        org.apache.streampark.common.util.Logger.logError$((org.apache.streampark.common.util.Logger)this, msg, (Throwable)throwable);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        org.apache.streampark.common.util.Logger.initializeLogIfNecessary$((org.apache.streampark.common.util.Logger)this, (boolean)isInterpreter);
    }

    @Override
    public AtomicBoolean org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$$started() {
        return this.org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$$started;
    }

    @Override
    public final void org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$_setter_$org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$$started_$eq(AtomicBoolean x$1) {
        this.org$apache$streampark$flink$kubernetes$watcher$FlinkWatcher$$started = x$1;
    }

    public Logger org$apache$streampark$common$util$Logger$$_logger() {
        return this.org$apache$streampark$common$util$Logger$$_logger;
    }

    public void org$apache$streampark$common$util$Logger$$_logger_$eq(Logger x$1) {
        this.org$apache$streampark$common$util$Logger$$_logger = x$1;
    }

    public String org$apache$streampark$common$util$Logger$$prefix() {
        return this.org$apache$streampark$common$util$Logger$$prefix;
    }

    public final void org$apache$streampark$common$util$Logger$_setter_$org$apache$streampark$common$util$Logger$$prefix_$eq(String x$1) {
        this.org$apache$streampark$common$util$Logger$$prefix = x$1;
    }

    public FlinkK8sWatchController watchController() {
        return this.watchController;
    }

    public ChangeEventBus eventBus() {
        return this.eventBus;
    }

    private ExecutorService trackTaskExecPool() {
        return this.trackTaskExecPool;
    }

    private ExecutionContextExecutorService trackTaskExecutor() {
        return this.trackTaskExecutor;
    }

    private ScheduledExecutorService timerExec() {
        return this.timerExec;
    }

    private ScheduledFuture<?> timerSchedule() {
        return this.timerSchedule;
    }

    private void timerSchedule_$eq(ScheduledFuture<?> x$1) {
        this.timerSchedule = x$1;
    }

    @Override
    public void doStart() {
        this.timerSchedule_$eq(this.timerExec().scheduleAtFixedRate(() -> this.doWatch(), 0L, this.conf.requestIntervalSec(), TimeUnit.SECONDS));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "[flink-k8s] FlinkJobStatusWatcher started.");
    }

    @Override
    public void doStop() {
        this.timerSchedule().cancel(true);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "[flink-k8s] FlinkJobStatusWatcher stopped.");
    }

    @Override
    public void doClose() {
        this.timerExec().shutdownNow();
        this.trackTaskExecutor().shutdownNow();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "[flink-k8s] FlinkJobStatusWatcher closed.");
    }

    @Override
    public synchronized void doWatch() {
        Object object = new Object();
        try {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("[FlinkJobStatusWatcher]: Status monitoring process begins - ").append(Thread.currentThread().getName()).toString());
            Set trackIds = (Set)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.watchController().getAllWatchingIds()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.nonEmpty())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
            });
            Set tracksFuture = (Set)trackIds.map((Function1 & Serializable & scala.Serializable)id -> {
                void var2_2;
                Future future = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                    Option<JobStatusCV> option;
                    Enumeration.Value value = id.executeMode();
                    Enumeration.Value value2 = FlinkK8sExecuteMode$.MODULE$.SESSION();
                    Enumeration.Value value3 = value;
                    if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                        option = this.touchSessionJob((TrackId)id);
                    } else {
                        Enumeration.Value value4 = FlinkK8sExecuteMode$.MODULE$.APPLICATION();
                        Enumeration.Value value5 = value;
                        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                            option = this.touchApplicationJob((TrackId)id);
                        } else {
                            throw new MatchError((Object)value);
                        }
                    }
                    return option;
                }, (ExecutionContext)this.trackTaskExecutor());
                future.onComplete((Function1 & Serializable & scala.Serializable)x$2 -> {
                    FlinkJobStatusWatcher.$anonfun$doWatch$7(this, id, x$2);
                    return BoxedUnit.UNIT;
                }, (ExecutionContext)this.trackTaskExecutor());
                return var2_2;
            }, Set$.MODULE$.canBuildFrom());
            Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Future)Await$.MODULE$.ready((Awaitable)Future$.MODULE$.sequence((TraversableOnce)tracksFuture, Set$.MODULE$.canBuildFrom(), (ExecutionContext)this.trackTaskExecutor()), (Duration)new package.DurationLong(package$.MODULE$.DurationLong($this.conf.requestTimeoutSec())).seconds())).failed().map((Function1 & Serializable & scala.Serializable)x$3 -> {
                this.logWarn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(77).append("[FlinkJobStatusWatcher] tracking flink job status on kubernetes mode timeout,").append(new StringBuilder(15).append(" limitSeconds=").append($this.conf.requestTimeoutSec()).append(",").toString()).append(new StringBuilder(10).append(" trackIds=").append(trackIds$1.mkString(",")).toString()).toString());
                return BoxedUnit.UNIT;
            });
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("[FlinkJobStatusWatcher]: End of status monitoring process - ").append(Thread.currentThread().getName()).toString());
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    public Option<JobStatusCV> touchSessionJob(@Nonnull TrackId trackId) {
        long pollEmitTime = System.currentTimeMillis();
        String clusterId = trackId.clusterId();
        String namespace = trackId.namespace();
        long appId = trackId.appId();
        String jobId = trackId.jobId();
        Map rsMap = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.touchSessionAllJob(clusterId, namespace, appId))).toMap(Predef$.MODULE$.$conforms());
        TrackId id = TrackId$.MODULE$.onSession(namespace, clusterId, appId, jobId);
        JobStatusCV jobState = (JobStatusCV)rsMap.get((Object)id).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)FlinkJobStatusWatcher.$anonfun$touchSessionJob$1(x$4))).getOrElse(() -> FlinkJobStatusWatcher.$anonfun$touchSessionJob$2(this, id, pollEmitTime));
        return new Some((Object)jobState);
    }

    public Tuple2<TrackId, JobStatusCV>[] touchSessionAllJob(@Nonnull String clusterId, @Nonnull String namespace, @Nonnull long appId) {
        Tuple2[] tuple2Array;
        Object object = new Object();
        try {
            LazyRef defaultResult$lzy = new LazyRef();
            long pollEmitTime = System.currentTimeMillis();
            JobDetail[] jobDetails = ((JobDetails)this.listJobsDetails(new ClusterKey(FlinkK8sExecuteMode$.MODULE$.SESSION(), namespace, clusterId)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new NonLocalReturnControl(object, (Object)FlinkJobStatusWatcher.defaultResult$1(defaultResult$lzy));
            })).jobs();
            tuple2Array = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])jobDetails)).isEmpty() ? FlinkJobStatusWatcher.defaultResult$1(defaultResult$lzy) : (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])jobDetails)).map((Function1 & Serializable & scala.Serializable)d -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)TrackId$.MODULE$.onSession(namespace, clusterId, appId, d.jid())), (Object)d.toJobStatusCV(pollEmitTime, System.currentTimeMillis())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                tuple2Array = (Tuple2[])ex.value();
            }
            throw ex;
        }
        return tuple2Array;
    }

    public Option<JobStatusCV> touchApplicationJob(@Nonnull TrackId trackId) {
        long pollEmitTime = System.currentTimeMillis();
        String clusterId = trackId.clusterId();
        String namespace = trackId.namespace();
        Option<JobDetails> jobDetails = this.listJobsDetails(new ClusterKey(FlinkK8sExecuteMode$.MODULE$.APPLICATION(), namespace, clusterId));
        return jobDetails.isEmpty() || new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((JobDetails)jobDetails.get()).jobs())).isEmpty() ? this.inferApplicationFlinkJobStateFromK8sEvent(trackId, pollEmitTime) : new Some((Object)((JobDetail)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((JobDetails)jobDetails.get()).jobs())).head()).toJobStatusCV(pollEmitTime, System.currentTimeMillis()));
    }

    private Option<JobDetails> listJobsDetails(ClusterKey clusterKey) {
        Option option;
        Object object = new Object();
        try {
            option = (Option)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                String clusterRestUrl = (String)this.watchController().getClusterRestUrl(clusterKey).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)FlinkJobStatusWatcher.$anonfun$listJobsDetails$2(x$5))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new NonLocalReturnControl(object, (Object)None$.MODULE$);
                });
                return this.callJobsOverviewsApi(clusterRestUrl);
            }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                Option option;
                this.logger().warn("Failed to visit remote flink jobs on kubernetes-native-mode cluster, and the retry access logic is performed.");
                String clusterRestUrl = (String)this.watchController().refreshClusterRestUrl(clusterKey).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new NonLocalReturnControl(object, (Object)None$.MODULE$);
                });
                Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.callJobsOverviewsApi(clusterRestUrl));
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    Option s = (Option)success.value();
                    this.logger().info("The retry is successful.");
                    option = s;
                } else if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    this.logger().warn(new StringBuilder(57).append("The retry fetch failed, final status failed, errorStack=").append(e.getMessage()).append(".").toString());
                    option = None$.MODULE$;
                } else {
                    throw new MatchError((Object)try_);
                }
                return option;
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                option = (Option)ex.value();
            }
            throw ex;
        }
        return option;
    }

    /*
     * WARNING - void declaration
     */
    private Option<JobDetails> callJobsOverviewsApi(String restUrl) {
        void var2_2;
        Option<JobDetails> jobDetails = JobDetails$.MODULE$.as(Request.get((String)new StringBuilder(14).append(restUrl).append("/jobs/overview").toString()).connectTimeout(Timeout.ofSeconds((long)KubernetesRetriever$.MODULE$.FLINK_REST_AWAIT_TIMEOUT_SEC())).responseTimeout(Timeout.ofSeconds((long)KubernetesRetriever$.MODULE$.FLINK_CLIENT_TIMEOUT_SEC())).execute().returnContent().asString(StandardCharsets.UTF_8));
        return var2_2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Option<JobStatusCV> inferApplicationFlinkJobStateFromK8sEvent(@Nonnull TrackId trackId, long pollEmitTime) {
        Some some;
        Enumeration.Value jobState;
        Enumeration.Value value;
        JobStatusCV latest;
        block8: {
            boolean isConnection;
            block10: {
                block9: {
                    latest = this.watchController().jobStatuses().get(trackId);
                    this.logger().info(new StringBuilder(39).append("Query the local cache result:").append(((Object)BoxesRunTime.boxToBoolean((boolean)this.watchController().canceling().has(trackId))).toString()).append(",trackId ").append(trackId.toString()).append(".").toString());
                    if (!this.watchController().canceling().has(trackId)) break block9;
                    value = FlinkJobState$.MODULE$.CANCELED();
                    break block8;
                }
                boolean isDeployExists = KubernetesRetriever$.MODULE$.isDeploymentExists(trackId.clusterId(), trackId.namespace());
                boolean deployStateOfTheError = KubernetesDeploymentHelper$.MODULE$.getDeploymentStatusChanges(trackId.namespace(), trackId.clusterId());
                isConnection = KubernetesDeploymentHelper$.MODULE$.isTheK8sConnectionNormal();
                if (!isDeployExists) break block10;
                if (!deployStateOfTheError) {
                    this.logger().info("Task Enter the initialization process.");
                    value = FlinkJobState$.MODULE$.K8S_INITIALIZING();
                    break block8;
                } else if (isConnection) {
                    this.logger().info("Enter the task failure deletion process.");
                    KubernetesDeploymentHelper$.MODULE$.watchPodTerminatedLog(trackId.namespace(), trackId.clusterId(), trackId.jobId());
                    KubernetesDeploymentHelper$.MODULE$.deleteTaskDeployment(trackId.namespace(), trackId.clusterId());
                    IngressController$.MODULE$.deleteIngress(trackId.namespace(), trackId.clusterId());
                    value = FlinkJobState$.MODULE$.FAILED();
                    break block8;
                } else {
                    value = this.inferSilentOrLostFromPreCache(latest);
                }
                break block8;
            }
            if (isConnection) {
                this.logger().info("The deployment is deleted and enters the task failure process.");
                value = FlinkJobState$.MODULE$.of(FlinkHistoryArchives$.MODULE$.getJobStateFromArchiveFile(trackId.jobId()));
            } else {
                value = this.inferSilentOrLostFromPreCache(latest);
            }
        }
        Enumeration.Value x$1 = jobState = value;
        String x$2 = trackId.jobId();
        long x$3 = pollEmitTime;
        long x$4 = System.currentTimeMillis();
        String x$5 = JobStatusCV$.MODULE$.apply$default$3();
        long x$6 = JobStatusCV$.MODULE$.apply$default$4();
        long x$7 = JobStatusCV$.MODULE$.apply$default$5();
        long x$8 = JobStatusCV$.MODULE$.apply$default$6();
        int x$9 = JobStatusCV$.MODULE$.apply$default$7();
        JobStatusCV jobStatusCV = new JobStatusCV(x$1, x$2, x$5, x$6, x$7, x$8, x$9, x$3, x$4);
        Enumeration.Value value2 = jobState;
        Enumeration.Value value3 = FlinkJobState$.MODULE$.SILENT();
        if (!(value2 != null ? !value2.equals(value3) : value3 != null) && latest != null) {
            Enumeration.Value value4 = latest.jobState();
            Enumeration.Value value5 = FlinkJobState$.MODULE$.SILENT();
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                long x$10 = latest.pollEmitTime();
                long x$11 = latest.pollAckTime();
                Enumeration.Value x$12 = jobStatusCV.copy$default$1();
                String x$13 = jobStatusCV.copy$default$2();
                String x$14 = jobStatusCV.copy$default$3();
                long x$15 = jobStatusCV.copy$default$4();
                long x$16 = jobStatusCV.copy$default$5();
                long x$17 = jobStatusCV.copy$default$6();
                int x$18 = jobStatusCV.copy$default$7();
                Some some2 = new Some((Object)jobStatusCV.copy(x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$10, x$11));
                some = some2;
                return some;
            }
        }
        some = new Some((Object)jobStatusCV);
        return some;
    }

    private Enumeration.Value inferSilentOrLostFromPreCache(JobStatusCV preCache) {
        Enumeration.Value value;
        JobStatusCV jobStatusCV = preCache;
        if (jobStatusCV == null) {
            value = FlinkJobState$.MODULE$.SILENT();
        } else {
            Enumeration.Value value2 = jobStatusCV.jobState();
            Enumeration.Value value3 = FlinkJobState$.MODULE$.SILENT();
            value = !(value2 != null ? !value2.equals(value3) : value3 != null) && System.currentTimeMillis() - jobStatusCV.pollAckTime() >= (long)(this.conf.silentStateJobKeepTrackingSec() * 1000) ? FlinkJobState$.MODULE$.LOST() : FlinkJobState$.MODULE$.SILENT();
        }
        return value;
    }

    public static final /* synthetic */ void $anonfun$doWatch$7(FlinkJobStatusWatcher $this, TrackId id$1, Try x$2) {
        block10: {
            block7: {
                BoxedUnit boxedUnit;
                TrackId trackId;
                JobStatusCV jobState;
                block9: {
                    block8: {
                        Option option = (Option)x$2.getOrElse((Function0 & Serializable & scala.Serializable)() -> None$.MODULE$);
                        if (!(option instanceof Some)) break block7;
                        Some some = (Some)option;
                        jobState = (JobStatusCV)some.value();
                        String x$1 = jobState.jobId();
                        Enumeration.Value x$22 = id$1.copy$default$1();
                        String x$3 = id$1.copy$default$2();
                        String x$4 = id$1.copy$default$3();
                        long x$5 = id$1.copy$default$4();
                        trackId = id$1.copy(x$22, x$3, x$4, x$5, x$1);
                        JobStatusCV latest = $this.watchController().jobStatuses().get(trackId);
                        if (latest == null) break block8;
                        Enumeration.Value value = latest.jobState();
                        Enumeration.Value value2 = jobState.jobState();
                        if (value != null ? !value.equals(value2) : value2 != null) break block8;
                        String string = latest.jobId();
                        String string2 = jobState.jobId();
                        if (!(string == null ? string2 != null : !string.equals(string2))) break block9;
                    }
                    $this.watchController().jobStatuses().put(trackId, jobState);
                    $this.watchController().trackIds().update(trackId);
                    $this.eventBus().postSync(new FlinkJobStatusChangeEvent(trackId, jobState));
                }
                if (FlinkJobState$.MODULE$.isEndState(jobState.jobState())) {
                    $this.watchController().unWatching(trackId);
                    Enumeration.Value value = trackId.executeMode();
                    Enumeration.Value value3 = FlinkK8sExecuteMode$.MODULE$.APPLICATION();
                    if (!(value != null ? !value.equals(value3) : value3 != null)) {
                        $this.watchController().endpoints().invalidate(trackId.toClusterKey());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
                break block10;
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ boolean $anonfun$touchSessionJob$1(JobStatusCV x$4) {
        Enumeration.Value value = x$4.jobState();
        Enumeration.Value value2 = FlinkJobState$.MODULE$.SILENT();
        return value == null ? value2 != null : !value.equals(value2);
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ JobStatusCV $anonfun$touchSessionJob$2(FlinkJobStatusWatcher $this, TrackId id$2, long pollEmitTime$1) {
        preCache = $this.watchController().jobStatuses().get(id$2);
        v0 = state = $this.inferSilentOrLostFromPreCache(preCache);
        var7_5 = FlinkJobState$.MODULE$.SILENT();
        if ((v0 != null ? v0.equals(var7_5) == false : var7_5 != null) || preCache == null) ** GOTO lbl-1000
        v1 = preCache.jobState();
        var8_6 = FlinkJobState$.MODULE$.SILENT();
        if (!(v1 != null ? v1.equals(var8_6) == false : var8_6 != null)) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = nonFirstSilent = false;
        }
        if (nonFirstSilent) {
            x$1 = state;
            x$2 = id$2.jobId();
            x$3 = preCache.pollEmitTime();
            x$4 = preCache.pollAckTime();
            x$5 = JobStatusCV$.MODULE$.apply$default$3();
            x$6 = JobStatusCV$.MODULE$.apply$default$4();
            x$7 = JobStatusCV$.MODULE$.apply$default$5();
            x$8 = JobStatusCV$.MODULE$.apply$default$6();
            x$9 = JobStatusCV$.MODULE$.apply$default$7();
            v3 = new JobStatusCV(x$1, x$2, x$5, x$6, x$7, x$8, x$9, x$3, x$4);
        } else {
            x$10 = state;
            x$11 = id$2.jobId();
            x$12 = pollEmitTime$1;
            x$13 = System.currentTimeMillis();
            x$14 = JobStatusCV$.MODULE$.apply$default$3();
            x$15 = JobStatusCV$.MODULE$.apply$default$4();
            x$16 = JobStatusCV$.MODULE$.apply$default$5();
            x$17 = JobStatusCV$.MODULE$.apply$default$6();
            x$18 = JobStatusCV$.MODULE$.apply$default$7();
            v3 = new JobStatusCV(x$10, x$11, x$14, x$15, x$16, x$17, x$18, x$12, x$13);
        }
        return v3;
    }

    private static final /* synthetic */ Tuple2[] defaultResult$lzycompute$1(LazyRef defaultResult$lzy$1) {
        Tuple2[] tuple2Array;
        LazyRef lazyRef = defaultResult$lzy$1;
        synchronized (lazyRef) {
            tuple2Array = defaultResult$lzy$1.initialized() ? (Tuple2[])defaultResult$lzy$1.value() : (Tuple2[])defaultResult$lzy$1.initialize(Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Tuple2.class)));
        }
        return tuple2Array;
    }

    private static final Tuple2[] defaultResult$1(LazyRef defaultResult$lzy$1) {
        return defaultResult$lzy$1.initialized() ? (Tuple2[])defaultResult$lzy$1.value() : FlinkJobStatusWatcher.defaultResult$lzycompute$1(defaultResult$lzy$1);
    }

    public static final /* synthetic */ boolean $anonfun$listJobsDetails$2(String x$5) {
        return new StringOps(Predef$.MODULE$.augmentString(x$5)).nonEmpty();
    }

    public FlinkJobStatusWatcher(JobStatusWatcherConfig conf, FlinkK8sWatchController watchController, ChangeEventBus eventBus) {
        this.conf = conf;
        this.watchController = watchController;
        this.eventBus = eventBus;
        org.apache.streampark.common.util.Logger.$init$((org.apache.streampark.common.util.Logger)this);
        FlinkWatcher.$init$(this);
        this.trackTaskExecPool = Executors.newWorkStealingPool();
        this.trackTaskExecutor = ExecutionContext$.MODULE$.fromExecutorService(this.trackTaskExecPool());
        this.timerExec = Executors.newSingleThreadScheduledExecutor();
    }
}

