/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.common.util;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetSocketAddress;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ipc.RPC;
import org.apache.streampark.common.util.HadoopUtils$;
import org.apache.streampark.common.util.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class HdfsUtils$
implements Logger {
    public static HdfsUtils$ MODULE$;
    private transient org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger;
    private final String org$apache$streampark$common$util$Logger$$prefix;

    static {
        new HdfsUtils$();
    }

    @Override
    public String logName() {
        return Logger.logName$(this);
    }

    @Override
    public org.slf4j.Logger logger() {
        return Logger.logger$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logger.logInfo$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logger.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logger.logDebug$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logger.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logger.logTrace$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logger.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarn(Function0<String> msg) {
        Logger.logWarn$(this, msg);
    }

    @Override
    public void logWarn(Function0<String> msg, Throwable throwable) {
        Logger.logWarn$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logger.logError$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logger.logError$(this, msg, throwable);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logger.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public org.slf4j.Logger org$apache$streampark$common$util$Logger$$_logger() {
        return this.org$apache$streampark$common$util$Logger$$_logger;
    }

    @Override
    public void org$apache$streampark$common$util$Logger$$_logger_$eq(org.slf4j.Logger x$1) {
        this.org$apache$streampark$common$util$Logger$$_logger = x$1;
    }

    @Override
    public String org$apache$streampark$common$util$Logger$$prefix() {
        return this.org$apache$streampark$common$util$Logger$$prefix;
    }

    @Override
    public final void org$apache$streampark$common$util$Logger$_setter_$org$apache$streampark$common$util$Logger$$prefix_$eq(String x$1) {
        this.org$apache$streampark$common$util$Logger$$prefix = x$1;
    }

    public String getDefaultFS() {
        return HadoopUtils$.MODULE$.hadoopConf().get("fs.defaultFS");
    }

    public List<FileStatus> list(String src) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])HadoopUtils$.MODULE$.hdfs().listStatus(this.getPath(src)))).toList();
    }

    public void move(String src, String dst) {
        HadoopUtils$.MODULE$.hdfs().rename(this.getPath(src), this.getPath(dst));
    }

    public void mkdirs(String path) {
        HadoopUtils$.MODULE$.hdfs().mkdirs(this.getPath(path));
    }

    public void copyHdfs(String src, String dst, boolean delSrc, boolean overwrite) {
        Path srcPath = this.getPath(src);
        Path dstPath = this.getPath(dst);
        FileStatus dstStatus = HadoopUtils$.MODULE$.hdfs().getFileStatus(dstPath);
        Path dstFinalPath = dstStatus.isFile() ? dstPath : this.getPath(new StringBuilder(1).append(dst).append("/").append(srcPath.getName()).toString());
        FileUtil.copy((FileSystem)HadoopUtils$.MODULE$.hdfs(), (Path)srcPath, (FileSystem)HadoopUtils$.MODULE$.hdfs(), (Path)dstFinalPath, (boolean)delSrc, (boolean)overwrite, (Configuration)HadoopUtils$.MODULE$.hadoopConf());
    }

    public boolean copyHdfs$default$3() {
        return false;
    }

    public boolean copyHdfs$default$4() {
        return true;
    }

    public void copyHdfsDir(String src, String dst, boolean delSrc, boolean overwrite) {
        this.list(src).foreach((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)HdfsUtils$.$anonfun$copyHdfsDir$1(dst, delSrc, overwrite, x)));
    }

    public boolean copyHdfsDir$default$3() {
        return false;
    }

    public boolean copyHdfsDir$default$4() {
        return true;
    }

    public void upload(String src, String dst, boolean delSrc, boolean overwrite) {
        HadoopUtils$.MODULE$.hdfs().copyFromLocalFile(delSrc, overwrite, this.getPath(src), this.getPath(dst));
    }

    public boolean upload$default$3() {
        return false;
    }

    public boolean upload$default$4() {
        return true;
    }

    public void uploadMulti(String[] src, String dst, boolean delSrc, boolean overwrite) {
        HadoopUtils$.MODULE$.hdfs().copyFromLocalFile(delSrc, overwrite, (Path[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])src)).map((Function1 & Serializable & scala.Serializable)hdfsPath -> MODULE$.getPath((String)hdfsPath), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class))), this.getPath(dst));
    }

    public boolean uploadMulti$default$3() {
        return false;
    }

    public boolean uploadMulti$default$4() {
        return true;
    }

    public void download(String src, String dst, boolean delSrc, boolean useRawLocalFileSystem) {
        HadoopUtils$.MODULE$.hdfs().copyToLocalFile(delSrc, this.getPath(src), this.getPath(dst), useRawLocalFileSystem);
    }

    public boolean download$default$3() {
        return false;
    }

    public boolean download$default$4() {
        return false;
    }

    public String getNameNode() {
        String value;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> MODULE$.getAddressOfActive(HadoopUtils$.MODULE$.hdfs()).getHostString());
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                throw exception;
            }
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        String string = value = (String)success.value();
        return string;
    }

    public void create(String fileName, String content) {
        Path path = this.getPath(fileName);
        Predef$.MODULE$.require(HadoopUtils$.MODULE$.hdfs().exists(path), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("[StreamPark] HdfsUtils.create ").append(fileName).append(" is exists!! ").toString());
        FSDataOutputStream outputStream = HadoopUtils$.MODULE$.hdfs().create(path);
        outputStream.writeUTF(content);
        outputStream.flush();
        outputStream.close();
    }

    public boolean exists(String path) {
        return HadoopUtils$.MODULE$.hdfs().exists(this.getPath(path));
    }

    public String read(String fileName) {
        Path path = this.getPath(fileName);
        Predef$.MODULE$.require(HadoopUtils$.MODULE$.hdfs().exists(path) && !HadoopUtils$.MODULE$.hdfs().isDirectory(path), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("[StreamPark] HdfsUtils.read: path(").append(fileName).append(") not exists or isDirectory ").toString());
        FSDataInputStream in = HadoopUtils$.MODULE$.hdfs().open(path);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copyBytes((InputStream)in, (OutputStream)out, (int)4096, (boolean)false);
        out.flush();
        IOUtils.closeStream((Closeable)in);
        IOUtils.closeStream((Closeable)out);
        return new String(out.toByteArray());
    }

    public void delete(String src) {
        Path path = this.getPath(src);
        if (HadoopUtils$.MODULE$.hdfs().exists(path)) {
            HadoopUtils$.MODULE$.hdfs().delete(path, true);
        } else {
            this.logWarn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("hdfs delete ").append(src).append(",but file ").append(src).append(" is not exists!").toString());
        }
    }

    public String fileMd5(String fileName) {
        Path path = this.getPath(fileName);
        FSDataInputStream in = HadoopUtils$.MODULE$.hdfs().open(path);
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> DigestUtils.md5Hex((InputStream)in));
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                in.close();
                throw e;
            }
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        String s = (String)success.value();
        in.close();
        String string = s;
        return string;
    }

    public void downToLocal(String hdfsPath, String localPath) {
        Path path = this.getPath(hdfsPath);
        FSDataInputStream input = HadoopUtils$.MODULE$.hdfs().open(path);
        String content = input.readUTF();
        FileWriter fw = new FileWriter(localPath);
        fw.write(content);
        fw.close();
        input.close();
    }

    private Path getPath(String hdfsPath) {
        return new Path(hdfsPath);
    }

    public InetSocketAddress getAddressOfActive(FileSystem fs) throws IOException {
        if (!(fs instanceof DistributedFileSystem)) {
            throw new IllegalArgumentException(new StringBuilder(25).append("FileSystem ").append(fs).append(" is not a DFS.").toString());
        }
        fs.exists(new Path("/"));
        DistributedFileSystem dfs = (DistributedFileSystem)fs;
        DFSClient dfsClient = dfs.getClient();
        return RPC.getServerAddress((Object)dfsClient.getNamenode());
    }

    public static final /* synthetic */ boolean $anonfun$copyHdfsDir$1(String dst$1, boolean delSrc$1, boolean overwrite$1, FileStatus x) {
        return FileUtil.copy((FileSystem)HadoopUtils$.MODULE$.hdfs(), (FileStatus)x, (FileSystem)HadoopUtils$.MODULE$.hdfs(), (Path)MODULE$.getPath(dst$1), (boolean)delSrc$1, (boolean)overwrite$1, (Configuration)HadoopUtils$.MODULE$.hadoopConf());
    }

    private HdfsUtils$() {
        MODULE$ = this;
        Logger.$init$(this);
    }
}

