/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.common.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.streampark.common.util.Utils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.Null$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class FileUtils$
extends FileUtils {
    public static FileUtils$ MODULE$;

    static {
        new FileUtils$();
    }

    private String bytesToHexString(byte[] src) {
        scala.collection.mutable.StringBuilder stringBuilder = new scala.collection.mutable.StringBuilder();
        if (src == null || src.length <= 0) {
            return null;
        }
        new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(src)).indices().foreach((Function1 & Serializable & scala.Serializable)i -> FileUtils$.$anonfun$bytesToHexString$1(src, stringBuilder, BoxesRunTime.unboxToInt((Object)i)));
        return stringBuilder.toString();
    }

    public boolean isJarFileType(InputStream input) {
        if (input == null) {
            throw new RuntimeException("The inputStream can not be null");
        }
        InputStream x$1 = input;
        Function1 & Serializable & scala.Serializable x$2 = (Function1 & Serializable & scala.Serializable)in -> {
            byte[] b = new byte[4];
            in.read(b, 0, b.length);
            return MODULE$.bytesToHexString(b);
        };
        Null$ x$3 = Utils$.MODULE$.tryWithResource$default$3(x$1, x$2);
        Object r = Utils$.MODULE$.tryWithResource(x$1, x$2, null);
        String string = "504B0304";
        return !(r != null ? !r.equals(string) : string != null);
    }

    public boolean isJarFileType(File file) {
        if (!file.exists() || !file.isFile()) {
            throw new RuntimeException("The file does not exist or the path is a directory");
        }
        return this.isJarFileType(new FileInputStream(file));
    }

    public File createTempDir() {
        Object object = new Object();
        try {
            int TEMP_DIR_ATTEMPTS = 10000;
            File baseDir = new File(System.getProperty("java.io.tmpdir"));
            String baseName = new StringBuilder(1).append(System.currentTimeMillis()).append("-").toString();
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), TEMP_DIR_ATTEMPTS).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)counter -> {
                File tempDir = new File(baseDir, new StringBuilder(0).append(baseName).append(counter).toString());
                if (tempDir.mkdir()) {
                    throw new NonLocalReturnControl(object, (Object)tempDir);
                }
            });
            throw new IllegalStateException(new StringBuilder(73).append("[StreamPark] Failed to create directory within ").append(TEMP_DIR_ATTEMPTS).append("  attempts (tried ").append(baseName).append(" 0 to ").append(baseName).append(" ").append(TEMP_DIR_ATTEMPTS - 1).append(")").toString());
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() != object) {
                throw ex;
            }
            return (File)ex.value();
        }
    }

    public void exists(String path) {
        Predef$.MODULE$.require(path != null && new StringOps(Predef$.MODULE$.augmentString(path)).nonEmpty() && new File(path).exists(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("[StreamPark] FileUtils.exists: file ").append(path).append(" is not exist!").toString());
    }

    public String getPathFromEnv(String env) {
        String path = System.getenv(env);
        Predef$.MODULE$.require(Utils$.MODULE$.notEmpty(path), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("[StreamPark] FileUtils.getPathFromEnv: ").append(env).append(" is not set on system env").toString());
        File file = new File(path);
        Predef$.MODULE$.require(file.exists(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("[StreamPark] FileUtils.getPathFromEnv: ").append(env).append(" is not exist!").toString());
        return file.getAbsolutePath();
    }

    public String resolvePath(String parent, String child) {
        File file = new File(parent, child);
        Predef$.MODULE$.require(file.exists(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("[StreamPark] FileUtils.resolvePath: ").append(file.getAbsolutePath()).append(" is not exist!").toString());
        return file.getAbsolutePath();
    }

    public String getSuffix(String filename) {
        Predef$.MODULE$.require(filename != null);
        return (String)new StringOps(Predef$.MODULE$.augmentString(filename)).drop(filename.lastIndexOf("."));
    }

    public List<URL> listFileAsURL(String dirPath) {
        File[] files;
        File file = new File(dirPath);
        List<URL> list = file.exists() && file.isDirectory() ? ((files = file.listFiles()) != null && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).nonEmpty() ? JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).map((Function1 & Serializable & scala.Serializable)f -> f.toURI().toURL(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(URL.class))))).toList()) : Collections.emptyList()) : Collections.emptyList();
        return list;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(File file1, File file2) {
        int firRead;
        Tuple2 tuple2 = new Tuple2((Object)file1, (Object)file2);
        if (tuple2 != null) {
            File a = (File)tuple2._1();
            File b = (File)tuple2._2();
            if (a == null) return false;
            if (b == null) {
                return false;
            }
        }
        if (tuple2 != null) {
            File a = (File)tuple2._1();
            File b = (File)tuple2._2();
            if (!a.exists()) return false;
            if (!b.exists()) {
                return false;
            }
        }
        if (tuple2 != null) {
            File a = (File)tuple2._1();
            File b = (File)tuple2._2();
            String string = a.getAbsolutePath();
            String string2 = b.getAbsolutePath();
            if (string == null) {
                if (string2 == null) return true;
            } else if (string.equals(string2)) {
                return true;
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        File a = (File)tuple2._1();
        File b = (File)tuple2._2();
        BufferedInputStream first = new BufferedInputStream(new FileInputStream(a));
        BufferedInputStream second = new BufferedInputStream(new FileInputStream(b));
        if (first.available() != second.available()) return false;
        do {
            int secRead;
            if ((firRead = first.read()) == (secRead = second.read())) continue;
            BufferedInputStream x$1 = first;
            BufferedInputStream x$2 = second;
            Function1<Throwable, BoxedUnit> x$3 = Utils$.MODULE$.close$default$2((Seq<AutoCloseable>)Predef$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{x$1, x$2}));
            Utils$.MODULE$.close((Seq<AutoCloseable>)Predef$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{x$1, x$2}), x$3);
            return false;
        } while (firRead != -1);
        BufferedInputStream x$4 = first;
        BufferedInputStream x$5 = second;
        Function1<Throwable, BoxedUnit> x$6 = Utils$.MODULE$.close$default$2((Seq<AutoCloseable>)Predef$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{x$4, x$5}));
        Utils$.MODULE$.close((Seq<AutoCloseable>)Predef$.MODULE$.wrapRefArray((Object[])new AutoCloseable[]{x$4, x$5}), x$6);
        return true;
    }

    public static final /* synthetic */ scala.collection.mutable.StringBuilder $anonfun$bytesToHexString$1(byte[] src$1, scala.collection.mutable.StringBuilder stringBuilder$1, int i) {
        int v = src$1[i] & 0xFF;
        String hv = Integer.toHexString(v).toUpperCase();
        Object object = hv.length() < 2 ? stringBuilder$1.append(0) : BoxedUnit.UNIT;
        return stringBuilder$1.append(hv);
    }

    private FileUtils$() {
        MODULE$ = this;
    }
}

