/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.system.authentication;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.exceptions.TokenExpiredException;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.util.Date;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.streampark.console.base.properties.ShiroProperties;
import org.apache.streampark.console.base.util.SpringContextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JWTUtil {
    private static final Logger log = LoggerFactory.getLogger(JWTUtil.class);
    private static final long JWT_TIME_OUT = SpringContextUtils.getBean(ShiroProperties.class).getJwtTimeOut() * 1000L;

    public static boolean verify(String token, String username, String secret) {
        try {
            Algorithm algorithm = Algorithm.HMAC256((String)secret);
            JWTVerifier verifier = JWT.require((Algorithm)algorithm).withClaim("userName", username).build();
            verifier.verify(token);
            return true;
        }
        catch (TokenExpiredException e) {
            throw new AuthenticationException(e.getMessage());
        }
        catch (Exception e) {
            log.info("token is invalid:{} , e:{}", (Object)e.getMessage(), e.getClass());
            return false;
        }
    }

    public static String getUserName(String token) {
        try {
            DecodedJWT jwt = JWT.decode((String)token);
            return jwt.getClaim("userName").asString();
        }
        catch (JWTDecodeException e) {
            log.info("error\uff1a{}", (Object)e.getMessage());
            return null;
        }
    }

    public static Long getUserId(String token) {
        try {
            DecodedJWT jwt = JWT.decode((String)token);
            return jwt.getClaim("userId").asLong();
        }
        catch (JWTDecodeException e) {
            log.info("error\uff1a{}", (Object)e.getMessage());
            return null;
        }
    }

    public static String sign(Long userId, String userName, String secret) {
        return JWTUtil.sign(userId, userName, secret, JWTUtil.getExpireTime());
    }

    public static String sign(Long userId, String userName, String secret, Long expireTime) {
        try {
            Date date = new Date(expireTime);
            Algorithm algorithm = Algorithm.HMAC256((String)secret);
            return JWT.create().withClaim("userId", userId).withClaim("userName", userName).withExpiresAt(date).sign(algorithm);
        }
        catch (Exception e) {
            log.info("error\uff1a{}", (Throwable)e);
            return null;
        }
    }

    private static Long getExpireTime() {
        return System.currentTimeMillis() + JWT_TIME_OUT;
    }
}

