/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.task;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.streampark.common.enums.ExecutionMode;
import org.apache.streampark.console.core.entity.Application;
import org.apache.streampark.console.core.enums.FlinkAppState;
import org.apache.streampark.console.core.service.ApplicationService;
import org.apache.streampark.console.core.task.FlinkK8sChangeEventListener;
import org.apache.streampark.flink.kubernetes.FlinkK8sWatcher;
import org.apache.streampark.flink.kubernetes.FlinkK8sWatcherFactory;
import org.apache.streampark.flink.kubernetes.FlinkTrackConfig;
import org.apache.streampark.flink.kubernetes.enums.FlinkJobState;
import org.apache.streampark.flink.kubernetes.enums.FlinkK8sExecuteMode;
import org.apache.streampark.flink.kubernetes.model.TrackId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import scala.Enumeration;

@Configuration
public class FlinkK8sWatcherWrapper {
    @Lazy
    @Autowired
    private FlinkK8sChangeEventListener flinkK8sChangeEventListener;
    @Lazy
    @Autowired
    private ApplicationService applicationService;

    @Bean(destroyMethod="close")
    public FlinkK8sWatcher registerFlinkK8sWatcher() {
        FlinkK8sWatcher flinkK8sWatcher = FlinkK8sWatcherFactory.createInstance((FlinkTrackConfig)FlinkTrackConfig.fromConfigHub(), (boolean)true);
        this.initFlinkK8sWatcher(flinkK8sWatcher);
        return flinkK8sWatcher;
    }

    private void initFlinkK8sWatcher(@Nonnull FlinkK8sWatcher trackMonitor) {
        trackMonitor.registerListener((Object)this.flinkK8sChangeEventListener);
        List<TrackId> k8sApp = this.getK8sWatchingApps();
        k8sApp.forEach(arg_0 -> ((FlinkK8sWatcher)trackMonitor).doWatching(arg_0));
    }

    private List<TrackId> getK8sWatchingApps() {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(Application::getTracking, (Object)1)).in(Application::getExecutionMode, (Collection)ExecutionMode.getKubernetesMode());
        List k8sApplication = this.applicationService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)k8sApplication)) {
            return Lists.newArrayList();
        }
        List correctApps = k8sApplication.stream().filter(app -> !Bridge.toTrackId(app).isLegal()).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(correctApps)) {
            this.applicationService.saveOrUpdateBatch(correctApps);
        }
        return k8sApplication.stream().filter(app -> !FlinkJobState.isEndState((Enumeration.Value)FlinkAppState.Bridge.toK8sFlinkJobState(app.getFlinkAppStateEnum()))).map(Bridge::toTrackId).collect(Collectors.toList());
    }

    public static boolean isKubernetesApp(Application application) {
        if (application == null) {
            return false;
        }
        return ExecutionMode.isKubernetesMode((Integer)application.getExecutionMode());
    }

    public static class Bridge {
        public static TrackId toTrackId(@Nonnull Application app) {
            Enumeration.Value mode = FlinkK8sExecuteMode.of((ExecutionMode)app.getExecutionModeEnum());
            if (FlinkK8sExecuteMode.APPLICATION().equals((Object)mode)) {
                return TrackId.onApplication((String)app.getK8sNamespace(), (String)app.getClusterId(), (long)app.getId(), (String)app.getJobId());
            }
            if (FlinkK8sExecuteMode.SESSION().equals((Object)mode)) {
                return TrackId.onSession((String)app.getK8sNamespace(), (String)app.getClusterId(), (long)app.getId(), (String)app.getJobId());
            }
            throw new IllegalArgumentException("Illegal K8sExecuteMode, mode=" + app.getExecutionMode());
        }
    }
}

