/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.console.core.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.streampark.console.base.domain.RestRequest;
import org.apache.streampark.console.base.domain.RestResponse;
import org.apache.streampark.console.base.exception.ApiAlertException;
import org.apache.streampark.console.core.entity.Application;
import org.apache.streampark.console.core.entity.Variable;
import org.apache.streampark.console.core.service.VariableService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Validated
@RestController
@RequestMapping(value={"variable"})
public class VariableController {
    private static final Logger log = LoggerFactory.getLogger(VariableController.class);
    @Autowired
    private VariableService variableService;

    @PostMapping(value={"page"})
    @RequiresPermissions(value={"variable:view"})
    public RestResponse page(RestRequest restRequest, Variable variable) {
        IPage<Variable> page = this.variableService.page(variable, restRequest);
        for (Variable v : page.getRecords()) {
            v.dataMasking();
        }
        return RestResponse.success(page);
    }

    @PostMapping(value={"list"})
    public RestResponse variableList(@RequestParam Long teamId, String keyword) {
        List<Variable> variableList = this.variableService.findByTeamId(teamId, keyword);
        for (Variable v : variableList) {
            v.dataMasking();
        }
        return RestResponse.success(variableList);
    }

    @PostMapping(value={"dependApps"})
    @RequiresPermissions(value={"variable:depend_apps"})
    public RestResponse dependApps(RestRequest restRequest, Variable variable) {
        IPage<Application> dependApps = this.variableService.dependAppsPage(variable, restRequest);
        return RestResponse.success(dependApps);
    }

    @PostMapping(value={"post"})
    @RequiresPermissions(value={"variable:add"})
    public RestResponse addVariable(@Valid Variable variable) {
        this.variableService.createVariable(variable);
        return RestResponse.success();
    }

    @PutMapping(value={"update"})
    @RequiresPermissions(value={"variable:update"})
    public RestResponse updateVariable(@Valid Variable variable) {
        if (variable.getId() == null) {
            throw new ApiAlertException("Sorry, the variable id cannot be null.");
        }
        Variable findVariable = (Variable)this.variableService.getById(variable.getId());
        if (findVariable == null) {
            throw new ApiAlertException("Sorry, the variable does not exist.");
        }
        if (!findVariable.getVariableCode().equals(variable.getVariableCode())) {
            throw new ApiAlertException("Sorry, the variable code cannot be updated.");
        }
        this.variableService.updateById(variable);
        return RestResponse.success();
    }

    @PostMapping(value={"showOriginal"})
    @RequiresPermissions(value={"variable:show_original"})
    public RestResponse showOriginal(@RequestParam Long id) {
        Variable v = (Variable)this.variableService.getById(id);
        return RestResponse.success(v);
    }

    @DeleteMapping(value={"delete"})
    @RequiresPermissions(value={"variable:delete"})
    public RestResponse deleteVariable(@Valid Variable variable) {
        this.variableService.deleteVariable(variable);
        return RestResponse.success();
    }

    @PostMapping(value={"check/code"})
    public RestResponse checkVariableCode(@RequestParam Long teamId, @NotBlank(message="{required}") @NotBlank(message="{required}") String variableCode) {
        boolean result = this.variableService.findByVariableCode(teamId, variableCode) == null;
        return RestResponse.success(result);
    }
}

