/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kubernetes.kubeclient.decorators;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServiceSpecFluent;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.flink.kubernetes.kubeclient.decorators.AbstractKubernetesStepDecorator;
import org.apache.flink.kubernetes.kubeclient.parameters.KubernetesJobManagerParameters;
import org.apache.flink.util.Preconditions;

public class ExternalServiceDecorator
extends AbstractKubernetesStepDecorator {
    private final KubernetesJobManagerParameters kubernetesJobManagerParameters;

    public ExternalServiceDecorator(KubernetesJobManagerParameters kubernetesJobManagerParameters) {
        this.kubernetesJobManagerParameters = (KubernetesJobManagerParameters)Preconditions.checkNotNull((Object)kubernetesJobManagerParameters);
    }

    @Override
    public List<HasMetadata> buildAccompanyingKubernetesResources() throws IOException {
        String serviceName = ExternalServiceDecorator.getExternalServiceName(this.kubernetesJobManagerParameters.getClusterId());
        Service externalService = ((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent.PortsNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceBuilder)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)((ServiceBuilder)new ServiceBuilder().withApiVersion("v1")).withNewMetadata().withName(serviceName)).withLabels(this.kubernetesJobManagerParameters.getCommonLabels())).withAnnotations(this.kubernetesJobManagerParameters.getRestServiceAnnotations())).endMetadata()).withNewSpec().withType(this.kubernetesJobManagerParameters.getRestServiceExposedType().name())).withSelector(this.kubernetesJobManagerParameters.getLabels())).addNewPort().withName("rest")).withPort(this.kubernetesJobManagerParameters.getRestPort())).withNewTargetPort(this.kubernetesJobManagerParameters.getRestBindPort())).endPort()).endSpec()).build();
        return Collections.singletonList(externalService);
    }

    public static String getExternalServiceName(String clusterId) {
        return clusterId + "-rest";
    }

    public static String getNamespacedExternalServiceName(String clusterId, String namespace) {
        return ExternalServiceDecorator.getExternalServiceName(clusterId) + "." + namespace;
    }
}

