/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.zookeeper3.org.apache.zookeeper;

import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.data.Stat;

public abstract class OpResult {
    private int type;

    private OpResult(int type) {
        this.type = type;
    }

    public int getType() {
        return this.type;
    }

    public static class ErrorResult
    extends OpResult {
        private int err;

        public ErrorResult(int err) {
            super(-1);
            this.err = err;
        }

        public int getErr() {
            return this.err;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ErrorResult)) {
                return false;
            }
            ErrorResult other = (ErrorResult)o;
            return this.getType() == other.getType() && this.err == other.getErr();
        }

        public int hashCode() {
            return this.getType() * 35 + this.err;
        }
    }

    public static class CheckResult
    extends OpResult {
        public CheckResult() {
            super(13);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CheckResult)) {
                return false;
            }
            CheckResult other = (CheckResult)o;
            return this.getType() == other.getType();
        }

        public int hashCode() {
            return this.getType();
        }
    }

    public static class SetDataResult
    extends OpResult {
        private Stat stat;

        public SetDataResult(Stat stat) {
            super(5);
            this.stat = stat;
        }

        public Stat getStat() {
            return this.stat;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SetDataResult)) {
                return false;
            }
            SetDataResult other = (SetDataResult)o;
            return this.getType() == other.getType() && this.stat.getMzxid() == other.stat.getMzxid();
        }

        public int hashCode() {
            return (int)((long)(this.getType() * 35) + this.stat.getMzxid());
        }
    }

    public static class DeleteResult
    extends OpResult {
        public DeleteResult() {
            super(2);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DeleteResult)) {
                return false;
            }
            DeleteResult opResult = (DeleteResult)o;
            return this.getType() == opResult.getType();
        }

        public int hashCode() {
            return this.getType();
        }
    }

    public static class CreateResult
    extends OpResult {
        private String path;

        public CreateResult(String path) {
            super(1);
            this.path = path;
        }

        public String getPath() {
            return this.path;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CreateResult)) {
                return false;
            }
            CreateResult other = (CreateResult)o;
            return this.getType() == other.getType() && this.path.equals(other.getPath());
        }

        public int hashCode() {
            return this.getType() * 35 + this.path.hashCode();
        }
    }
}

