% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/functions.R
\name{column_ml_functions}
\alias{column_ml_functions}
\alias{array_to_vector,Column-method}
\alias{array_to_vector}
\alias{vector_to_array,Column-method}
\alias{vector_to_array}
\title{ML functions for Column operations}
\usage{
array_to_vector(x)

vector_to_array(x, ...)

\S4method{array_to_vector}{Column}(x)

\S4method{vector_to_array}{Column}(x, dtype = c("float64", "float32"))
}
\arguments{
\item{x}{Column to compute on.}

\item{...}{additional argument(s).}

\item{dtype}{The data type of the output array. Valid values: "float64" or "float32".}
}
\description{
ML functions defined for \code{Column}.
}
\details{
\code{array_to_vector} Converts a column of array of numeric type into
a column of dense vectors in MLlib

\code{vector_to_array} Converts a column of MLlib sparse/dense vectors into
a column of dense arrays.
}
\note{
array_to_vector since 3.1.0

vector_to_array since 3.1.0
}
\examples{
\dontrun{
df <- read.df("data/mllib/sample_libsvm_data.txt", source = "libsvm")
head(
  withColumn(
    withColumn(df, "array", vector_to_array(df$features)),
    "vector",
    array_to_vector(column("array"))
  )
)
}
}
\concept{ml functions}
