/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.bundlesupport;

import io.github.classgraph.AnnotationClassRef;
import io.github.classgraph.AnnotationInfo;
import io.github.classgraph.AnnotationInfoList;
import io.github.classgraph.AnnotationParameterValue;
import io.github.classgraph.AnnotationParameterValueList;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import jakarta.json.Json;
import jakarta.json.JsonException;
import jakarta.json.JsonWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.sling.adapter.annotations.Adaptable;
import org.apache.sling.adapter.annotations.Adaptables;
import org.apache.sling.maven.bundlesupport.JsonSupport;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="generate-adapter-metadata", defaultPhase=LifecyclePhase.PROCESS_CLASSES, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE)
public class GenerateAdapterMetadataMojo
extends AbstractMojo {
    private static final String DEFAULT_CONDITION = "If the adaptable is a %s.";
    @Parameter(property="adapter.build.output.directory", defaultValue="${project.build.outputDirectory}")
    File buildOutputDirectory;
    @Parameter(property="adapter.descriptor.name", defaultValue="SLING-INF/adapters.json")
    String fileName;
    @Parameter(property="adapter.output.directory", defaultValue="${project.build.outputDirectory}")
    File outputDirectory;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        HashMap<String, Object> descriptor = new HashMap<String, Object>();
        ClassGraph classGraph = new ClassGraph().enableAnnotationInfo().overrideClasspath(new Object[]{this.buildOutputDirectory}).enableExternalClasses();
        if (this.getLog().isDebugEnabled()) {
            classGraph.verbose();
        }
        try (ScanResult result = classGraph.scan();){
            ClassInfoList classInfoList = result.getClassesWithAnnotation(Adaptable.class);
            classInfoList = classInfoList.union(new ClassInfoList[]{result.getClassesWithAnnotation(Adaptables.class)});
            for (ClassInfo annotationClassInfo : classInfoList) {
                this.getLog().info((CharSequence)String.format("found adaptable annotation on %s", annotationClassInfo.getSimpleName()));
                for (AnnotationInfo annotationInfo : annotationClassInfo.getAnnotationInfo().filter((AnnotationInfoList.AnnotationInfoFilter)new AdaptableAnnotationInfoFilter())) {
                    AnnotationParameterValueList annotationParameterValues = annotationInfo.getParameterValues();
                    if (annotationInfo.getName().equals(Adaptables.class.getName())) {
                        this.parseAdaptablesAnnotation(annotationParameterValues, annotationClassInfo.getSimpleName(), descriptor);
                        continue;
                    }
                    if (annotationInfo.getName().equals(Adaptable.class.getName())) {
                        this.parseAdaptableAnnotation(annotationParameterValues, annotationClassInfo.getSimpleName(), descriptor);
                        continue;
                    }
                    throw new IllegalStateException("Unexpected annotation class found: " + annotationInfo);
                }
            }
            File outputFile = new File(this.outputDirectory, this.fileName);
            outputFile.getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(outputFile);
                 JsonWriter jsonWriter = Json.createWriter((Writer)writer);){
                jsonWriter.writeObject(JsonSupport.toJson(descriptor));
            }
        }
        catch (JsonException | IOException e) {
            throw new MojoExecutionException("Unable to generate metadata", (Exception)e);
        }
    }

    private void parseAdaptablesAnnotation(AnnotationParameterValueList annotationParameterValues, String annotatedClassName, Map<String, Object> descriptor) throws JsonException {
        Object[] annotationInfos;
        for (Object annotationInfo : annotationInfos = (Object[])((AnnotationParameterValue)annotationParameterValues.get(0)).getValue()) {
            this.parseAdaptableAnnotation(((AnnotationInfo)annotationInfo).getParameterValues(), annotatedClassName, descriptor);
        }
    }

    private void parseAdaptableAnnotation(AnnotationParameterValueList annotationParameterValues, String annotatedClassName, Map<String, Object> descriptor) throws JsonException {
        HashMap<String, Object> adaptableDescription;
        String adaptableClassName = ((AnnotationClassRef)((AnnotationParameterValue)annotationParameterValues.get("adaptableClass")).getValue()).getName();
        Object[] adapters = (Object[])((AnnotationParameterValue)annotationParameterValues.get("adapters")).getValue();
        if (descriptor.containsKey(adaptableClassName)) {
            adaptableDescription = (Map)descriptor.get(adaptableClassName);
        } else {
            adaptableDescription = new HashMap();
            descriptor.put(adaptableClassName, adaptableDescription);
        }
        for (Object adapter : adapters) {
            this.parseAdapterAnnotation(((AnnotationInfo)adapter).getParameterValues(), annotatedClassName, adaptableDescription);
        }
    }

    private void parseAdapterAnnotation(AnnotationParameterValueList annotationParameterValues, String annotatedClassName, Map<String, Object> adaptableDescription) throws JsonException {
        Object[] adapterClasses;
        AnnotationParameterValue conditionParameterValue = (AnnotationParameterValue)annotationParameterValues.get("condition");
        String condition = null;
        if (conditionParameterValue != null) {
            condition = (String)conditionParameterValue.getValue();
        }
        if (StringUtils.isEmpty(condition)) {
            condition = String.format(DEFAULT_CONDITION, annotatedClassName);
        }
        if ((adapterClasses = (Object[])((AnnotationParameterValue)annotationParameterValues.get("value")).getValue()) == null) {
            throw new IllegalArgumentException("Adapter annotation is malformed. Expecting a list of adapter classes");
        }
        for (Object adapterClass : adapterClasses) {
            String adapterClassName = ((AnnotationClassRef)adapterClass).getName();
            JsonSupport.accumulate(adaptableDescription, condition, adapterClassName);
        }
    }

    private static final class AdaptableAnnotationInfoFilter
    implements AnnotationInfoList.AnnotationInfoFilter {
        private AdaptableAnnotationInfoFilter() {
        }

        public boolean accept(AnnotationInfo annotationInfo) {
            return annotationInfo.getName().equals(Adaptables.class.getName()) || annotationInfo.getName().equals(Adaptable.class.getName());
        }
    }
}

