/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.migration.version;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.jackrabbit.oak.plugins.migration.DescendantsIterator;
import org.apache.jackrabbit.oak.plugins.migration.NodeStateCopier;
import org.apache.jackrabbit.oak.plugins.migration.version.VersionCopyConfiguration;
import org.apache.jackrabbit.oak.plugins.migration.version.VersionHistoryUtil;
import org.apache.jackrabbit.oak.plugins.version.Utils;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionCopier {
    private static final Logger logger = LoggerFactory.getLogger(VersionCopier.class);
    private final NodeState sourceVersionStorage;
    private final NodeBuilder targetVersionStorage;
    private final Supplier<Boolean> frozenNodeIsReferenceable;
    private final Consumer<String> consumer;

    public VersionCopier(NodeBuilder targetRoot, NodeState sourceVersionStorage, NodeBuilder targetVersionStorage) {
        this(targetRoot, sourceVersionStorage, targetVersionStorage, path -> {});
    }

    public VersionCopier(NodeBuilder targetRoot, NodeState sourceVersionStorage, NodeBuilder targetVersionStorage, Consumer<String> consumer) {
        this.sourceVersionStorage = sourceVersionStorage;
        this.targetVersionStorage = targetVersionStorage;
        this.frozenNodeIsReferenceable = new IsFrozenNodeReferenceable(targetRoot.getNodeState());
        this.consumer = consumer;
    }

    public static void copyVersionStorage(NodeBuilder targetRoot, NodeState sourceVersionStorage, NodeBuilder targetVersionStorage, VersionCopyConfiguration config) {
        VersionCopier.copyVersionStorage(targetRoot, sourceVersionStorage, targetVersionStorage, config, path -> {});
    }

    public static void copyVersionStorage(NodeBuilder targetRoot, NodeState sourceVersionStorage, NodeBuilder targetVersionStorage, VersionCopyConfiguration config, @NotNull Consumer<String> consumer) {
        DescendantsIterator versionStorageIterator = new DescendantsIterator(sourceVersionStorage, 3);
        VersionCopier versionCopier = new VersionCopier(targetRoot, sourceVersionStorage, targetVersionStorage, consumer);
        while (versionStorageIterator.hasNext()) {
            NodeState versionHistoryBucket = (NodeState)versionStorageIterator.next();
            for (String versionHistory : versionHistoryBucket.getChildNodeNames()) {
                if (config.removeTargetVersionHistory()) {
                    VersionHistoryUtil.getVersionHistoryBuilder(targetVersionStorage, versionHistory).remove();
                }
                versionCopier.copyVersionHistory(versionHistory, config.getOrphanedMinDate(), config.preserveOnTarget());
            }
        }
    }

    public boolean copyVersionHistory(String versionableUuid, Calendar minDate, boolean preserveOnTarget) {
        String versionHistoryPath = VersionHistoryUtil.getRelativeVersionHistoryPath(versionableUuid);
        NodeState sourceVersionHistory = VersionHistoryUtil.getVersionHistoryNodeState(this.sourceVersionStorage, versionableUuid);
        Calendar lastModified = VersionHistoryUtil.getVersionHistoryLastModified(sourceVersionHistory);
        if (sourceVersionHistory.exists() && (lastModified.after(minDate) || minDate.getTimeInMillis() == 0L) && this.hasNoConflicts(versionHistoryPath, versionableUuid, preserveOnTarget, sourceVersionHistory)) {
            NodeStateCopier.builder().include(versionHistoryPath).merge("/jcr:system/jcr:versionStorage").withReferenceableFrozenNodes(this.frozenNodeIsReferenceable.get()).preserve(preserveOnTarget).withNodeConsumer(this.consumer).copy(this.sourceVersionStorage, this.targetVersionStorage);
            return true;
        }
        return false;
    }

    private boolean hasNoConflicts(String versionHistoryPath, String versionableUuid, boolean preserveOnTarget, NodeState sourceVersionHistory) {
        NodeBuilder targetVersionHistory;
        if (preserveOnTarget && (targetVersionHistory = VersionHistoryUtil.getVersionHistoryBuilder(this.targetVersionStorage, versionableUuid)).exists()) {
            boolean conflictingHighestVersion;
            boolean diverged;
            boolean noUpdate;
            boolean conflictingVersionHistory;
            VersionComparator versionComparator = new VersionComparator();
            boolean bl = conflictingVersionHistory = !Objects.equals(targetVersionHistory.getString("jcr:uuid"), sourceVersionHistory.getString("jcr:uuid"));
            if (conflictingVersionHistory) {
                logger.info("Skipping version history for {}: Conflicting version history found", (Object)versionHistoryPath);
                return false;
            }
            List targetVersions = StreamSupport.stream(targetVersionHistory.getChildNodeNames().spliterator(), false).filter(s -> !s.equals("jcr:rootVersion") && !s.equals("jcr:versionLabels")).sorted(versionComparator).collect(Collectors.toList());
            List sourceVersions = StreamSupport.stream(sourceVersionHistory.getChildNodeNames().spliterator(), false).filter(s -> !s.equals("jcr:rootVersion") && !s.equals("jcr:versionLabels")).sorted(versionComparator).collect(Collectors.toList());
            boolean bl2 = noUpdate = sourceVersions.isEmpty() || targetVersions.containsAll(sourceVersions);
            if (noUpdate) {
                logger.info("Skipping version history for {}: No update required", (Object)versionHistoryPath);
                return false;
            }
            boolean bl3 = diverged = !targetVersions.contains(sourceVersions.get(0));
            if (diverged) {
                logger.info("Skipping version history for {}: Versions diverged", (Object)versionHistoryPath);
                return false;
            }
            boolean bl4 = conflictingHighestVersion = !Objects.equals(sourceVersionHistory.getChildNode((String)sourceVersions.get(0)).getString("jcr:uuid"), targetVersionHistory.getChildNode((String)sourceVersions.get(0)).getString("jcr:uuid"));
            if (conflictingHighestVersion) {
                logger.info("Skipping version history for {}: Old base version id changed", (Object)versionHistoryPath);
                return false;
            }
        }
        return true;
    }

    private static final class IsFrozenNodeReferenceable
    implements Supplier<Boolean> {
        private final NodeState root;
        private Boolean isReferenceable;

        public IsFrozenNodeReferenceable(NodeState root) {
            this.root = root;
        }

        @Override
        public Boolean get() {
            if (this.isReferenceable == null) {
                this.isReferenceable = Utils.isFrozenNodeReferenceable(this.root);
            }
            return this.isReferenceable;
        }
    }

    static class VersionComparator
    implements Comparator<String> {
        VersionComparator() {
        }

        @Override
        public int compare(String v1, String v2) {
            String[] v1Seg = v1.split("\\.");
            String[] v2Seg = v2.split("\\.");
            Iterator<String> i1 = Arrays.asList(v1Seg).iterator();
            Iterator<String> i2 = Arrays.asList(v2Seg).iterator();
            while (i1.hasNext() && i2.hasNext()) {
                int cmp = Integer.compare(Integer.parseInt(i2.next()), Integer.parseInt(i1.next()));
                if (cmp == 0) continue;
                return cmp;
            }
            return Integer.compare(v2Seg.length, v1Seg.length);
        }
    }
}

