/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.collections4.iterators.IteratorChain;
import org.apache.commons.collections4.iterators.PeekingIterator;
import org.apache.commons.collections4.iterators.UnmodifiableIterator;
import org.apache.jackrabbit.oak.commons.collections.CollectionUtils;
import org.apache.jackrabbit.oak.commons.collections.SetUtils;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.jetbrains.annotations.NotNull;

public class IteratorUtils {
    private IteratorUtils() {
    }

    @NotNull
    public static <T> Iterable<T> toIterable(final @NotNull Iterator<T> iterator) {
        Objects.requireNonNull(iterator);
        return new Iterable<T>(){
            private boolean consumed = false;

            @Override
            @NotNull
            public Iterator<T> iterator() {
                if (this.consumed) {
                    throw new IllegalStateException("Iterator already returned once");
                }
                this.consumed = true;
                return iterator;
            }
        };
    }

    public static <T> Iterator<T> mergeSorted(Iterable<? extends Iterator<? extends T>> itrs, Comparator<? super T> c) {
        Objects.requireNonNull(itrs, "Iterators must not be null");
        Objects.requireNonNull(c, "Comparator must not be null");
        return org.apache.commons.collections4.IteratorUtils.unmodifiableIterator(new MergingIterator<T>(itrs, c));
    }

    public static boolean elementsEqual(Iterator<?> iterator1, Iterator<?> iterator2) {
        if (iterator1 == iterator2) {
            return true;
        }
        if (iterator1 == null || iterator2 == null) {
            return false;
        }
        while (iterator1.hasNext() && iterator2.hasNext()) {
            if (Objects.equals(iterator1.next(), iterator2.next())) continue;
            return false;
        }
        return !iterator1.hasNext() && !iterator2.hasNext();
    }

    public static int size(Iterator<?> iterator) {
        return org.apache.commons.collections4.IteratorUtils.size(iterator);
    }

    public static <T> T get(Iterator<T> iterator, int index) {
        Objects.requireNonNull(iterator, "Iterator must not be null");
        return (T)org.apache.commons.collections4.IteratorUtils.get(iterator, (int)index);
    }

    public static <T> T getLast(Iterator<T> iterator) {
        T currentElement;
        Objects.requireNonNull(iterator, "Iterator must not be null");
        do {
            currentElement = iterator.next();
        } while (iterator.hasNext());
        return currentElement;
    }

    public static boolean contains(Iterator<?> iterator, Object element) {
        Objects.requireNonNull(iterator, "Iterator must not be null");
        return org.apache.commons.collections4.IteratorUtils.contains(iterator, (Object)element);
    }

    public static <T> T[] toArray(Iterator<? extends T> iterator, Class<T> type) {
        return org.apache.commons.collections4.IteratorUtils.toArray(iterator, type);
    }

    public static <T> Enumeration<T> asEnumeration(Iterator<T> iterator) {
        return org.apache.commons.collections4.IteratorUtils.asEnumeration(iterator);
    }

    public static <E> Iterator<E> chainedIterator(Iterator<? extends E> iterator1, Iterator<? extends E> iterator2) {
        return org.apache.commons.collections4.IteratorUtils.chainedIterator(iterator1, iterator2);
    }

    @SafeVarargs
    public static <E> Iterator<E> chainedIterator(Iterator<? extends E> ... iterators) {
        return org.apache.commons.collections4.IteratorUtils.chainedIterator((Iterator[])iterators);
    }

    public static <E> Iterator<E> chainedIterator(Collection<Iterator<? extends E>> iterators) {
        return org.apache.commons.collections4.IteratorUtils.chainedIterator(iterators);
    }

    public static <E> Iterator<E> chainedIterator(Iterator<? extends Iterator<? extends E>> iterators) {
        IteratorChain eIteratorChain = new IteratorChain();
        iterators.forEachRemaining(arg_0 -> ((IteratorChain)eIteratorChain).addIterator(arg_0));
        return eIteratorChain;
    }

    public static <T> Iterator<T> filter(Iterator<? extends T> itr, Predicate<? super T> predicate) {
        return org.apache.commons.collections4.IteratorUtils.filteredIterator(itr, predicate::test);
    }

    public static <F, T> Iterator<T> transform(Iterator<? extends F> itr, Function<? super F, ? extends T> transform) {
        return org.apache.commons.collections4.IteratorUtils.transformedIterator(itr, transform::apply);
    }

    @SafeVarargs
    public static <E> Iterator<E> cycle(E ... elements) {
        Objects.requireNonNull(elements, "elements must not be null");
        return IteratorUtils.cycle(SetUtils.toLinkedSet(elements));
    }

    public static <E> Iterator<E> cycle(Iterable<E> iterable) {
        return org.apache.commons.collections4.IteratorUtils.loopingIterator(CollectionUtils.toCollection(iterable));
    }

    public static <T> Iterator<List<T>> partition(final Iterator<T> iterator, final int size) {
        Objects.requireNonNull(iterator, "Iterator must not be null.");
        Validate.checkArgument(size > 0, "Size must be greater than 0.");
        return UnmodifiableIterator.unmodifiableIterator((Iterator)new Iterator<List<T>>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public List<T> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ArrayList currentPartition = new ArrayList(size);
                for (int i = 0; i < size && iterator.hasNext(); ++i) {
                    currentPartition.add(iterator.next());
                }
                return Collections.unmodifiableList(currentPartition);
            }
        });
    }

    public static <T> Iterator<T> limit(Iterator<T> iterator, int limit) {
        Objects.requireNonNull(iterator);
        Validate.checkArgument(limit >= 0, "limit is negative");
        return org.apache.commons.collections4.IteratorUtils.boundedIterator(iterator, (long)limit);
    }

    private static class MergingIterator<T>
    implements Iterator<T> {
        final Queue<PeekingIterator<T>> queue;

        public MergingIterator(Iterable<? extends Iterator<? extends T>> itrs, Comparator<? super T> c) {
            Comparator<PeekingIterator> heapComparator = Comparator.comparing(PeekingIterator::peek, c);
            this.queue = new PriorityQueue<PeekingIterator>(heapComparator);
            for (Iterator<T> itr : itrs) {
                if (!itr.hasNext()) continue;
                this.queue.add(PeekingIterator.peekingIterator(itr));
            }
        }

        @Override
        public boolean hasNext() {
            return !this.queue.isEmpty();
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more elements available");
            }
            PeekingIterator<T> nextItr = this.queue.remove();
            Object next = nextItr.next();
            if (nextItr.hasNext()) {
                this.queue.add(nextItr);
            }
            return (T)next;
        }
    }
}

