/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.sling.resourceresolver.impl.ResourceResolverFactoryConfig;
import org.apache.sling.resourceresolver.impl.mapping.MapConfigurationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class VanityPathConfigurer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private volatile ResourceResolverFactoryConfig config;
    private volatile List<MapConfigurationProvider.VanityPathConfig> vanityPathConfig;

    VanityPathConfigurer() {
    }

    public void setConfiguration(ResourceResolverFactoryConfig c, DeprecatedVanityConfig deprecatedConfig) {
        this.config = c;
        this.vanityPathConfig = null;
        List<String> includes = this.configureVanityPathPrefixes(c.resource_resolver_vanitypath_allowlist(), deprecatedConfig == null ? null : deprecatedConfig.resource_resolver_vanitypath_whitelist(), "resource.resolver.vanitypath.allowlist", "resource.resolver.vanitypath.whitelist");
        List<String> excludes = this.configureVanityPathPrefixes(c.resource_resolver_vanitypath_denylist(), deprecatedConfig == null ? null : deprecatedConfig.resource_resolver_vanitypath_blacklist(), "resource.resolver.vanitypath.denylist", "resource.resolver.vanitypath.blacklist");
        if (includes != null || excludes != null) {
            this.vanityPathConfig = new ArrayList<MapConfigurationProvider.VanityPathConfig>();
            if (includes != null) {
                for (String val : includes) {
                    this.vanityPathConfig.add(new MapConfigurationProvider.VanityPathConfig(val, false));
                }
            }
            if (excludes != null) {
                for (String val : excludes) {
                    this.vanityPathConfig.add(new MapConfigurationProvider.VanityPathConfig(val, true));
                }
            }
            Collections.sort(this.vanityPathConfig);
        }
    }

    public int getDefaultVanityPathRedirectStatus() {
        return this.config.resource_resolver_default_vanity_redirect_status();
    }

    public boolean isVanityPathEnabled() {
        return this.config.resource_resolver_enable_vanitypath();
    }

    public boolean isVanityPathCacheInitInBackground() {
        return this.config.resource_resolver_vanitypath_cache_in_background();
    }

    public List<MapConfigurationProvider.VanityPathConfig> getVanityPathConfig() {
        return this.vanityPathConfig;
    }

    public boolean hasVanityPathPrecedence() {
        return this.config.resource_resolver_vanity_precedence();
    }

    public long getMaxCachedVanityPathEntries() {
        return this.config.resource_resolver_vanitypath_maxEntries();
    }

    public boolean isMaxCachedVanityPathEntriesStartup() {
        return this.config.resource_resolver_vanitypath_maxEntries_startup();
    }

    public int getVanityBloomFilterMaxBytes() {
        return this.config.resource_resolver_vanitypath_bloomfilter_maxBytes();
    }

    private boolean isDefined(String[] value) {
        return value != null && value.length > 0;
    }

    List<String> configureVanityPathPrefixes(String[] pathPrefixes, String[] pathPrefixesFallback, String pathPrefixesPropertyName, String pathPrefixesFallbackPropertyName) {
        if (this.isDefined(pathPrefixes) && this.isDefined(pathPrefixesFallback)) {
            this.logger.error("Both properties, " + pathPrefixesPropertyName + " and " + pathPrefixesFallbackPropertyName + ", were defined. Using " + pathPrefixesPropertyName + " for configuring vanity paths. Please remove the other property from your configuration.");
            return VanityPathConfigurer.filterVanityPathPrefixes(pathPrefixes);
        }
        if (this.isDefined(pathPrefixes)) {
            return VanityPathConfigurer.filterVanityPathPrefixes(pathPrefixes);
        }
        if (this.isDefined(pathPrefixesFallback)) {
            this.logger.warn("The property " + pathPrefixesPropertyName + " was not set. Using the " + pathPrefixesFallbackPropertyName + " instead. Please update your configuration to use " + pathPrefixesPropertyName);
            return VanityPathConfigurer.filterVanityPathPrefixes(pathPrefixesFallback);
        }
        return null;
    }

    private static List<String> filterVanityPathPrefixes(String[] vanityPathPrefixes) {
        ArrayList<String> prefixList = new ArrayList<String>();
        for (String value : vanityPathPrefixes) {
            if (value.trim().length() <= 0) continue;
            if (value.trim().endsWith("/")) {
                prefixList.add(value.trim());
                continue;
            }
            prefixList.add(value.trim().concat("/"));
        }
        return prefixList.isEmpty() ? null : prefixList;
    }

    public static @interface DeprecatedVanityConfig {
        public String[] resource_resolver_vanitypath_whitelist();

        public String[] resource_resolver_vanitypath_blacklist();
    }
}

