/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.launchpad.base.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.apache.sling.launchpad.api.LaunchpadContentProvider;

public class ClassLoaderResourceProvider
implements LaunchpadContentProvider {
    private final ClassLoader classLoader;

    public ClassLoaderResourceProvider(ClassLoader classLoader) {
        this.classLoader = classLoader != null ? classLoader : this.getClass().getClassLoader();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Iterator<String> getChildren(String path) {
        List children;
        URL url;
        if (path.endsWith("/") && path.length() > 1) {
            path = path.substring(0, path.length() - 1);
        }
        if ((url = this.classLoader.getResource(path)) != null) {
            Pattern pathPattern = Pattern.compile("^" + path + "/[^/]+/?$");
            children = new ArrayList();
            try {
                URLConnection conn = url.openConnection();
                if (!(conn instanceof JarURLConnection)) return children.iterator();
                JarFile jar = ((JarURLConnection)conn).getJarFile();
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    String entry = entries.nextElement().getName();
                    if (!pathPattern.matcher(entry).matches()) continue;
                    children.add(entry);
                }
                return children.iterator();
            }
            catch (IOException iOException) {
                return children.iterator();
            }
        } else {
            children = Collections.emptyList();
        }
        return children.iterator();
    }

    @Override
    public URL getResource(String path) {
        if (path == null || path.length() == 0) {
            return null;
        }
        if (path.charAt(0) == '/') {
            path = path.substring(1);
        }
        return this.classLoader != null ? this.classLoader.getResource(path) : null;
    }

    @Override
    public InputStream getResourceAsStream(String path) {
        URL res = this.getResource(path);
        if (res != null) {
            try {
                return res.openStream();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }
}

