/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal.helper;

import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.sling.jcr.resource.internal.helper.Converter;
import org.apache.sling.jcr.resource.internal.helper.NumberConverter;
import org.jetbrains.annotations.NotNull;

public class CalendarConverter
extends NumberConverter
implements Converter {
    private final Calendar value;

    public CalendarConverter(Calendar val) {
        super(val.getTimeInMillis());
        this.value = val;
    }

    @Override
    @NotNull
    public ZonedDateTime toZonedDateTime() {
        return ZonedDateTime.ofInstant(this.value.toInstant(), this.value.getTimeZone().toZoneId().normalized());
    }

    @Override
    @NotNull
    public Calendar toCalendar() {
        return this.value;
    }

    @Override
    @NotNull
    public Date toDate() {
        return this.value.getTime();
    }

    @Override
    public String toString() {
        return ISO8601.format(this.value);
    }
}

