/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.media.impl.ipeconfig;

import io.wcm.handler.media.MediaRequest;
import io.wcm.handler.media.format.MediaFormat;
import io.wcm.handler.media.format.MediaFormatBuilder;
import io.wcm.handler.media.format.MediaFormatHandler;
import io.wcm.handler.media.format.Ratio;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CroppingRatios {
    public static final MediaFormat MEDIAFORMAT_FREE_CROP = MediaFormatBuilder.create("__FREE_CROP__").label("Free Hand").build();
    private final MediaFormatHandler mediaFormatHandler;

    public CroppingRatios(@NotNull MediaFormatHandler mediaFormatHandler) {
        this.mediaFormatHandler = mediaFormatHandler;
    }

    @NotNull
    public Set<String> getMediaFormatsForCropping(@NotNull MediaRequest mediaRequest) {
        MediaFormat[] requestMediaFormats = mediaRequest.getMediaArgs().getMediaFormats();
        if (requestMediaFormats != null) {
            return this.toNameSet(Arrays.stream(mediaRequest.getMediaArgs().getMediaFormats()));
        }
        return this.toNameSet(this.getUniqueRatios().stream());
    }

    private Set<MediaFormat> getUniqueRatios() {
        SortedSet<MediaFormat> all = this.mediaFormatHandler.getMediaFormats();
        HashSet<MediaFormat> result = new HashSet<MediaFormat>();
        result.add(MEDIAFORMAT_FREE_CROP);
        for (MediaFormat mediaFormat : all) {
            if (!mediaFormat.isImage() || !mediaFormat.hasRatio()) continue;
            MediaFormat existingMediaFormat = this.getExistingMediaFormatWithRatio(result, mediaFormat.getRatio());
            if (existingMediaFormat != null) {
                if ((!this.hasDimension(existingMediaFormat) || this.hasDimension(mediaFormat)) && !this.isBigger(mediaFormat, existingMediaFormat)) continue;
                result.remove(existingMediaFormat);
                result.add(mediaFormat);
                continue;
            }
            result.add(mediaFormat);
        }
        return result;
    }

    @Nullable
    private MediaFormat getExistingMediaFormatWithRatio(Set<MediaFormat> all, double ratio) {
        return all.stream().filter(mediaFormat -> Ratio.matches(mediaFormat.getRatio(), ratio)).findFirst().orElse(null);
    }

    private boolean isBigger(@NotNull MediaFormat mediaFormat1, @NotNull MediaFormat mediaFormat2) {
        return mediaFormat1.getEffectiveMinWidth() > mediaFormat2.getEffectiveMinWidth() && mediaFormat2.getEffectiveMinWidth() > 0L;
    }

    private boolean hasDimension(@NotNull MediaFormat mediaFormat) {
        return !(mediaFormat.getEffectiveMinWidth() <= 0L && mediaFormat.getEffectiveMaxWidth() <= 0L || mediaFormat.getEffectiveMinHeight() <= 0L && mediaFormat.getEffectiveMaxHeight() <= 0L);
    }

    @NotNull
    private Set<String> toNameSet(@NotNull Stream<MediaFormat> mediaFormats) {
        return mediaFormats.map(MediaFormat::getName).collect(Collectors.toSet());
    }
}

