/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.analyser.task.impl;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.sling.feature.analyser.task.AnalyserTask;
import org.apache.sling.feature.analyser.task.AnalyserTaskContext;
import org.apache.sling.feature.scanner.ContentPackageDescriptor;

public class CheckContentPackagesForPaths
implements AnalyserTask {
    private static final String PROP_INCLUDES = "includes";
    private static final String PROP_EXCLUDES = "excludes";

    @Override
    public String getName() {
        return "Content Packages Path Check";
    }

    @Override
    public String getId() {
        return "content-packages-paths";
    }

    @Override
    public void execute(AnalyserTaskContext ctx) throws Exception {
        Rules rules = new Rules(ctx);
        if (!rules.isConfigured()) {
            ctx.reportError("Configuration for task " + this.getId() + " is missing.");
            return;
        }
        for (ContentPackageDescriptor d : ctx.getFeatureDescriptor().getDescriptors(ContentPackageDescriptor.class)) {
            this.checkPackage(ctx, d, rules);
        }
    }

    void checkPackage(AnalyserTaskContext ctx, ContentPackageDescriptor desc, Rules rules) {
        desc.getContentPaths().stream().filter(rules::isDisAllowed).forEach(path -> ctx.reportArtifactError(desc.getArtifact().getId(), "Content not allowed: " + path));
    }

    static final class Rules {
        final String[] includes;
        final String[] excludes;

        Rules(AnalyserTaskContext ctx) {
            String inc = ctx.getConfiguration().get(CheckContentPackagesForPaths.PROP_INCLUDES);
            String exc = ctx.getConfiguration().get(CheckContentPackagesForPaths.PROP_EXCLUDES);
            this.includes = this.splitAndTrim(inc);
            this.excludes = this.splitAndTrim(exc);
        }

        private String[] splitAndTrim(String property) {
            if (property == null) {
                return new String[0];
            }
            return Stream.of(property.split(",")).map(String::trim).collect(Collectors.toList()).toArray(new String[0]);
        }

        boolean isConfigured() {
            return this.includes.length > 0 || this.excludes.length > 0;
        }

        boolean isDisAllowed(String path) {
            return !this.isAllowed(path);
        }

        boolean isAllowed(String path) {
            boolean isAllowed = this.includes.length == 0;
            int matchLength = 0;
            if (!isAllowed) {
                for (String i : this.includes) {
                    if (!path.equals(i) && !path.startsWith(i.concat("/"))) continue;
                    isAllowed = true;
                    matchLength = i.length();
                    break;
                }
            }
            if (isAllowed && this.excludes.length > 0) {
                for (String i : this.excludes) {
                    if (!path.equals(i) && (!path.startsWith(i.concat("/")) || i.length() <= matchLength)) continue;
                    isAllowed = false;
                    break;
                }
            }
            return isAllowed;
        }
    }
}

