/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.skywalking.apm.util.StringUtil;

public enum PropertyPlaceholderHelper {
    INSTANCE("${", "}", ":", true);

    private final String placeholderPrefix;
    private final String placeholderSuffix;
    private final String simplePrefix;
    private final String valueSeparator;
    private final boolean ignoreUnresolvablePlaceholders;

    private PropertyPlaceholderHelper(String placeholderPrefix, String placeholderSuffix, String valueSeparator, boolean ignoreUnresolvablePlaceholders) {
        if (StringUtil.isEmpty(placeholderPrefix) || StringUtil.isEmpty(placeholderSuffix)) {
            throw new UnsupportedOperationException("'placeholderPrefix or placeholderSuffix' must not be null");
        }
        HashMap<String, String> wellKnownSimplePrefixes = new HashMap<String, String>(4);
        wellKnownSimplePrefixes.put("}", "{");
        wellKnownSimplePrefixes.put("]", "[");
        wellKnownSimplePrefixes.put(")", "(");
        this.placeholderPrefix = placeholderPrefix;
        this.placeholderSuffix = placeholderSuffix;
        String simplePrefixForSuffix = (String)wellKnownSimplePrefixes.get(this.placeholderSuffix);
        this.simplePrefix = simplePrefixForSuffix != null && this.placeholderPrefix.endsWith(simplePrefixForSuffix) ? simplePrefixForSuffix : this.placeholderPrefix;
        this.valueSeparator = valueSeparator;
        this.ignoreUnresolvablePlaceholders = ignoreUnresolvablePlaceholders;
    }

    public String replacePlaceholders(String value, final Properties properties) {
        return this.replacePlaceholders(value, new PlaceholderResolver(){

            @Override
            public String resolvePlaceholder(String placeholderName) {
                return PropertyPlaceholderHelper.this.getConfigValue(placeholderName, properties);
            }
        });
    }

    private String getConfigValue(String key, Properties properties) {
        String value = System.getProperty(key);
        if (value == null) {
            value = System.getenv(key);
        }
        if (value == null) {
            value = properties.getProperty(key);
        }
        return value;
    }

    public String replacePlaceholders(String value, PlaceholderResolver placeholderResolver) {
        return this.parseStringValue(value, placeholderResolver, new HashSet<String>());
    }

    protected String parseStringValue(String value, PlaceholderResolver placeholderResolver, Set<String> visitedPlaceholders) {
        StringBuilder result = new StringBuilder(value);
        int startIndex = value.indexOf(this.placeholderPrefix);
        while (startIndex != -1) {
            int endIndex = this.findPlaceholderEndIndex(result, startIndex);
            if (endIndex != -1) {
                int separatorIndex;
                String placeholder = result.substring(startIndex + this.placeholderPrefix.length(), endIndex);
                String originalPlaceholder = placeholder;
                if (!visitedPlaceholders.add(originalPlaceholder)) {
                    throw new IllegalArgumentException("Circular placeholder reference '" + originalPlaceholder + "' in property definitions");
                }
                String propVal = placeholderResolver.resolvePlaceholder(placeholder = this.parseStringValue(placeholder, placeholderResolver, visitedPlaceholders));
                if (propVal == null && this.valueSeparator != null && (separatorIndex = placeholder.indexOf(this.valueSeparator)) != -1) {
                    String actualPlaceholder = placeholder.substring(0, separatorIndex);
                    String defaultValue = placeholder.substring(separatorIndex + this.valueSeparator.length());
                    propVal = placeholderResolver.resolvePlaceholder(actualPlaceholder);
                    if (propVal == null) {
                        propVal = defaultValue;
                    }
                }
                if (propVal != null) {
                    propVal = this.parseStringValue(propVal, placeholderResolver, visitedPlaceholders);
                    result.replace(startIndex, endIndex + this.placeholderSuffix.length(), propVal);
                    startIndex = result.indexOf(this.placeholderPrefix, startIndex + propVal.length());
                } else if (this.ignoreUnresolvablePlaceholders) {
                    startIndex = result.indexOf(this.placeholderPrefix, endIndex + this.placeholderSuffix.length());
                } else {
                    throw new IllegalArgumentException("Could not resolve placeholder '" + placeholder + "' in value \"" + value + "\"");
                }
                visitedPlaceholders.remove(originalPlaceholder);
                continue;
            }
            startIndex = -1;
        }
        return result.toString();
    }

    private int findPlaceholderEndIndex(CharSequence buf, int startIndex) {
        int index = startIndex + this.placeholderPrefix.length();
        int withinNestedPlaceholder = 0;
        while (index < buf.length()) {
            if (StringUtil.substringMatch(buf, index, this.placeholderSuffix)) {
                if (withinNestedPlaceholder > 0) {
                    --withinNestedPlaceholder;
                    index += this.placeholderSuffix.length();
                    continue;
                }
                return index;
            }
            if (StringUtil.substringMatch(buf, index, this.simplePrefix)) {
                ++withinNestedPlaceholder;
                index += this.simplePrefix.length();
                continue;
            }
            ++index;
        }
        return -1;
    }

    public static interface PlaceholderResolver {
        public String resolvePlaceholder(String var1);
    }
}

