/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.core.profile;

import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.skywalking.apm.agent.core.conf.Config;
import org.apache.skywalking.apm.agent.core.context.TracingContext;
import org.apache.skywalking.apm.agent.core.profile.ProfileStatus;
import org.apache.skywalking.apm.agent.core.profile.ProfileStatusContext;
import org.apache.skywalking.apm.agent.core.profile.ProfileTaskExecutionContext;
import org.apache.skywalking.apm.agent.core.profile.TracingThreadSnapshot;
import org.apache.skywalking.apm.dependencies.com.google.common.base.Objects;

public class ThreadProfiler {
    private final TracingContext tracingContext;
    private final String traceSegmentId;
    private final Thread profilingThread;
    private final ProfileTaskExecutionContext executionContext;
    private long profilingStartTime;
    private long profilingMaxTimeMills;
    private final ProfileStatusContext profilingStatus;
    private int dumpSequence = 0;

    public ThreadProfiler(TracingContext tracingContext, String traceSegmentId, Thread profilingThread, ProfileTaskExecutionContext executionContext) {
        this.tracingContext = tracingContext;
        this.traceSegmentId = traceSegmentId;
        this.profilingThread = profilingThread;
        this.executionContext = executionContext;
        if (tracingContext.profileStatus() == null) {
            this.profilingStatus = ProfileStatusContext.createWithPending(this.tracingContext().createTime());
        } else {
            this.profilingStatus = tracingContext.profileStatus();
            this.profilingStatus.updateStatus(ProfileStatus.PENDING, tracingContext);
        }
        this.profilingMaxTimeMills = TimeUnit.MINUTES.toMillis(Config.Profile.MAX_DURATION);
    }

    public void startProfilingIfNeed() {
        if (System.currentTimeMillis() - this.profilingStatus.firstSegmentCreateTime() > (long)this.executionContext.getTask().getMinDurationThreshold()) {
            this.profilingStartTime = System.currentTimeMillis();
            this.profilingStatus.updateStatus(ProfileStatus.PROFILING, this.tracingContext);
        }
    }

    public void stopProfiling() {
        this.profilingStatus.updateStatus(ProfileStatus.STOPPED, this.tracingContext);
    }

    public TracingThreadSnapshot buildSnapshot() {
        StackTraceElement[] stackTrace;
        if (!this.isProfilingContinuable()) {
            return null;
        }
        long currentTime = System.currentTimeMillis();
        try {
            stackTrace = this.profilingThread.getStackTrace();
            if (stackTrace.length == 0) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        if (this.dumpSequence == 0 && !this.executionContext.isStartProfileable()) {
            return null;
        }
        int dumpElementCount = Math.min(stackTrace.length, Config.Profile.DUMP_MAX_STACK_DEPTH);
        ArrayList<String> stackList = new ArrayList<String>(dumpElementCount);
        for (int i = dumpElementCount - 1; i >= 0; --i) {
            stackList.add(this.buildStackElementCodeSignature(stackTrace[i]));
        }
        String taskId = this.executionContext.getTask().getTaskId();
        return new TracingThreadSnapshot(taskId, this.traceSegmentId, this.dumpSequence++, currentTime, stackList);
    }

    private String buildStackElementCodeSignature(StackTraceElement element) {
        return element.getClassName() + "." + element.getMethodName() + ":" + element.getLineNumber();
    }

    public boolean matches(TracingContext context) {
        return Objects.equal(context.getSegmentId(), this.tracingContext.getSegmentId());
    }

    private boolean isProfilingContinuable() {
        return System.currentTimeMillis() - this.profilingStartTime < this.profilingMaxTimeMills;
    }

    public TracingContext tracingContext() {
        return this.tracingContext;
    }

    public ProfileStatusContext profilingStatus() {
        return this.profilingStatus;
    }
}

