/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.rocketMQ.client.java.v5;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.rocketmq.client.apis.message.Message;
import org.apache.rocketmq.client.apis.message.MessageBuilder;
import org.apache.rocketmq.client.apis.producer.SendReceipt;
import org.apache.rocketmq.client.java.impl.ClientImpl;
import org.apache.rocketmq.client.java.message.MessageBuilderImpl;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.AbstractTag;
import org.apache.skywalking.apm.agent.core.context.tag.StringTag;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.agent.core.util.CollectionUtil;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.rocketMQ.client.java.v5.RocketMqClientJavaPluginConfig;
import org.apache.skywalking.apm.util.StringUtil;

public class MessageSendInterceptor
implements InstanceMethodsAroundInterceptor {
    public static final String ASYNC_SEND_OPERATION_NAME_PREFIX = "RocketMQ/";
    public static final StringTag MQ_MESSAGE_ID = new StringTag("mq.message.id");
    public static final StringTag MQ_MESSAGE_KEYS = new StringTag("mq.message.keys");
    public static final StringTag MQ_MESSAGE_TAGS = new StringTag("mq.message.tags");

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        Optional tag;
        Collection keys;
        Message message = (Message)allArguments[0];
        ClientImpl producerImpl = (ClientImpl)objInst;
        ContextCarrier contextCarrier = new ContextCarrier();
        String namingServiceAddress = producerImpl.getClientConfiguration().getEndpoints();
        AbstractSpan span = ContextManager.createExitSpan((String)this.buildOperationName(message.getTopic()), (ContextCarrier)contextCarrier, (String)namingServiceAddress);
        span.setComponent((Component)ComponentsDefine.ROCKET_MQ_PRODUCER);
        Tags.MQ_BROKER.set(span, namingServiceAddress);
        Tags.MQ_TOPIC.set(span, message.getTopic());
        if (RocketMqClientJavaPluginConfig.Plugin.Rocketmqclient.COLLECT_MESSAGE_KEYS && !CollectionUtil.isEmpty((Collection)(keys = message.getKeys()))) {
            span.tag((AbstractTag)MQ_MESSAGE_KEYS, keys.stream().collect(Collectors.joining(",")));
        }
        if (RocketMqClientJavaPluginConfig.Plugin.Rocketmqclient.COLLECT_MESSAGE_TAGS && (tag = message.getTag()).isPresent()) {
            span.tag((AbstractTag)MQ_MESSAGE_TAGS, (String)tag.get());
        }
        contextCarrier.extensionInjector().injectSendingTimestamp();
        SpanLayer.asMQ((AbstractSpan)span);
        Map properties = message.getProperties();
        CarrierItem next = contextCarrier.items();
        while (next.hasNext()) {
            if (StringUtil.isEmpty((String)(next = next.next()).getHeadValue())) continue;
            properties.put(next.getHeadKey(), next.getHeadValue());
        }
        MessageBuilderImpl messageBuilder = new MessageBuilderImpl();
        messageBuilder.setTopic(message.getTopic());
        if (message.getTag().isPresent()) {
            messageBuilder.setTag((String)message.getTag().get());
        }
        messageBuilder.setKeys(message.getKeys().toArray(new String[0]));
        if (message.getMessageGroup().isPresent()) {
            messageBuilder.setMessageGroup((String)message.getMessageGroup().get());
        }
        byte[] body = new byte[message.getBody().limit()];
        message.getBody().get(body);
        messageBuilder.setBody(body);
        if (message.getDeliveryTimestamp().isPresent()) {
            messageBuilder.setDeliveryTimestamp(((Long)message.getDeliveryTimestamp().get()).longValue());
        }
        properties.entrySet().forEach(arg_0 -> MessageSendInterceptor.lambda$beforeMethod$0((MessageBuilder)messageBuilder, arg_0));
        allArguments[0] = messageBuilder.build();
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        SendReceipt sendReceipt = (SendReceipt)ret;
        if (sendReceipt != null && sendReceipt.getMessageId() != null) {
            AbstractSpan activeSpan = ContextManager.activeSpan();
            activeSpan.tag((AbstractTag)MQ_MESSAGE_ID, sendReceipt.getMessageId().toString());
        }
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ContextManager.activeSpan().log(t);
    }

    private String buildOperationName(String topicName) {
        return ASYNC_SEND_OPERATION_NAME_PREFIX + topicName + "/Producer";
    }

    private static /* synthetic */ void lambda$beforeMethod$0(MessageBuilder messageBuilder, Map.Entry item) {
        messageBuilder.addProperty((String)item.getKey(), (String)item.getValue());
    }
}

