/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.xxljob;

import com.xxl.job.core.context.XxlJobHelper;
import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.xxljob.Constants;

public class ScriptJobHandlerMethodInterceptor
implements InstanceMethodsAroundInterceptor {
    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        String jobTypeAndId = (String)objInst.getSkyWalkingDynamicField();
        String operationName = ComponentsDefine.XXL_JOB.getName() + "/ScriptJob/" + jobTypeAndId;
        AbstractSpan span = ContextManager.createLocalSpan((String)operationName);
        span.setComponent((Component)ComponentsDefine.XXL_JOB);
        Tags.LOGIC_ENDPOINT.set(span, "{\"logic-span\":true}");
        if (allArguments.length == 1) {
            String jobParam = (String)allArguments[0];
            span.tag(Constants.JOB_PARAM, jobParam);
        } else if (allArguments.length == 0) {
            String jobParam = XxlJobHelper.getJobParam();
            span.tag(Constants.JOB_PARAM, jobParam);
        }
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        ContextManager.stopSpan();
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ContextManager.activeSpan().log(t);
    }
}

