/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.finagle;

import com.twitter.finagle.context.Context;
import com.twitter.finagle.context.Contexts;
import com.twitter.finagle.context.LocalContext;
import com.twitter.finagle.context.MarshalledContext;
import com.twitter.io.Buf;
import com.twitter.util.Local;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedList;
import org.apache.skywalking.apm.plugin.finagle.ContextHolder;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.Map;

class ContextHolderFactory {
    private static final String CONTEXT_ENV_CLASS = "com.twitter.finagle.context.Context$Env";
    private static ContextHolder MARSHALLED_CONTEXT_HOLDER;
    private static ContextHolder LOCAL_CONTEXT_HOLDER;

    ContextHolderFactory() {
    }

    static ContextHolder getMarshalledContextHolder() {
        return MARSHALLED_CONTEXT_HOLDER;
    }

    static ContextHolder getLocalContextHolder() {
        return LOCAL_CONTEXT_HOLDER;
    }

    static {
        try {
            Class.forName(CONTEXT_ENV_CLASS);
            MARSHALLED_CONTEXT_HOLDER = new EnvContextHolder((Context)Contexts.broadcast());
            LOCAL_CONTEXT_HOLDER = new EnvContextHolder((Context)Contexts.local());
        }
        catch (ClassNotFoundException e) {
            LOCAL_CONTEXT_HOLDER = new MapLocalContextHolder(Contexts.local());
            MARSHALLED_CONTEXT_HOLDER = new MapMarshalledContextHolder(Contexts.broadcast());
        }
    }

    static class EnvContextHolder
    extends AbstractContextHolder<Context.Env> {
        private static final String LOCAL_FIELD_NAME = "com$twitter$finagle$context$Context$$local";

        EnvContextHolder(Context context) {
            super(context, LOCAL_FIELD_NAME);
        }

        @Override
        protected Context.Env getUpdatedContext(Context.Env currentContext, Object key, Object value) {
            return currentContext.bound(key, value);
        }
    }

    static class MapLocalContextHolder
    extends AbstractContextHolder<Map<LocalContext.Key, Object>> {
        private static final String LOCAL_FIELD_NAME = "local";

        MapLocalContextHolder(LocalContext context) {
            super((Context)context, LOCAL_FIELD_NAME);
        }

        @Override
        protected Map<LocalContext.Key, Object> getUpdatedContext(Map<LocalContext.Key, Object> currentContext, Object key, Object value) {
            this.checkKeyType(key);
            return currentContext.updated((Object)((LocalContext.Key)key), value);
        }

        private void checkKeyType(Object key) {
            if (!(key instanceof LocalContext.Key)) {
                throw new IllegalArgumentException("key should be subclass of LocalContext.Key");
            }
        }
    }

    static class MapMarshalledContextHolder
    extends AbstractContextHolder<Map<Buf, Object>> {
        private static final String LOCAL_FIELD_NAME = "local";
        private static final Constructor REAL_CONSTRUCTOR;

        MapMarshalledContextHolder(MarshalledContext context) {
            super((Context)context, LOCAL_FIELD_NAME);
        }

        @Override
        protected Map<Buf, Object> getUpdatedContext(Map<Buf, Object> currentContext, Object key, Object value) {
            this.checkKeyType(key);
            try {
                MarshalledContext.Key marshalledContextKey = (MarshalledContext.Key)key;
                Object real = REAL_CONSTRUCTOR.newInstance(Contexts.broadcast(), marshalledContextKey, Some$.MODULE$.apply(value));
                return currentContext.updated((Object)marshalledContextKey.marshalId(), real);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private void checkKeyType(Object key) {
            if (!(key instanceof MarshalledContext.Key)) {
                throw new IllegalArgumentException("key should be subclass of MarshalledContext.Key");
            }
        }

        static {
            try {
                Class<?> clz = Class.forName(MarshalledContext.class.getName() + "$Real");
                REAL_CONSTRUCTOR = clz.getDeclaredConstructor(MarshalledContext.class, MarshalledContext.Key.class, Some.class);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    static abstract class AbstractContextHolder<S>
    extends ContextHolder {
        final Local<S> local;
        final S initContext;
        private final ThreadLocal<LinkedList<Snapshot<S>>> snapshots;

        AbstractContextHolder(Context context, String localFieldName) {
            this.local = this.getLocal(context, localFieldName);
            this.initContext = this.getInitContext(context);
            this.snapshots = new ThreadLocal<LinkedList<Snapshot<S>>>(){

                @Override
                protected LinkedList<Snapshot<S>> initialValue() {
                    return new LinkedList();
                }
            };
        }

        @Override
        void let(Object key, Object value) {
            S currentContext = this.getCurrentContext();
            this.snapshots.get().push(new Snapshot(key, currentContext));
            this.local.update(this.getUpdatedContext(currentContext, key, value));
        }

        @Override
        void remove(Object key) {
            Snapshot<S> snapshot = this.snapshots.get().peek();
            if (snapshot == null || !((Snapshot)snapshot).key.equals(key)) {
                throw new IllegalStateException(String.format("can't remove %s. the order of remove must be opposite with let.", key));
            }
            this.local.update(((Snapshot)snapshot).saved);
            this.snapshots.get().pop();
        }

        private S getCurrentContext() {
            if (this.local.apply().isDefined()) {
                return (S)this.local.apply().get();
            }
            return this.initContext;
        }

        protected abstract S getUpdatedContext(S var1, Object var2, Object var3);

        private Local<S> getLocal(Context context, String localFieldName) {
            try {
                Field localField = context.getClass().getDeclaredField(localFieldName);
                localField.setAccessible(true);
                return (Local)localField.get(context);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private S getInitContext(Context context) {
            try {
                Method method = context.getClass().getDeclaredMethod("env", new Class[0]);
                method.setAccessible(true);
                return (S)method.invoke((Object)context, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        static class Snapshot<S> {
            private Object key;
            private S saved;

            private Snapshot(Object key, S saved) {
                this.key = key;
                this.saved = saved;
            }
        }
    }
}

