/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.nats.client;

import io.nats.client.Message;
import io.nats.client.impl.NatsMessage;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Optional;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.ContextSnapshot;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.plugin.PluginException;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.plugin.nats.client.NatsCommons;

public class WriterSendMessageBatchInterceptor
implements InstanceMethodsAroundInterceptor {
    private static final Field NEXT_FIELD;

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        Object next = allArguments[0];
        String services = (String)objInst.getSkyWalkingDynamicField();
        while (next != null) {
            if (!NatsCommons.skipTrace(next)) {
                Message message = (Message)next;
                EnhancedInstance enhanced = (EnhancedInstance)next;
                AbstractSpan span = ContextManager.createExitSpan((String)("Nats/Pub/" + message.getSubject()), (String)services);
                NatsCommons.addCommonTag(span, message);
                Tags.MQ_BROKER.set(span, services);
                Optional.ofNullable(enhanced.getSkyWalkingDynamicField()).ifPresent(snapshot -> ContextManager.continued((ContextSnapshot)((ContextSnapshot)snapshot)));
                NatsCommons.injectCarrier(message);
                enhanced.setSkyWalkingDynamicField(null);
            }
            next = this.next(next);
        }
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        while (ContextManager.isActive()) {
            AbstractSpan abstractSpan = ContextManager.activeSpan();
            ContextManager.stopSpan((AbstractSpan)abstractSpan);
        }
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        while (ContextManager.isActive()) {
            AbstractSpan span = ContextManager.activeSpan();
            span.log(t);
            span.errorOccurred();
            ContextManager.stopSpan((AbstractSpan)span);
        }
        Object next = allArguments[0];
        try {
            while (next != null) {
                if (!NatsCommons.skipTrace(next)) {
                    EnhancedInstance enhanced = (EnhancedInstance)next;
                    enhanced.setSkyWalkingDynamicField(null);
                }
                next = this.next(next);
            }
        }
        catch (IllegalAccessException e) {
            throw new PluginException("nats plugin error", (Throwable)e);
        }
    }

    private NatsMessage next(Object message) throws IllegalAccessException {
        if (NEXT_FIELD == null) {
            return null;
        }
        if (!(message instanceof NatsMessage)) {
            return null;
        }
        return (NatsMessage)NEXT_FIELD.get(message);
    }

    static {
        Field field;
        try {
            field = NatsMessage.class.getDeclaredField("next");
            field.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            field = null;
        }
        NEXT_FIELD = field;
    }
}

