/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.common;

import org.apache.servicecomb.foundation.common.LegacyPropertyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TransportConfigUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransportConfigUtils.class);

    private TransportConfigUtils() {
    }

    public static int readVerticleCount(String key, String deprecatedKey) {
        int count = LegacyPropertyFactory.getIntProperty((String)key, (int)-1);
        if (count > 0) {
            return count;
        }
        count = LegacyPropertyFactory.getIntProperty((String)deprecatedKey, (int)-1);
        if (count > 0) {
            LOGGER.warn("{} is ambiguous, and deprecated, recommended to use {}.", (Object)deprecatedKey, (Object)key);
            return count;
        }
        count = Math.min(Runtime.getRuntime().availableProcessors(), 8);
        LOGGER.info("{} not defined, set to {}.", (Object)key, (Object)count);
        return count;
    }
}

