/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.geography;

import com.google.common.geometry.S2LatLng;
import com.google.common.geometry.S2LatLngRect;
import com.google.common.geometry.S2Loop;
import com.google.common.geometry.S2Point;
import com.google.common.geometry.S2Polygon;
import java.util.ArrayList;
import java.util.List;
import org.apache.sedona.common.S2Geography.Geography;
import org.apache.sedona.common.S2Geography.MultiPolygonGeography;
import org.apache.sedona.common.S2Geography.PolygonGeography;
import org.apache.sedona.common.S2Geography.SinglePointGeography;

public class Functions {
    private static final double EPSILON = 1.0E-9;

    private static boolean nearlyEqual(double a, double b) {
        if (Double.isNaN(a) || Double.isNaN(b)) {
            return false;
        }
        return Math.abs(a - b) < 1.0E-9;
    }

    public static Geography getEnvelope(Geography geography, boolean splitAtAntiMeridian) {
        Geography envelope;
        if (geography == null) {
            return null;
        }
        S2LatLngRect rect = geography.region().getRectBound();
        double lngLo = rect.lngLo().degrees();
        double latLo = rect.latLo().degrees();
        double lngHi = rect.lngHi().degrees();
        double latHi = rect.latHi().degrees();
        if (Functions.nearlyEqual(latLo, latHi) && Functions.nearlyEqual(lngLo, lngHi)) {
            S2Point point = S2LatLng.fromDegrees((double)latLo, (double)lngLo).toPoint();
            SinglePointGeography pointGeo = new SinglePointGeography(point);
            pointGeo.setSRID(geography.getSRID());
            return pointGeo;
        }
        if (splitAtAntiMeridian && rect.lng().isInverted()) {
            S2Polygon left = Functions.rectToPolygon(lngLo, latLo, 180.0, latHi);
            S2Polygon right = Functions.rectToPolygon(-180.0, latLo, lngHi, latHi);
            envelope = new MultiPolygonGeography(Geography.GeographyKind.MULTIPOLYGON, List.of(left, right));
        } else {
            envelope = new PolygonGeography(Functions.rectToPolygon(lngLo, latLo, lngHi, latHi));
        }
        envelope.setSRID(geography.getSRID());
        return envelope;
    }

    private static S2Polygon rectToPolygon(double lngLo, double latLo, double lngHi, double latHi) {
        ArrayList<S2Point> v = new ArrayList<S2Point>(4);
        v.add(S2LatLng.fromDegrees((double)latLo, (double)lngLo).toPoint());
        v.add(S2LatLng.fromDegrees((double)latLo, (double)lngHi).toPoint());
        v.add(S2LatLng.fromDegrees((double)latHi, (double)lngHi).toPoint());
        v.add(S2LatLng.fromDegrees((double)latHi, (double)lngLo).toPoint());
        S2Loop loop = new S2Loop(v);
        loop.normalize();
        return new S2Polygon(loop);
    }

    public static String asEWKT(Geography geography) {
        return geography.toEWKT();
    }
}

