/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.spatialOperator;

import java.io.Serializable;
import java.util.List;
import org.apache.sedona.common.FunctionsGeoTools;
import org.apache.sedona.core.knnJudgement.GeometryDistanceComparator;
import org.apache.sedona.core.knnJudgement.KnnJudgement;
import org.apache.sedona.core.knnJudgement.KnnJudgementUsingIndex;
import org.apache.sedona.core.spatialRDD.SpatialRDD;
import org.apache.spark.api.java.JavaRDD;
import org.locationtech.jts.geom.Geometry;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.TransformException;

public class KNNQuery
implements Serializable {
    public static <U extends Geometry, T extends Geometry> List<T> SpatialKnnQuery(SpatialRDD<T> spatialRDD, U originalQueryPoint, Integer k, boolean useIndex) {
        Object queryCenter = originalQueryPoint;
        if (spatialRDD.getCRStransformation()) {
            try {
                queryCenter = FunctionsGeoTools.transform(originalQueryPoint, spatialRDD.getSourceEpsgCode(), spatialRDD.getTargetEpgsgCode());
            }
            catch (FactoryException | TransformException e) {
                throw new RuntimeException(e);
            }
        }
        if (useIndex) {
            if (spatialRDD.indexedRawRDD == null) {
                throw new NullPointerException("Need to invoke buildIndex() first, indexedRDDNoId is null");
            }
            JavaRDD tmp = spatialRDD.indexedRawRDD.mapPartitions(new KnnJudgementUsingIndex(queryCenter, k));
            List result = tmp.takeOrdered(k.intValue(), new GeometryDistanceComparator<U>(queryCenter, true));
            return result;
        }
        JavaRDD tmp = spatialRDD.getRawSpatialRDD().mapPartitions(new KnnJudgement(queryCenter, k));
        List result = tmp.takeOrdered(k.intValue(), new GeometryDistanceComparator<U>(queryCenter, true));
        return result;
    }
}

