/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.utils;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.util.GeometryTransformer;

public class GeometryForce3DTransformer
extends GeometryTransformer {
    private final double zValue;

    public GeometryForce3DTransformer(double zValue) {
        this.zValue = zValue;
    }

    @Override
    protected CoordinateSequence transformCoordinates(CoordinateSequence coords, Geometry parent) {
        Coordinate[] newCoords = new Coordinate[coords.size()];
        for (int i = 0; i < coords.size(); ++i) {
            Coordinate coordinate = coords.getCoordinate(i);
            double z = coordinate.getZ();
            if (Double.isNaN(z)) {
                z = this.zValue;
            }
            newCoords[i] = new Coordinate(coordinate.getX(), coordinate.getY(), z);
        }
        return this.createCoordinateSequence(newCoords);
    }

    public static Geometry transform(Geometry geometry, double zValue) {
        if (geometry.getCoordinates().length == 0) {
            return geometry;
        }
        GeometryForce3DTransformer transformer = new GeometryForce3DTransformer(zValue);
        return transformer.transform(geometry);
    }
}

