"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.pProps = void 0;
const vue_1 = require("vue");
const _mixins_1 = require("../../_mixins");
const styles_1 = require("../styles");
const p_cssr_1 = __importDefault(require("./styles/p.cssr"));
exports.pProps = Object.assign(Object.assign({}, _mixins_1.useTheme.props), { depth: [String, Number] });
exports.default = (0, vue_1.defineComponent)({
    name: 'P',
    props: exports.pProps,
    setup(props) {
        const { mergedClsPrefixRef, inlineThemeDisabled } = (0, _mixins_1.useConfig)(props);
        const themeRef = (0, _mixins_1.useTheme)('Typography', '-p', p_cssr_1.default, styles_1.typographyLight, props, mergedClsPrefixRef);
        const cssVarsRef = (0, vue_1.computed)(() => {
            const { depth } = props;
            const typeSafeDepth = depth || '1';
            const { common: { cubicBezierEaseInOut }, self: { pFontSize, pLineHeight, pMargin, pTextColor, [`pTextColor${typeSafeDepth}Depth`]: depthTextColor } } = themeRef.value;
            return {
                '--n-bezier': cubicBezierEaseInOut,
                '--n-font-size': pFontSize,
                '--n-line-height': pLineHeight,
                '--n-margin': pMargin,
                '--n-text-color': depth === undefined ? pTextColor : depthTextColor
            };
        });
        const themeClassHandle = inlineThemeDisabled
            ? (0, _mixins_1.useThemeClass)('p', (0, vue_1.computed)(() => `${props.depth || ''}`), cssVarsRef, props)
            : undefined;
        return {
            mergedClsPrefix: mergedClsPrefixRef,
            cssVars: inlineThemeDisabled ? undefined : cssVarsRef,
            themeClass: themeClassHandle === null || themeClassHandle === void 0 ? void 0 : themeClassHandle.themeClass,
            onRender: themeClassHandle === null || themeClassHandle === void 0 ? void 0 : themeClassHandle.onRender
        };
    },
    render() {
        var _a;
        (_a = this.onRender) === null || _a === void 0 ? void 0 : _a.call(this);
        return ((0, vue_1.h)("p", { class: [`${this.mergedClsPrefix}-p`, this.themeClass], style: this.cssVars }, this.$slots));
    }
});
