/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.java.route;

import apache.rocketmq.v2.MessageQueue;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.math.IntMath;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.RandomUtils;
import org.apache.rocketmq.client.java.exception.NotFoundException;
import org.apache.rocketmq.client.java.route.Broker;
import org.apache.rocketmq.client.java.route.Endpoints;
import org.apache.rocketmq.client.java.route.MessageQueueImpl;
import org.apache.rocketmq.client.java.route.Permission;

public class TopicRouteData {
    private final AtomicInteger index = new AtomicInteger(RandomUtils.nextInt((int)0, (int)Integer.MAX_VALUE));
    private final ImmutableList<MessageQueueImpl> messageQueueImpls;

    public TopicRouteData(List<MessageQueue> messageQueues) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (MessageQueue messageQueue : messageQueues) {
            builder.add((Object)new MessageQueueImpl(messageQueue));
        }
        this.messageQueueImpls = builder.build();
    }

    public Set<Endpoints> getTotalEndpoints() {
        HashSet<Endpoints> endpointsSet = new HashSet<Endpoints>();
        for (MessageQueueImpl messageQueueImpl : this.messageQueueImpls) {
            endpointsSet.add(messageQueueImpl.getBroker().getEndpoints());
        }
        return endpointsSet;
    }

    public List<MessageQueueImpl> getMessageQueues() {
        return this.messageQueueImpls;
    }

    public Endpoints pickEndpointsToQueryAssignments() throws NotFoundException {
        int nextIndex = this.index.getAndIncrement();
        for (int i = 0; i < this.messageQueueImpls.size(); ++i) {
            MessageQueueImpl messageQueueImpl;
            Broker broker;
            if (0 != (broker = (messageQueueImpl = (MessageQueueImpl)this.messageQueueImpls.get(IntMath.mod((int)nextIndex++, (int)this.messageQueueImpls.size()))).getBroker()).getId() || Permission.NONE.equals((Object)messageQueueImpl.getPermission())) continue;
            return broker.getEndpoints();
        }
        throw new NotFoundException("Failed to pick endpoints to query assignment");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopicRouteData that = (TopicRouteData)o;
        return Objects.equal(this.messageQueueImpls, that.messageQueueImpls);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.messageQueueImpls});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("messageQueueImpls", this.messageQueueImpls).toString();
    }
}

