/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.shaded.io.opentelemetry.sdk.logs.export;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.common.CompletableResultCode;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.logs.data.LogData;
import org.apache.rocketmq.shaded.io.opentelemetry.sdk.logs.export.LogExporter;

public final class InMemoryLogExporter
implements LogExporter {
    private final Queue<LogData> finishedLogItems = new ConcurrentLinkedQueue<LogData>();
    private boolean isStopped = false;

    private InMemoryLogExporter() {
    }

    public static InMemoryLogExporter create() {
        return new InMemoryLogExporter();
    }

    public List<LogData> getFinishedLogItems() {
        return Collections.unmodifiableList(new ArrayList<LogData>(this.finishedLogItems));
    }

    public void reset() {
        this.finishedLogItems.clear();
    }

    @Override
    public CompletableResultCode export(Collection<LogData> logs) {
        if (this.isStopped) {
            return CompletableResultCode.ofFailure();
        }
        this.finishedLogItems.addAll(logs);
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public CompletableResultCode shutdown() {
        this.isStopped = true;
        this.finishedLogItems.clear();
        return CompletableResultCode.ofSuccess();
    }
}

