/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyengine;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ranger.plugin.contextenricher.RangerContextEnricher;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerPolicyDelta;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.model.validation.RangerServiceDefHelper;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerPluginContext;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngineOptions;
import org.apache.ranger.plugin.policyengine.RangerPolicyRepository;
import org.apache.ranger.plugin.policyengine.RangerSecurityZoneMatcher;
import org.apache.ranger.plugin.resourcematcher.RangerAbstractResourceMatcher;
import org.apache.ranger.plugin.service.RangerAuthContext;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.apache.ranger.plugin.util.RangerPolicyDeltaUtil;
import org.apache.ranger.plugin.util.RangerReadWriteLock;
import org.apache.ranger.plugin.util.RangerRoles;
import org.apache.ranger.plugin.util.ServiceDefUtil;
import org.apache.ranger.plugin.util.ServicePolicies;
import org.apache.ranger.plugin.util.StringTokenReplacer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyEngine {
    private static final Logger LOG = LoggerFactory.getLogger(PolicyEngine.class);
    private static final Logger PERF_POLICYENGINE_INIT_LOG = RangerPerfTracer.getPerfLogger("policyengine.init");
    private static final Logger PERF_POLICYENGINE_REBALANCE_LOG = RangerPerfTracer.getPerfLogger("policyengine.rebalance");
    private final RangerServiceDefHelper serviceDefHelper;
    private final RangerPolicyRepository policyRepository;
    private final RangerPolicyRepository tagPolicyRepository;
    private final List<RangerContextEnricher> allContextEnrichers;
    private final RangerPluginContext pluginContext;
    private final Map<String, RangerPolicyRepository> zonePolicyRepositories = new HashMap<String, RangerPolicyRepository>();
    private final RangerSecurityZoneMatcher zoneMatcher;
    private boolean useForwardedIPAddress;
    private String[] trustedProxyAddresses;
    private final Map<String, StringTokenReplacer> tokenReplacers = new HashMap<String, StringTokenReplacer>();
    private final RangerReadWriteLock lock;

    public RangerReadWriteLock.RangerLock getReadLock() {
        return this.lock.getReadLock();
    }

    public RangerReadWriteLock.RangerLock getWriteLock() {
        return this.lock.getWriteLock();
    }

    public boolean getUseForwardedIPAddress() {
        return this.useForwardedIPAddress;
    }

    public void setUseForwardedIPAddress(boolean useForwardedIPAddress) {
        this.useForwardedIPAddress = useForwardedIPAddress;
    }

    public String[] getTrustedProxyAddresses() {
        return this.trustedProxyAddresses;
    }

    public void setTrustedProxyAddresses(String[] trustedProxyAddresses) {
        this.trustedProxyAddresses = trustedProxyAddresses;
    }

    public long getRoleVersion() {
        return this.pluginContext.getAuthContext().getRoleVersion();
    }

    public void setRoles(RangerRoles roles) {
        this.pluginContext.getAuthContext().setRoles(roles);
    }

    public String getServiceName() {
        return this.policyRepository.getServiceName();
    }

    public RangerServiceDef getServiceDef() {
        return this.policyRepository.getServiceDef();
    }

    public long getPolicyVersion() {
        return this.policyRepository.getPolicyVersion();
    }

    public RangerServiceDefHelper getServiceDefHelper() {
        return this.serviceDefHelper;
    }

    public RangerPolicyRepository getPolicyRepository() {
        return this.policyRepository;
    }

    public RangerPolicyRepository getTagPolicyRepository() {
        return this.tagPolicyRepository;
    }

    public Map<String, RangerPolicyRepository> getZonePolicyRepositories() {
        return this.zonePolicyRepositories;
    }

    public List<RangerContextEnricher> getAllContextEnrichers() {
        return this.allContextEnrichers;
    }

    public RangerPluginContext getPluginContext() {
        return this.pluginContext;
    }

    public StringTokenReplacer getStringTokenReplacer(String resourceName) {
        return this.tokenReplacers.get(resourceName);
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }

    protected void finalize() throws Throwable {
        try {
            this.cleanup();
        }
        finally {
            super.finalize();
        }
    }

    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("PolicyEngine={");
        sb.append("serviceName={").append(this.getServiceName()).append("} ");
        sb.append("policyRepository={");
        if (this.policyRepository != null) {
            this.policyRepository.toString(sb);
        }
        sb.append("} ");
        sb.append("tagPolicyRepository={");
        if (this.tagPolicyRepository != null) {
            this.tagPolicyRepository.toString(sb);
        }
        sb.append("} ");
        sb.append(this.lock.toString());
        sb.append("}");
        return sb;
    }

    public List<RangerPolicy> getResourcePolicies(String zoneName) {
        RangerPolicyRepository zoneResourceRepository = this.zonePolicyRepositories.get(zoneName);
        return zoneResourceRepository == null ? Collections.emptyList() : zoneResourceRepository.getPolicies();
    }

    RangerSecurityZoneMatcher getZoneMatcher() {
        return this.zoneMatcher;
    }

    public PolicyEngine(ServicePolicies servicePolicies, RangerPluginContext pluginContext, RangerRoles roles, boolean isUseReadWriteLock) {
        List<RangerContextEnricher> tmpList;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> PolicyEngine(, " + servicePolicies + ", " + pluginContext + ")");
        }
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_INIT_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_INIT_LOG, "RangerPolicyEngine.init(hashCode=" + Integer.toHexString(System.identityHashCode(this)) + ")");
            long freeMemory = Runtime.getRuntime().freeMemory();
            long totalMemory = Runtime.getRuntime().totalMemory();
            PERF_POLICYENGINE_INIT_LOG.debug("In-Use memory: " + (totalMemory - freeMemory) + ", Free memory:" + freeMemory);
        }
        this.normalizeServiceDefs(servicePolicies);
        pluginContext.cleanResourceMatchers();
        this.pluginContext = pluginContext;
        this.lock = new RangerReadWriteLock(isUseReadWriteLock);
        this.zoneMatcher = new RangerSecurityZoneMatcher(servicePolicies.getSecurityZones(), servicePolicies.getServiceDef(), pluginContext);
        Boolean hasPolicyDeltas = RangerPolicyDeltaUtil.hasPolicyDeltas(servicePolicies);
        if (hasPolicyDeltas != null) {
            if (hasPolicyDeltas.equals(Boolean.TRUE)) {
                LOG.info("Policy engine will" + (isUseReadWriteLock ? " " : " not ") + "perform in place update while processing policy-deltas.");
            } else {
                LOG.info("Policy engine will" + (isUseReadWriteLock ? " " : " not ") + "perform in place update while processing policies.");
            }
        }
        RangerAuthContext authContext = new RangerAuthContext(pluginContext.getAuthContext(), this.zoneMatcher, roles);
        this.pluginContext.setAuthContext(authContext);
        RangerPolicyEngineOptions options = pluginContext.getConfig().getPolicyEngineOptions();
        if (StringUtils.isBlank((CharSequence)options.evaluatorType) || StringUtils.equalsIgnoreCase((CharSequence)options.evaluatorType, (CharSequence)"auto")) {
            options.evaluatorType = "optimized";
        }
        this.policyRepository = new RangerPolicyRepository(servicePolicies, this.pluginContext);
        this.serviceDefHelper = new RangerServiceDefHelper(this.policyRepository.getServiceDef(), false);
        ServicePolicies.TagPolicies tagPolicies = servicePolicies.getTagPolicies();
        if (!options.disableTagPolicyEvaluation && tagPolicies != null && !StringUtils.isEmpty((CharSequence)tagPolicies.getServiceName()) && tagPolicies.getServiceDef() != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("PolicyEngine : Building tag-policy-repository for tag-service " + tagPolicies.getServiceName());
            }
            this.tagPolicyRepository = new RangerPolicyRepository(tagPolicies, this.pluginContext, servicePolicies.getServiceDef(), servicePolicies.getServiceName());
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("PolicyEngine : No tag-policy-repository for service " + servicePolicies.getServiceName());
            }
            this.tagPolicyRepository = null;
        }
        List<RangerContextEnricher> tagContextEnrichers = this.tagPolicyRepository == null ? null : this.tagPolicyRepository.getContextEnrichers();
        List<RangerContextEnricher> resourceContextEnrichers = this.policyRepository.getContextEnrichers();
        if (CollectionUtils.isEmpty(tagContextEnrichers)) {
            tmpList = resourceContextEnrichers;
        } else if (CollectionUtils.isEmpty(resourceContextEnrichers)) {
            tmpList = tagContextEnrichers;
        } else {
            tmpList = new ArrayList<RangerContextEnricher>(tagContextEnrichers);
            tmpList.addAll(resourceContextEnrichers);
        }
        this.allContextEnrichers = tmpList;
        if (MapUtils.isNotEmpty(servicePolicies.getSecurityZones())) {
            for (Map.Entry entry : servicePolicies.getSecurityZones().entrySet()) {
                RangerPolicyRepository policyRepository = new RangerPolicyRepository(servicePolicies, this.pluginContext, (String)entry.getKey());
                this.zonePolicyRepositories.put((String)entry.getKey(), policyRepository);
            }
        }
        for (RangerServiceDef.RangerResourceDef rangerResourceDef : this.getServiceDef().getResources()) {
            Map<String, String> matchOptions = rangerResourceDef.getMatcherOptions();
            if (!RangerAbstractResourceMatcher.getOptionReplaceTokens(matchOptions)) continue;
            String delimiterPrefix = RangerAbstractResourceMatcher.getOptionDelimiterPrefix(matchOptions);
            char delimiterStart = RangerAbstractResourceMatcher.getOptionDelimiterStart(matchOptions);
            char delimiterEnd = RangerAbstractResourceMatcher.getOptionDelimiterEnd(matchOptions);
            char escapeChar = RangerAbstractResourceMatcher.getOptionDelimiterEscape(matchOptions);
            StringTokenReplacer tokenReplacer = new StringTokenReplacer(delimiterStart, delimiterEnd, escapeChar, delimiterPrefix);
            this.tokenReplacers.put(rangerResourceDef.getName(), tokenReplacer);
        }
        RangerPerfTracer.log(perf);
        if (PERF_POLICYENGINE_INIT_LOG.isDebugEnabled()) {
            long freeMemory = Runtime.getRuntime().freeMemory();
            long totalMemory = Runtime.getRuntime().totalMemory();
            PERF_POLICYENGINE_INIT_LOG.debug("In-Use memory: " + (totalMemory - freeMemory) + ", Free memory:" + freeMemory);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== PolicyEngine()");
        }
    }

    public PolicyEngine cloneWithDelta(ServicePolicies servicePolicies) {
        PolicyEngine ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> cloneWithDelta(" + Arrays.toString(servicePolicies.getPolicyDeltas().toArray()) + ", " + servicePolicies.getPolicyVersion() + ")");
        }
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_INIT_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_INIT_LOG, "RangerPolicyEngine.cloneWithDelta()");
        }
        try (RangerReadWriteLock.RangerLock writeLock = this.getWriteLock();){
            RangerServiceDef serviceDef;
            if (LOG.isDebugEnabled() && writeLock.isLockingEnabled()) {
                LOG.debug("Acquired lock - " + writeLock);
            }
            String serviceType = (serviceDef = this.getServiceDef()) != null ? serviceDef.getName() : "";
            boolean isValidDeltas = false;
            if (CollectionUtils.isNotEmpty(servicePolicies.getPolicyDeltas()) || MapUtils.isNotEmpty(servicePolicies.getSecurityZones())) {
                boolean bl = isValidDeltas = CollectionUtils.isEmpty(servicePolicies.getPolicyDeltas()) || RangerPolicyDeltaUtil.isValidDeltas(servicePolicies.getPolicyDeltas(), serviceType);
                if (isValidDeltas && MapUtils.isNotEmpty(servicePolicies.getSecurityZones())) {
                    for (Map.Entry<String, ServicePolicies.SecurityZoneInfo> entry : servicePolicies.getSecurityZones().entrySet()) {
                        if (RangerPolicyDeltaUtil.isValidDeltas(entry.getValue().getPolicyDeltas(), serviceType)) continue;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Invalid policy-deltas for security zone:[" + entry.getKey() + "]");
                        }
                        isValidDeltas = false;
                        break;
                    }
                }
            }
            if (isValidDeltas) {
                if (writeLock.isLockingEnabled()) {
                    this.updatePolicyEngine(servicePolicies);
                    ret = this;
                } else {
                    ret = new PolicyEngine(this, servicePolicies);
                }
            } else {
                ret = null;
            }
        }
        RangerPerfTracer.log(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== cloneWithDelta(" + Arrays.toString(servicePolicies.getPolicyDeltas().toArray()) + ", " + servicePolicies.getPolicyVersion() + ")");
        }
        return ret;
    }

    public RangerPolicyRepository getRepositoryForMatchedZone(RangerPolicy policy) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> PolicyEngine.getRepositoryForMatchedZone(" + policy + ")");
        }
        String zoneName = policy.getZoneName();
        RangerPolicyRepository ret = this.getRepositoryForZone(zoneName);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== PolicyEngine.getRepositoryForMatchedZone(" + policy + ")");
        }
        return ret;
    }

    public Set<String> getMatchedZonesForResourceAndChildren(Map<String, ?> resource) {
        Set<String> ret = this.zoneMatcher.getZonesForResourceAndChildren(resource);
        if (LOG.isDebugEnabled()) {
            LOG.debug("getMatchedZonesForResourceAndChildren(resource={}): ret={}", resource, ret);
        }
        return ret;
    }

    public Set<String> getMatchedZonesForResourceAndChildren(RangerAccessResource resource) {
        Set<String> ret = this.zoneMatcher.getZonesForResourceAndChildren(resource);
        if (LOG.isDebugEnabled()) {
            LOG.debug("getMatchedZonesForResourceAndChildren(resource={}): ret={}", (Object)resource, ret);
        }
        return ret;
    }

    public String getUniquelyMatchedZoneName(Map<String, ?> resourceAsMap) {
        String ret;
        Set<String> matchedZones = this.zoneMatcher.getZonesForResourceAndChildren(resourceAsMap);
        String string = ret = matchedZones != null && matchedZones.size() == 1 ? matchedZones.iterator().next() : null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("getUniquelyMatchedZoneName(" + resourceAsMap + "): matchedZones=" + matchedZones + ", ret=" + ret);
        }
        return ret;
    }

    public RangerPolicyRepository getRepositoryForZone(String zoneName) {
        RangerPolicyRepository ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug("zoneName:[" + zoneName + "]");
        }
        if ((ret = StringUtils.isNotEmpty((CharSequence)zoneName) ? this.getZonePolicyRepositories().get(zoneName) : this.getPolicyRepository()) == null) {
            LOG.error("policyRepository for zoneName:[" + zoneName + "],  serviceName:[" + this.getServiceName() + "], policyVersion:[" + this.getPolicyVersion() + "] is null!! ERROR!");
        }
        return ret;
    }

    public boolean hasTagPolicies(RangerPolicyRepository tagPolicyRepository) {
        return tagPolicyRepository != null && CollectionUtils.isNotEmpty(tagPolicyRepository.getPolicies());
    }

    public boolean hasResourcePolicies(RangerPolicyRepository policyRepository) {
        return policyRepository != null && CollectionUtils.isNotEmpty(policyRepository.getPolicies());
    }

    public boolean isResourceZoneAssociatedWithTagService(String resourceZoneName) {
        boolean ret;
        if (StringUtils.isNotEmpty((CharSequence)resourceZoneName) && this.tagPolicyRepository != null && this.zoneMatcher.hasTagService(resourceZoneName)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Accessed resource is in a zone:[" + resourceZoneName + "] which is associated with the tag-service:[" + this.tagPolicyRepository.getServiceName() + "]");
            }
            ret = true;
        } else {
            ret = false;
        }
        return ret;
    }

    public void preCleanup(boolean isForced) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> PolicyEngine.preCleanup(isForced=" + isForced + ")");
        }
        if (this.policyRepository != null) {
            this.policyRepository.preCleanup(isForced);
        }
        if (this.tagPolicyRepository != null) {
            this.tagPolicyRepository.preCleanup(isForced);
        }
        if (MapUtils.isNotEmpty(this.zonePolicyRepositories)) {
            for (Map.Entry<String, RangerPolicyRepository> entry : this.zonePolicyRepositories.entrySet()) {
                entry.getValue().preCleanup(isForced);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== PolicyEngine.preCleanup(isForced=" + isForced + ")");
        }
    }

    private void normalizeServiceDefs(ServicePolicies servicePolicies) {
        RangerServiceDef serviceDef = servicePolicies.getServiceDef();
        if (serviceDef != null) {
            RangerServiceDef tagServiceDef;
            ServiceDefUtil.normalize(serviceDef);
            RangerServiceDef rangerServiceDef = tagServiceDef = servicePolicies.getTagPolicies() != null ? servicePolicies.getTagPolicies().getServiceDef() : null;
            if (tagServiceDef != null) {
                ServiceDefUtil.normalizeAccessTypeDefs(ServiceDefUtil.normalize(tagServiceDef), serviceDef.getName());
            }
        }
    }

    private PolicyEngine(PolicyEngine other, ServicePolicies servicePolicies) {
        List<RangerContextEnricher> tmpList;
        List<RangerContextEnricher> resourceContextEnrichers;
        this.useForwardedIPAddress = other.useForwardedIPAddress;
        this.trustedProxyAddresses = other.trustedProxyAddresses;
        this.serviceDefHelper = other.serviceDefHelper;
        this.pluginContext = other.pluginContext;
        this.lock = other.lock;
        this.zoneMatcher = new RangerSecurityZoneMatcher(servicePolicies.getSecurityZones(), servicePolicies.getServiceDef(), this.pluginContext);
        long policyVersion = servicePolicies.getPolicyVersion() != null ? servicePolicies.getPolicyVersion() : -1L;
        ArrayList<RangerPolicyDelta> defaultZoneDeltas = new ArrayList<RangerPolicyDelta>();
        ArrayList<RangerPolicyDelta> defaultZoneDeltasForTagPolicies = new ArrayList<RangerPolicyDelta>();
        this.getDeltasSortedByZones(other, servicePolicies, defaultZoneDeltas, defaultZoneDeltasForTagPolicies);
        this.policyRepository = other.policyRepository != null && CollectionUtils.isNotEmpty(defaultZoneDeltas) ? new RangerPolicyRepository(other.policyRepository, defaultZoneDeltas, policyVersion) : this.shareWith(other.policyRepository);
        if (MapUtils.isEmpty(this.zonePolicyRepositories) && MapUtils.isNotEmpty(other.zonePolicyRepositories)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Existing engine contains some zonePolicyRepositories and new engine contains no zonePolicyRepositories");
            }
            for (Map.Entry<String, RangerPolicyRepository> entry : other.zonePolicyRepositories.entrySet()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Copying over zoneRepository for zone :[" + entry.getKey() + "]");
                }
                RangerPolicyRepository otherZonePolicyRepository = entry.getValue();
                RangerPolicyRepository zonePolicyRepository = this.shareWith(otherZonePolicyRepository);
                this.zonePolicyRepositories.put(entry.getKey(), zonePolicyRepository);
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Existing engine contains no zonePolicyRepositories or new engine contains some zonePolicyRepositories");
            LOG.debug("Not copying zoneRepositories from existing engine, as they are already copied or modified");
        }
        if (servicePolicies.getTagPolicies() != null && CollectionUtils.isNotEmpty(defaultZoneDeltasForTagPolicies)) {
            if (other.tagPolicyRepository == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Current policy-engine does not have any tagPolicyRepository");
                }
                ArrayList<RangerPolicy> tagPolicies = new ArrayList<RangerPolicy>();
                for (RangerPolicyDelta delta : defaultZoneDeltasForTagPolicies) {
                    if (delta.getChangeType() == 0) {
                        tagPolicies.add(delta.getPolicy());
                        continue;
                    }
                    LOG.warn("Expected changeType:[0], found policy-change-delta:[" + delta + "]");
                }
                servicePolicies.getTagPolicies().setPolicies(tagPolicies);
                this.tagPolicyRepository = new RangerPolicyRepository(servicePolicies.getTagPolicies(), this.pluginContext, servicePolicies.getServiceDef(), servicePolicies.getServiceName());
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Current policy-engine has a tagPolicyRepository");
                }
                this.tagPolicyRepository = new RangerPolicyRepository(other.tagPolicyRepository, defaultZoneDeltasForTagPolicies, policyVersion);
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Either no associated tag repository or no changes to tag policies");
            }
            this.tagPolicyRepository = this.shareWith(other.tagPolicyRepository);
        }
        List<RangerContextEnricher> list = this.tagPolicyRepository == null ? null : this.tagPolicyRepository.getContextEnrichers();
        List<RangerContextEnricher> list2 = resourceContextEnrichers = this.policyRepository == null ? null : this.policyRepository.getContextEnrichers();
        if (CollectionUtils.isEmpty(list)) {
            tmpList = resourceContextEnrichers;
        } else if (CollectionUtils.isEmpty(resourceContextEnrichers)) {
            tmpList = list;
        } else {
            tmpList = new ArrayList<RangerContextEnricher>(list);
            tmpList.addAll(resourceContextEnrichers);
        }
        this.allContextEnrichers = tmpList;
        this.reorderPolicyEvaluators();
    }

    private RangerPolicyRepository shareWith(RangerPolicyRepository other) {
        if (other != null) {
            other.setShared();
        }
        return other;
    }

    private void reorderPolicyEvaluators() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> reorderEvaluators()");
        }
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_REBALANCE_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_REBALANCE_LOG, "RangerPolicyEngine.reorderEvaluators()");
        }
        if (this.tagPolicyRepository != null) {
            this.tagPolicyRepository.reorderPolicyEvaluators();
        }
        if (this.policyRepository != null) {
            this.policyRepository.reorderPolicyEvaluators();
        }
        RangerPerfTracer.log(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== reorderEvaluators()");
        }
    }

    private void cleanup() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> PolicyEngine.cleanup()");
        }
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICYENGINE_INIT_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICYENGINE_INIT_LOG, "RangerPolicyEngine.cleanUp(hashCode=" + Integer.toHexString(System.identityHashCode(this)) + ")");
        }
        this.preCleanup(false);
        if (this.policyRepository != null) {
            this.policyRepository.cleanup();
        }
        if (this.tagPolicyRepository != null) {
            this.tagPolicyRepository.cleanup();
        }
        if (MapUtils.isNotEmpty(this.zonePolicyRepositories)) {
            for (Map.Entry<String, RangerPolicyRepository> entry : this.zonePolicyRepositories.entrySet()) {
                entry.getValue().cleanup();
            }
        }
        RangerPerfTracer.log(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== PolicyEngine.cleanup()");
        }
    }

    void updatePolicyEngine(ServicePolicies servicePolicies) {
        ArrayList<RangerPolicyDelta> defaultZoneDeltas = new ArrayList<RangerPolicyDelta>();
        ArrayList<RangerPolicyDelta> defaultZoneDeltasForTagPolicies = new ArrayList<RangerPolicyDelta>();
        this.getDeltasSortedByZones(this, servicePolicies, defaultZoneDeltas, defaultZoneDeltasForTagPolicies);
        if (this.policyRepository != null && CollectionUtils.isNotEmpty(defaultZoneDeltas)) {
            this.policyRepository.reinit(defaultZoneDeltas);
        }
        if (servicePolicies.getTagPolicies() != null && CollectionUtils.isNotEmpty(defaultZoneDeltasForTagPolicies)) {
            if (this.tagPolicyRepository != null) {
                this.tagPolicyRepository.reinit(defaultZoneDeltasForTagPolicies);
            } else {
                LOG.error("No previous tagPolicyRepository to update! Should not have come here!!");
            }
        }
        this.reorderPolicyEvaluators();
    }

    private void getDeltasSortedByZones(PolicyEngine current, ServicePolicies servicePolicies, List<RangerPolicyDelta> defaultZoneDeltas, List<RangerPolicyDelta> defaultZoneDeltasForTagPolicies) {
        long policyVersion;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getDeltasSortedByZones()");
        }
        long l = policyVersion = servicePolicies.getPolicyVersion() != null ? servicePolicies.getPolicyVersion() : -1L;
        if (CollectionUtils.isNotEmpty(defaultZoneDeltas)) {
            LOG.warn("Emptying out defaultZoneDeltas!");
            defaultZoneDeltas.clear();
        }
        if (CollectionUtils.isNotEmpty(defaultZoneDeltasForTagPolicies)) {
            LOG.warn("Emptying out defaultZoneDeltasForTagPolicies!");
            defaultZoneDeltasForTagPolicies.clear();
        }
        if (MapUtils.isNotEmpty(servicePolicies.getSecurityZones())) {
            String zoneName;
            HashMap zoneDeltasMap = new HashMap();
            for (Map.Entry entry : servicePolicies.getSecurityZones().entrySet()) {
                zoneName = (String)entry.getKey();
                List<RangerPolicyDelta> deltas = ((ServicePolicies.SecurityZoneInfo)entry.getValue()).getPolicyDeltas();
                List<RangerPolicyDelta> zoneDeltas = new ArrayList();
                if (!StringUtils.isNotEmpty((CharSequence)zoneName)) continue;
                zoneDeltasMap.put(zoneName, zoneDeltas);
                for (RangerPolicyDelta delta : deltas) {
                    zoneDeltas = (List)zoneDeltasMap.get(zoneName);
                    zoneDeltas.add(delta);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Security zones found in the service-policies:[" + zoneDeltasMap.keySet() + "]");
            }
            for (Map.Entry entry : zoneDeltasMap.entrySet()) {
                RangerPolicyRepository policyRepository;
                zoneName = (String)entry.getKey();
                List zoneDeltas = (List)entry.getValue();
                RangerPolicyRepository otherRepository = current.zonePolicyRepositories.get(zoneName);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("zoneName:[" + zoneName + "], zoneDeltas:[" + Arrays.toString(zoneDeltas.toArray()) + "], doesOtherRepositoryExist:[" + (otherRepository != null) + "]");
                }
                if (CollectionUtils.isNotEmpty((Collection)zoneDeltas)) {
                    if (otherRepository == null) {
                        ArrayList<RangerPolicy> policies = new ArrayList<RangerPolicy>();
                        for (RangerPolicyDelta delta : zoneDeltas) {
                            if (delta.getChangeType() == 0) {
                                policies.add(delta.getPolicy());
                                continue;
                            }
                            LOG.warn("Expected changeType:[0], found policy-change-delta:[" + delta + "]");
                        }
                        servicePolicies.getSecurityZones().get(zoneName).setPolicies(policies);
                        policyRepository = new RangerPolicyRepository(servicePolicies, current.pluginContext, zoneName);
                    } else {
                        policyRepository = new RangerPolicyRepository(otherRepository, zoneDeltas, policyVersion);
                    }
                } else {
                    policyRepository = this.shareWith(otherRepository);
                }
                this.zonePolicyRepositories.put(zoneName, policyRepository);
            }
        }
        List<RangerPolicyDelta> unzonedDeltas = servicePolicies.getPolicyDeltas();
        if (LOG.isDebugEnabled()) {
            LOG.debug("ServicePolicies.policyDeltas:[" + Arrays.toString(servicePolicies.getPolicyDeltas().toArray()) + "]");
        }
        for (RangerPolicyDelta rangerPolicyDelta : unzonedDeltas) {
            if (servicePolicies.getServiceDef().getName().equals(rangerPolicyDelta.getServiceType())) {
                defaultZoneDeltas.add(rangerPolicyDelta);
                continue;
            }
            defaultZoneDeltasForTagPolicies.add(rangerPolicyDelta);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("defaultZoneDeltas:[" + Arrays.toString(defaultZoneDeltas.toArray()) + "]");
            LOG.debug("defaultZoneDeltasForTagPolicies:[" + Arrays.toString(defaultZoneDeltasForTagPolicies.toArray()) + "]");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getDeltasSortedByZones()");
        }
    }
}

