/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.store;

import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ranger.plugin.model.RangerServiceResource;
import org.apache.ranger.plugin.model.RangerTag;
import org.apache.ranger.plugin.model.RangerTagDef;
import org.apache.ranger.plugin.model.RangerTagResourceMap;
import org.apache.ranger.plugin.store.RangerServiceResourceSignature;
import org.apache.ranger.plugin.store.TagStore;

public class TagValidator {
    private TagStore tagStore;

    public void setTagStore(TagStore tagStore) {
        this.tagStore = tagStore;
    }

    public RangerTagDef preCreateTagDef(RangerTagDef tagDef, boolean updateIfExists) throws Exception {
        String name = tagDef.getName();
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new Exception("TagDef has no name");
        }
        RangerTagDef existing = this.tagStore.getTagDefByName(name);
        return existing;
    }

    public RangerTag preCreateTag(RangerTag tag) throws Exception {
        if (StringUtils.isBlank((CharSequence)tag.getType())) {
            throw new Exception("Tag has no type");
        }
        RangerTag ret = null;
        String guid = tag.getGuid();
        if (!StringUtils.isBlank((CharSequence)guid)) {
            ret = this.tagStore.getTagByGuid(guid);
        }
        return ret;
    }

    public void preUpdateTag(Long id, RangerTag tag) throws Exception {
        if (StringUtils.isBlank((CharSequence)tag.getType())) {
            throw new Exception("Tag has no type");
        }
        if (id == null) {
            throw new Exception("Invalid/null id");
        }
        RangerTag existing = this.tagStore.getTag(id);
        if (existing == null) {
            throw new Exception("Attempt to update nonexistant tag, id=" + id);
        }
        if (!StringUtils.equals((CharSequence)tag.getType(), (CharSequence)existing.getType())) {
            throw new Exception("Attempt to change the tag-type");
        }
        tag.setId(existing.getId());
        tag.setGuid(existing.getGuid());
    }

    public void preUpdateTagByGuid(String guid, RangerTag tag) throws Exception {
        if (StringUtils.isBlank((CharSequence)tag.getType())) {
            throw new Exception("Tag has no type");
        }
        RangerTag existing = this.tagStore.getTagByGuid(guid);
        if (existing == null) {
            throw new Exception("Attempt to update nonexistent tag, guid=" + guid);
        }
        if (!StringUtils.equals((CharSequence)tag.getType(), (CharSequence)existing.getType())) {
            throw new Exception("Attempt to change the tag-type");
        }
        tag.setId(existing.getId());
        tag.setGuid(existing.getGuid());
    }

    public RangerTag preDeleteTag(Long id) throws Exception {
        if (id == null) {
            throw new Exception("Invalid/null id");
        }
        RangerTag existing = this.tagStore.getTag(id);
        if (existing == null) {
            throw new Exception("Attempt to delete nonexistent tag, id=" + id);
        }
        List<RangerTagResourceMap> associations = this.tagStore.getTagResourceMapsForTagId(existing.getId());
        if (CollectionUtils.isNotEmpty(associations)) {
            throw new Exception("Attempt to delete tag which is associated with a service-resource, id=" + id);
        }
        return existing;
    }

    public RangerTag preDeleteTagByGuid(String guid) throws Exception {
        RangerTag exiting = this.tagStore.getTagByGuid(guid);
        if (exiting == null) {
            throw new Exception("Attempt to delete nonexistent tag, guid=" + guid);
        }
        List<RangerTagResourceMap> associations = this.tagStore.getTagResourceMapsForTagId(exiting.getId());
        if (CollectionUtils.isNotEmpty(associations)) {
            throw new Exception("Attempt to delete tag which is associated with a service-resource, guid=" + guid);
        }
        return exiting;
    }

    public RangerServiceResource preCreateServiceResource(RangerServiceResource resource) throws Exception {
        RangerServiceResource ret = null;
        if (StringUtils.isBlank((CharSequence)resource.getServiceName()) || MapUtils.isEmpty(resource.getResourceElements())) {
            throw new Exception("No serviceName or resource in RangerServiceResource");
        }
        String guid = resource.getGuid();
        if (!StringUtils.isBlank((CharSequence)guid)) {
            ret = this.tagStore.getServiceResourceByGuid(guid);
        }
        if (ret == null) {
            RangerServiceResourceSignature serializer = new RangerServiceResourceSignature(resource);
            resource.setResourceSignature(serializer.getSignature());
            ret = this.tagStore.getServiceResourceByServiceAndResourceSignature(resource.getServiceName(), resource.getResourceSignature());
        }
        return ret;
    }

    public void preUpdateServiceResource(Long id, RangerServiceResource resource) throws Exception {
        if (StringUtils.isBlank((CharSequence)resource.getServiceName()) || MapUtils.isEmpty(resource.getResourceElements())) {
            throw new Exception("No serviceName or resource in RangerServiceResource");
        }
        if (id == null) {
            throw new Exception("Invalid/null id");
        }
        RangerServiceResource existing = this.tagStore.getServiceResource(id);
        if (existing == null) {
            throw new Exception("Attempt to update nonexistent resource, id=" + id);
        }
        if (!StringUtils.equals((CharSequence)existing.getServiceName(), (CharSequence)resource.getServiceName())) {
            throw new Exception("Attempt to change service-name for existing service-resource");
        }
        RangerServiceResourceSignature serializer = new RangerServiceResourceSignature(resource);
        resource.setId(existing.getId());
        resource.setGuid(existing.getGuid());
        resource.setResourceSignature(serializer.getSignature());
    }

    public void preUpdateServiceResourceByGuid(String guid, RangerServiceResource resource) throws Exception {
        if (StringUtils.isBlank((CharSequence)resource.getServiceName()) || MapUtils.isEmpty(resource.getResourceElements())) {
            throw new Exception("No serviceName or resource in RangerServiceResource");
        }
        RangerServiceResource existing = this.tagStore.getServiceResourceByGuid(guid);
        if (existing == null) {
            throw new Exception("Attempt to update nonexistent resource, guid=" + guid);
        }
        if (!StringUtils.equals((CharSequence)existing.getServiceName(), (CharSequence)resource.getServiceName())) {
            throw new Exception("Attempt to change service-name for existing service-resource");
        }
        RangerServiceResourceSignature serializer = new RangerServiceResourceSignature(resource);
        resource.setId(existing.getId());
        resource.setGuid(guid);
        resource.setResourceSignature(serializer.getSignature());
    }

    public RangerServiceResource preDeleteServiceResource(Long id) throws Exception {
        RangerServiceResource existing = this.tagStore.getServiceResource(id);
        if (existing == null) {
            throw new Exception("Attempt to delete nonexistent resource, id=" + id);
        }
        List<RangerTagResourceMap> associations = this.tagStore.getTagResourceMapsForResourceId(existing.getId());
        if (CollectionUtils.isNotEmpty(associations)) {
            throw new Exception("Attempt to delete serviceResource which is associated with a tag, id=" + id);
        }
        return existing;
    }

    public RangerServiceResource preDeleteServiceResourceByGuid(String guid, boolean deleteReferences) throws Exception {
        RangerServiceResource existing = this.tagStore.getServiceResourceByGuid(guid);
        if (existing == null) {
            throw new Exception("Attempt to delete nonexistent resource, guid=" + guid);
        }
        List<RangerTagResourceMap> associations = this.tagStore.getTagResourceMapsForResourceId(existing.getId());
        if (CollectionUtils.isNotEmpty(associations) && !deleteReferences) {
            throw new Exception("Attempt to delete serviceResource which is associated with a tag, guid=" + guid);
        }
        return existing;
    }

    public RangerTagResourceMap preCreateTagResourceMap(String tagGuid, String resourceGuid) throws Exception {
        if (StringUtils.isBlank((CharSequence)resourceGuid) || StringUtils.isBlank((CharSequence)tagGuid)) {
            throw new Exception("Both resourceGuid and resourceId need to be non-empty");
        }
        RangerTagResourceMap existing = this.tagStore.getTagResourceMapForTagAndResourceGuid(tagGuid, resourceGuid);
        if (existing != null) {
            throw new Exception("Attempt to create existing association between resourceId=" + resourceGuid + " and tagId=" + tagGuid);
        }
        RangerServiceResource existingServiceResource = this.tagStore.getServiceResourceByGuid(resourceGuid);
        if (existingServiceResource == null) {
            throw new Exception("No resource found for guid=" + resourceGuid);
        }
        RangerTag existingTag = this.tagStore.getTagByGuid(tagGuid);
        if (existingTag == null) {
            throw new Exception("No tag found for guid=" + tagGuid);
        }
        RangerTagResourceMap newTagResourceMap = new RangerTagResourceMap();
        newTagResourceMap.setResourceId(existingServiceResource.getId());
        newTagResourceMap.setTagId(existingTag.getId());
        return newTagResourceMap;
    }

    public RangerTagResourceMap preCreateTagResourceMapByIds(Long tagId, Long resourceId) throws Exception {
        RangerTagResourceMap existing = this.tagStore.getTagResourceMapForTagAndResourceId(tagId, resourceId);
        if (existing != null) {
            throw new Exception("Attempt to create existing association between resourceId=" + resourceId + " and tagId=" + tagId);
        }
        RangerServiceResource existingServiceResource = this.tagStore.getServiceResource(resourceId);
        if (existingServiceResource == null) {
            throw new Exception("No resource found for id=" + resourceId);
        }
        RangerTag existingTag = this.tagStore.getTag(tagId);
        if (existingTag == null) {
            throw new Exception("No tag found for id=" + tagId);
        }
        RangerTagResourceMap newTagResourceMap = new RangerTagResourceMap();
        newTagResourceMap.setResourceId(resourceId);
        newTagResourceMap.setTagId(tagId);
        return newTagResourceMap;
    }

    public RangerTagResourceMap preDeleteTagResourceMap(Long id) throws Exception {
        RangerTagResourceMap existing = this.tagStore.getTagResourceMap(id);
        if (existing == null) {
            throw new Exception("Attempt to delete nonexistent tagResourceMap(id=" + id + ")");
        }
        return existing;
    }

    public RangerTagResourceMap preDeleteTagResourceMapByGuid(String guid) throws Exception {
        RangerTagResourceMap existing = this.tagStore.getTagResourceMapByGuid(guid);
        if (existing == null) {
            throw new Exception("Attempt to delete nonexistent tagResourceMap(guid=" + guid + ")");
        }
        return existing;
    }

    public RangerTagResourceMap preDeleteTagResourceMap(String tagGuid, String resourceGuid) throws Exception {
        RangerTagResourceMap existing = this.tagStore.getTagResourceMapForTagAndResourceGuid(tagGuid, resourceGuid);
        if (existing == null) {
            throw new Exception("Attempt to delete nonexistent association between resourceId=" + resourceGuid + " and tagId=" + tagGuid);
        }
        return existing;
    }

    public RangerTagResourceMap preDeleteTagResourceMapByIds(Long tagId, Long resourceId) throws Exception {
        RangerTagResourceMap existing = this.tagStore.getTagResourceMapForTagAndResourceId(tagId, resourceId);
        if (existing == null) {
            throw new Exception("Attempt to delete nonexistent association between resourceId=" + resourceId + " and tagId=" + tagId);
        }
        return existing;
    }
}

