/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.presto.authorizer;

import io.prestosql.spi.connector.CatalogSchemaName;
import io.prestosql.spi.connector.CatalogSchemaRoutineName;
import io.prestosql.spi.connector.CatalogSchemaTableName;
import io.prestosql.spi.connector.ColumnMetadata;
import io.prestosql.spi.connector.SchemaTableName;
import io.prestosql.spi.security.AccessDeniedException;
import io.prestosql.spi.security.Identity;
import io.prestosql.spi.security.PrestoPrincipal;
import io.prestosql.spi.security.Privilege;
import io.prestosql.spi.security.SystemAccessControl;
import io.prestosql.spi.security.SystemSecurityContext;
import io.prestosql.spi.security.ViewExpression;
import io.prestosql.spi.type.Type;
import java.io.IOException;
import java.net.URL;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.ranger.authorization.presto.authorizer.PrestoAccessType;
import org.apache.ranger.authorization.presto.authorizer.RangerPrestoAccessRequest;
import org.apache.ranger.authorization.presto.authorizer.RangerPrestoResource;
import org.apache.ranger.plugin.audit.RangerDefaultAuditHandler;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerAccessResultProcessor;
import org.apache.ranger.plugin.service.RangerBasePlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerSystemAccessControl
implements SystemAccessControl {
    private static Logger LOG = LoggerFactory.getLogger(RangerSystemAccessControl.class);
    public static final String RANGER_CONFIG_KEYTAB = "ranger.keytab";
    public static final String RANGER_CONFIG_PRINCIPAL = "ranger.principal";
    public static final String RANGER_CONFIG_USE_UGI = "ranger.use_ugi";
    public static final String RANGER_CONFIG_HADOOP_CONFIG = "ranger.hadoop_config";
    public static final String RANGER_PRESTO_DEFAULT_HADOOP_CONF = "presto-ranger-site.xml";
    public static final String RANGER_PRESTO_SERVICETYPE = "presto";
    public static final String RANGER_PRESTO_APPID = "presto";
    private final RangerBasePlugin rangerPlugin;
    private boolean useUgi = false;

    public RangerSystemAccessControl(Map<String, String> config) {
        URL url;
        Configuration hadoopConf = new Configuration();
        if (config.get(RANGER_CONFIG_HADOOP_CONFIG) != null) {
            url = hadoopConf.getResource(config.get(RANGER_CONFIG_HADOOP_CONFIG));
            if (url == null) {
                LOG.warn("Hadoop config " + config.get(RANGER_CONFIG_HADOOP_CONFIG) + " not found");
            } else {
                hadoopConf.addResource(url);
            }
        } else {
            url = hadoopConf.getResource(RANGER_PRESTO_DEFAULT_HADOOP_CONF);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Trying to load Hadoop config from " + url + " (can be null)");
            }
            if (url != null) {
                hadoopConf.addResource(url);
            }
        }
        UserGroupInformation.setConfiguration((Configuration)hadoopConf);
        if (config.get(RANGER_CONFIG_KEYTAB) != null && config.get(RANGER_CONFIG_PRINCIPAL) != null) {
            String keytab = config.get(RANGER_CONFIG_KEYTAB);
            String principal = config.get(RANGER_CONFIG_PRINCIPAL);
            LOG.info("Performing kerberos login with principal " + principal + " and keytab " + keytab);
            try {
                UserGroupInformation.loginUserFromKeytab((String)principal, (String)keytab);
            }
            catch (IOException ioe) {
                LOG.error("Kerberos login failed", (Throwable)ioe);
                throw new RuntimeException(ioe);
            }
        }
        if (config.getOrDefault(RANGER_CONFIG_USE_UGI, "false").equalsIgnoreCase("true")) {
            this.useUgi = true;
        }
        this.rangerPlugin = new RangerBasePlugin("presto", "presto");
        this.rangerPlugin.init();
        this.rangerPlugin.setResultProcessor((RangerAccessResultProcessor)new RangerDefaultAuditHandler());
    }

    private RangerAccessResult getDataMaskResult(RangerPrestoAccessRequest request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getDataMaskResult(request=" + (Object)((Object)request) + ")");
        }
        RangerAccessResult ret = this.rangerPlugin.evalDataMaskPolicies((RangerAccessRequest)request, null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getDataMaskResult(request=" + (Object)((Object)request) + "): ret=" + ret);
        }
        return ret;
    }

    private RangerAccessResult getRowFilterResult(RangerPrestoAccessRequest request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> getRowFilterResult(request=" + (Object)((Object)request) + ")");
        }
        RangerAccessResult ret = this.rangerPlugin.evalRowFilterPolicies((RangerAccessRequest)request, null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== getRowFilterResult(request=" + (Object)((Object)request) + "): ret=" + ret);
        }
        return ret;
    }

    private boolean isDataMaskEnabled(RangerAccessResult result) {
        return result != null && result.isMaskEnabled();
    }

    private boolean isRowFilterEnabled(RangerAccessResult result) {
        return result != null && result.isRowFilterEnabled();
    }

    public Optional<ViewExpression> getRowFilter(SystemSecurityContext context, CatalogSchemaTableName tableName) {
        RangerPrestoAccessRequest request = this.createAccessRequest(RangerSystemAccessControl.createResource(tableName), context, PrestoAccessType.SELECT);
        RangerAccessResult result = this.getRowFilterResult(request);
        ViewExpression viewExpression = null;
        if (this.isRowFilterEnabled(result)) {
            String filter = result.getFilterExpr();
            viewExpression = new ViewExpression(context.getIdentity().getUser(), Optional.of(tableName.getCatalogName()), Optional.of(tableName.getSchemaTableName().getSchemaName()), filter);
        }
        return Optional.ofNullable(viewExpression);
    }

    public Optional<ViewExpression> getColumnMask(SystemSecurityContext context, CatalogSchemaTableName tableName, String columnName, Type type) {
        RangerPrestoAccessRequest request = this.createAccessRequest(RangerSystemAccessControl.createResource(tableName.getCatalogName(), tableName.getSchemaTableName().getSchemaName(), tableName.getSchemaTableName().getTableName(), Optional.of(columnName)), context, PrestoAccessType.SELECT);
        RangerAccessResult result = this.getDataMaskResult(request);
        ViewExpression viewExpression = null;
        if (this.isDataMaskEnabled(result)) {
            String maskType = result.getMaskType();
            RangerServiceDef.RangerDataMaskTypeDef maskTypeDef = result.getMaskTypeDef();
            String transformer = null;
            if (maskTypeDef != null) {
                transformer = maskTypeDef.getTransformer();
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)maskType, (CharSequence)"MASK_NULL")) {
                transformer = "NULL";
            } else if (StringUtils.equalsIgnoreCase((CharSequence)maskType, (CharSequence)"CUSTOM")) {
                String maskedValue = result.getMaskedValue();
                transformer = maskedValue == null ? "NULL" : maskedValue;
            }
            if (StringUtils.isNotEmpty((CharSequence)transformer)) {
                transformer = transformer.replace("{col}", columnName).replace("{type}", type.getDisplayName());
            }
            viewExpression = new ViewExpression(context.getIdentity().getUser(), Optional.of(tableName.getCatalogName()), Optional.of(tableName.getSchemaTableName().getSchemaName()), transformer);
            if (LOG.isDebugEnabled()) {
                LOG.debug("getColumnMask: user: %s, catalog: %s, schema: %s, transformer: %s");
            }
        }
        return Optional.ofNullable(viewExpression);
    }

    public Set<String> filterCatalogs(SystemSecurityContext context, Set<String> catalogs) {
        LOG.debug("==> RangerSystemAccessControl.filterCatalogs(" + catalogs + ")");
        HashSet<String> filteredCatalogs = new HashSet<String>(catalogs.size());
        for (String catalog : catalogs) {
            if (!this.hasPermission(RangerSystemAccessControl.createResource(catalog), context, PrestoAccessType.SELECT)) continue;
            filteredCatalogs.add(catalog);
        }
        return filteredCatalogs;
    }

    public Set<String> filterSchemas(SystemSecurityContext context, String catalogName, Set<String> schemaNames) {
        LOG.debug("==> RangerSystemAccessControl.filterSchemas(" + catalogName + ")");
        HashSet<String> filteredSchemaNames = new HashSet<String>(schemaNames.size());
        for (String schemaName : schemaNames) {
            if (!this.hasPermission(RangerSystemAccessControl.createResource(catalogName, schemaName), context, PrestoAccessType.SELECT)) continue;
            filteredSchemaNames.add(schemaName);
        }
        return filteredSchemaNames;
    }

    public Set<SchemaTableName> filterTables(SystemSecurityContext context, String catalogName, Set<SchemaTableName> tableNames) {
        LOG.debug("==> RangerSystemAccessControl.filterTables(" + catalogName + ")");
        HashSet<SchemaTableName> filteredTableNames = new HashSet<SchemaTableName>(tableNames.size());
        for (SchemaTableName tableName : tableNames) {
            RangerPrestoResource res = RangerSystemAccessControl.createResource(catalogName, tableName.getSchemaName(), tableName.getTableName());
            if (!this.hasPermission(res, context, PrestoAccessType.SELECT)) continue;
            filteredTableNames.add(tableName);
        }
        return filteredTableNames;
    }

    public void checkCanSetSystemSessionProperty(SystemSecurityContext context, String propertyName) {
        if (!this.hasPermission(RangerSystemAccessControl.createSystemPropertyResource(propertyName), context, PrestoAccessType.ALTER)) {
            LOG.debug("RangerSystemAccessControl.checkCanSetSystemSessionProperty denied");
            AccessDeniedException.denySetSystemSessionProperty((String)propertyName);
        }
    }

    public void checkCanImpersonateUser(SystemSecurityContext context, String userName) {
        if (!this.hasPermission(RangerSystemAccessControl.createUserResource(userName), context, PrestoAccessType.IMPERSONATE)) {
            LOG.debug("RangerSystemAccessControl.checkCanImpersonateUser(" + userName + ") denied");
            AccessDeniedException.denyImpersonateUser((String)context.getIdentity().getUser(), (String)userName);
        }
    }

    public void checkCanSetUser(Optional<Principal> principal, String userName) {
    }

    public void checkCanSetCatalogSessionProperty(SystemSecurityContext context, String catalogName, String propertyName) {
        if (!this.hasPermission(RangerSystemAccessControl.createCatalogSessionResource(catalogName, propertyName), context, PrestoAccessType.ALTER)) {
            LOG.debug("RangerSystemAccessControl.checkCanSetCatalogSessionProperty(" + catalogName + ") denied");
            AccessDeniedException.denySetCatalogSessionProperty((String)catalogName, (String)propertyName);
        }
    }

    public void checkCanShowRoles(SystemSecurityContext context, String catalogName) {
        if (!this.hasPermission(RangerSystemAccessControl.createResource(catalogName), context, PrestoAccessType.SHOW)) {
            LOG.debug("RangerSystemAccessControl.checkCanShowRoles(" + catalogName + ") denied");
            AccessDeniedException.denyShowRoles((String)catalogName);
        }
    }

    public void checkCanAccessCatalog(SystemSecurityContext context, String catalogName) {
        if (!this.hasPermission(RangerSystemAccessControl.createResource(catalogName), context, PrestoAccessType.USE)) {
            LOG.debug("RangerSystemAccessControl.checkCanAccessCatalog(" + catalogName + ") denied");
            AccessDeniedException.denyCatalogAccess((String)catalogName);
        }
    }

    public void checkCanShowSchemas(SystemSecurityContext context, String catalogName) {
        if (!this.hasPermission(RangerSystemAccessControl.createResource(catalogName), context, PrestoAccessType.SHOW)) {
            LOG.debug("RangerSystemAccessControl.checkCanShowSchemas(" + catalogName + ") denied");
            AccessDeniedException.denyShowSchemas((String)catalogName);
        }
    }

    public void checkCanSetSchemaAuthorization(SystemSecurityContext context, CatalogSchemaName schema, PrestoPrincipal principal) {
        if (!this.hasPermission(RangerSystemAccessControl.createResource(schema.getCatalogName(), schema.getSchemaName()), context, PrestoAccessType.GRANT)) {
            LOG.debug("RangerSystemAccessControl.checkCanSetSchemaAuthorization(" + schema.getSchemaName() + ") denied");
            AccessDeniedException.denySetSchemaAuthorization((String)schema.getSchemaName(), (PrestoPrincipal)principal);
        }
    }

    public void checkCanShowCreateSchema(SystemSecurityContext context, CatalogSchemaName schema) {
        if (!this.hasPermission(RangerSystemAccessControl.createResource(schema.getCatalogName(), schema.getSchemaName()), context, PrestoAccessType.SHOW)) {
            LOG.debug("RangerSystemAccessControl.checkCanShowCreateSchema(" + schema.getSchemaName() + ") denied");
            AccessDeniedException.denyShowCreateSchema((String)schema.getSchemaName());
        }
    }

    public void checkCanCreateSchema(SystemSecurityContext context, CatalogSchemaName schema) {
        if (!this.hasPermission(RangerSystemAccessControl.createResource(schema.getCatalogName()), context, PrestoAccessType.CREATE)) {
            LOG.debug("RangerSystemAccessControl.checkCanCreateSchema(" + schema.getSchemaName() + ") denied");
            AccessDeniedException.denyCreateSchema((String)schema.getSchemaName());
        }
    }

    public void checkCanDropSchema(SystemSecurityContext context, CatalogSchemaName schema) {
        if (!this.hasPermission(RangerSystemAccessControl.createResource(schema.getCatalogName(), schema.getSchemaName()), context, PrestoAccessType.DROP)) {
            LOG.debug("RangerSystemAccessControl.checkCanDropSchema(" + schema.getSchemaName() + ") denied");
            AccessDeniedException.denyDropSchema((String)schema.getSchemaName());
        }
    }

    public void checkCanRenameSchema(SystemSecurityContext context, CatalogSchemaName schema, String newSchemaName) {
        RangerPrestoResource res = RangerSystemAccessControl.createResource(schema.getCatalogName(), schema.getSchemaName());
        if (!this.hasPermission(res, context, PrestoAccessType.ALTER)) {
            LOG.debug("RangerSystemAccessControl.checkCanRenameSchema(" + schema.getSchemaName() + ") denied");
            AccessDeniedException.denyRenameSchema((String)schema.getSchemaName(), (String)newSchemaName);
        }
    }

    public void checkCanShowTables(SystemSecurityContext context, CatalogSchemaName schema) {
        if (!this.hasPermission(RangerSystemAccessControl.createResource(schema), context, PrestoAccessType.SHOW)) {
            LOG.debug("RangerSystemAccessControl.checkCanShowTables(" + schema.toString() + ") denied");
            AccessDeniedException.denyShowTables((String)schema.toString());
        }
    }

    public void checkCanShowCreateTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        if (!this.hasPermission(RangerSystemAccessControl.createResource(table), context, PrestoAccessType.SHOW)) {
            LOG.debug("RangerSystemAccessControl.checkCanShowTables(" + table.toString() + ") denied");
            AccessDeniedException.denyShowCreateTable((String)table.toString());
        }
    }

    public void checkCanCreateTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        if (!this.hasPermission(RangerSystemAccessControl.createResource(table.getCatalogName(), table.getSchemaTableName().getSchemaName()), context, PrestoAccessType.CREATE)) {
            LOG.debug("RangerSystemAccessControl.checkCanCreateTable(" + table.getSchemaTableName().getTableName() + ") denied");
            AccessDeniedException.denyCreateTable((String)table.getSchemaTableName().getTableName());
        }
    }

    public void checkCanDropTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        if (!this.hasPermission(RangerSystemAccessControl.createResource(table), context, PrestoAccessType.DROP)) {
            LOG.debug("RangerSystemAccessControl.checkCanDropTable(" + table.getSchemaTableName().getTableName() + ") denied");
            AccessDeniedException.denyDropTable((String)table.getSchemaTableName().getTableName());
        }
    }

    public void checkCanRenameTable(SystemSecurityContext context, CatalogSchemaTableName table, CatalogSchemaTableName newTable) {
        RangerPrestoResource res = RangerSystemAccessControl.createResource(table);
        if (!this.hasPermission(res, context, PrestoAccessType.ALTER)) {
            LOG.debug("RangerSystemAccessControl.checkCanRenameTable(" + table.getSchemaTableName().getTableName() + ") denied");
            AccessDeniedException.denyRenameTable((String)table.getSchemaTableName().getTableName(), (String)newTable.getSchemaTableName().getTableName());
        }
    }

    public void checkCanInsertIntoTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        RangerPrestoResource res = RangerSystemAccessControl.createResource(table);
        if (!this.hasPermission(res, context, PrestoAccessType.INSERT)) {
            LOG.debug("RangerSystemAccessControl.checkCanInsertIntoTable(" + table.getSchemaTableName().getTableName() + ") denied");
            AccessDeniedException.denyInsertTable((String)table.getSchemaTableName().getTableName());
        }
    }

    public void checkCanDeleteFromTable(SystemSecurityContext context, CatalogSchemaTableName table) {
        if (!this.hasPermission(RangerSystemAccessControl.createResource(table), context, PrestoAccessType.DELETE)) {
            LOG.debug("RangerSystemAccessControl.checkCanDeleteFromTable(" + table.getSchemaTableName().getTableName() + ") denied");
            AccessDeniedException.denyDeleteTable((String)table.getSchemaTableName().getTableName());
        }
    }

    public void checkCanGrantTablePrivilege(SystemSecurityContext context, Privilege privilege, CatalogSchemaTableName table, PrestoPrincipal grantee, boolean withGrantOption) {
        if (!this.hasPermission(RangerSystemAccessControl.createResource(table), context, PrestoAccessType.GRANT)) {
            LOG.debug("RangerSystemAccessControl.checkCanGrantTablePrivilege(" + table + ") denied");
            AccessDeniedException.denyGrantTablePrivilege((String)privilege.toString(), (String)table.toString());
        }
    }

    public void checkCanRevokeTablePrivilege(SystemSecurityContext context, Privilege privilege, CatalogSchemaTableName table, PrestoPrincipal revokee, boolean grantOptionFor) {
        if (!this.hasPermission(RangerSystemAccessControl.createResource(table), context, PrestoAccessType.REVOKE)) {
            LOG.debug("RangerSystemAccessControl.checkCanRevokeTablePrivilege(" + table + ") denied");
            AccessDeniedException.denyRevokeTablePrivilege((String)privilege.toString(), (String)table.toString());
        }
    }

    public void checkCanSetTableComment(SystemSecurityContext context, CatalogSchemaTableName table) {
        if (!this.hasPermission(RangerSystemAccessControl.createResource(table), context, PrestoAccessType.ALTER)) {
            LOG.debug("RangerSystemAccessControl.checkCanSetTableComment(" + table.toString() + ") denied");
            AccessDeniedException.denyCommentTable((String)table.toString());
        }
    }

    public void checkCanCreateView(SystemSecurityContext context, CatalogSchemaTableName view) {
        if (!this.hasPermission(RangerSystemAccessControl.createResource(view.getCatalogName(), view.getSchemaTableName().getSchemaName()), context, PrestoAccessType.CREATE)) {
            LOG.debug("RangerSystemAccessControl.checkCanCreateView(" + view.getSchemaTableName().getTableName() + ") denied");
            AccessDeniedException.denyCreateView((String)view.getSchemaTableName().getTableName());
        }
    }

    public void checkCanDropView(SystemSecurityContext context, CatalogSchemaTableName view) {
        if (!this.hasPermission(RangerSystemAccessControl.createResource(view), context, PrestoAccessType.DROP)) {
            LOG.debug("RangerSystemAccessControl.checkCanDropView(" + view.getSchemaTableName().getTableName() + ") denied");
            AccessDeniedException.denyDropView((String)view.getSchemaTableName().getTableName());
        }
    }

    public void checkCanCreateViewWithSelectFromColumns(SystemSecurityContext context, CatalogSchemaTableName table, Set<String> columns) {
        try {
            this.checkCanCreateView(context, table);
        }
        catch (AccessDeniedException ade) {
            LOG.debug("RangerSystemAccessControl.checkCanCreateViewWithSelectFromColumns(" + table.getSchemaTableName().getTableName() + ") denied");
            AccessDeniedException.denyCreateViewWithSelect((String)table.getSchemaTableName().getTableName(), (Identity)context.getIdentity());
        }
    }

    public void checkCanRenameView(SystemSecurityContext context, CatalogSchemaTableName view, CatalogSchemaTableName newView) {
        if (!this.hasPermission(RangerSystemAccessControl.createResource(view), context, PrestoAccessType.ALTER)) {
            LOG.debug("RangerSystemAccessControl.checkCanRenameView(" + view.toString() + ") denied");
            AccessDeniedException.denyRenameView((String)view.toString(), (String)newView.toString());
        }
    }

    public void checkCanAddColumn(SystemSecurityContext context, CatalogSchemaTableName table) {
        RangerPrestoResource res = RangerSystemAccessControl.createResource(table);
        if (!this.hasPermission(res, context, PrestoAccessType.ALTER)) {
            AccessDeniedException.denyAddColumn((String)table.getSchemaTableName().getTableName());
        }
    }

    public void checkCanDropColumn(SystemSecurityContext context, CatalogSchemaTableName table) {
        RangerPrestoResource res = RangerSystemAccessControl.createResource(table);
        if (!this.hasPermission(res, context, PrestoAccessType.DROP)) {
            LOG.debug("RangerSystemAccessControl.checkCanDropColumn(" + table.getSchemaTableName().getTableName() + ") denied");
            AccessDeniedException.denyDropColumn((String)table.getSchemaTableName().getTableName());
        }
    }

    public void checkCanRenameColumn(SystemSecurityContext context, CatalogSchemaTableName table) {
        RangerPrestoResource res = RangerSystemAccessControl.createResource(table);
        if (!this.hasPermission(res, context, PrestoAccessType.ALTER)) {
            LOG.debug("RangerSystemAccessControl.checkCanRenameColumn(" + table.getSchemaTableName().getTableName() + ") denied");
            AccessDeniedException.denyRenameColumn((String)table.getSchemaTableName().getTableName());
        }
    }

    public void checkCanShowColumns(SystemSecurityContext context, CatalogSchemaTableName table) {
        if (!this.hasPermission(RangerSystemAccessControl.createResource(table), context, PrestoAccessType.SHOW)) {
            LOG.debug("RangerSystemAccessControl.checkCanShowTables(" + table.toString() + ") denied");
            AccessDeniedException.denyShowColumns((String)table.toString());
        }
    }

    public void checkCanSelectFromColumns(SystemSecurityContext context, CatalogSchemaTableName table, Set<String> columns) {
        for (RangerPrestoResource res : RangerSystemAccessControl.createResource(table, columns)) {
            if (this.hasPermission(res, context, PrestoAccessType.SELECT)) continue;
            LOG.debug("RangerSystemAccessControl.checkCanSelectFromColumns(" + table.getSchemaTableName().getTableName() + ") denied");
            AccessDeniedException.denySelectColumns((String)table.getSchemaTableName().getTableName(), columns);
        }
    }

    public List<ColumnMetadata> filterColumns(SystemSecurityContext context, CatalogSchemaTableName table, List<ColumnMetadata> columns) {
        return columns;
    }

    public void checkCanExecuteQuery(SystemSecurityContext context) {
    }

    public void checkCanViewQueryOwnedBy(SystemSecurityContext context, String queryOwner) {
        if (!this.hasPermission(RangerSystemAccessControl.createUserResource(queryOwner), context, PrestoAccessType.IMPERSONATE)) {
            LOG.debug("RangerSystemAccessControl.checkCanViewQueryOwnedBy(" + queryOwner + ") denied");
            AccessDeniedException.denyImpersonateUser((String)context.getIdentity().getUser(), (String)queryOwner);
        }
    }

    public Set<String> filterViewQueryOwnedBy(SystemSecurityContext context, Set<String> queryOwners) {
        return queryOwners;
    }

    public void checkCanKillQueryOwnedBy(SystemSecurityContext context, String queryOwner) {
        if (!this.hasPermission(RangerSystemAccessControl.createUserResource(queryOwner), context, PrestoAccessType.IMPERSONATE)) {
            LOG.debug("RangerSystemAccessControl.checkCanKillQueryOwnedBy(" + queryOwner + ") denied");
            AccessDeniedException.denyImpersonateUser((String)context.getIdentity().getUser(), (String)queryOwner);
        }
    }

    public void checkCanGrantExecuteFunctionPrivilege(SystemSecurityContext context, String function, PrestoPrincipal grantee, boolean grantOption) {
        if (!this.hasPermission(RangerSystemAccessControl.createFunctionResource(function), context, PrestoAccessType.GRANT)) {
            LOG.debug("RangerSystemAccessControl.checkCanGrantExecuteFunctionPrivilege(" + function + ") denied");
            AccessDeniedException.denyGrantExecuteFunctionPrivilege((String)function, (Identity)context.getIdentity(), (String)grantee.getName());
        }
    }

    public void checkCanExecuteFunction(SystemSecurityContext context, String function) {
        if (!this.hasPermission(RangerSystemAccessControl.createFunctionResource(function), context, PrestoAccessType.EXECUTE)) {
            LOG.debug("RangerSystemAccessControl.checkCanExecuteFunction(" + function + ") denied");
            AccessDeniedException.denyExecuteFunction((String)function);
        }
    }

    public void checkCanExecuteProcedure(SystemSecurityContext context, CatalogSchemaRoutineName procedure) {
        if (!this.hasPermission(RangerSystemAccessControl.createProcedureResource(procedure), context, PrestoAccessType.EXECUTE)) {
            LOG.debug("RangerSystemAccessControl.checkCanExecuteFunction(" + procedure.getSchemaRoutineName().getRoutineName() + ") denied");
            AccessDeniedException.denyExecuteProcedure((String)procedure.getSchemaRoutineName().getRoutineName());
        }
    }

    private RangerPrestoAccessRequest createAccessRequest(RangerPrestoResource resource, SystemSecurityContext context, PrestoAccessType accessType) {
        String userName = null;
        HashSet<String> userGroups = null;
        if (this.useUgi) {
            String[] groups;
            UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)context.getIdentity().getUser());
            userName = ugi.getShortUserName();
            String[] stringArray = groups = ugi != null ? ugi.getGroupNames() : null;
            if (groups != null && groups.length > 0) {
                userGroups = new HashSet<String>(Arrays.asList(groups));
            }
        } else {
            userName = context.getIdentity().getUser();
            userGroups = context.getIdentity().getGroups();
        }
        RangerPrestoAccessRequest request = new RangerPrestoAccessRequest(resource, userName, (Set<String>)userGroups, accessType);
        return request;
    }

    private boolean hasPermission(RangerPrestoResource resource, SystemSecurityContext context, PrestoAccessType accessType) {
        boolean ret = false;
        RangerPrestoAccessRequest request = this.createAccessRequest(resource, context, accessType);
        RangerAccessResult result = this.rangerPlugin.isAccessAllowed((RangerAccessRequest)request);
        if (result != null && result.getIsAllowed()) {
            ret = true;
        }
        return ret;
    }

    private static RangerPrestoResource createUserResource(String userName) {
        RangerPrestoResource res = new RangerPrestoResource();
        res.setValue("prestouser", userName);
        return res;
    }

    private static RangerPrestoResource createFunctionResource(String function) {
        RangerPrestoResource res = new RangerPrestoResource();
        res.setValue("function", function);
        return res;
    }

    private static RangerPrestoResource createProcedureResource(CatalogSchemaRoutineName procedure) {
        RangerPrestoResource res = new RangerPrestoResource();
        res.setValue("catalog", procedure.getCatalogName());
        res.setValue("schema", procedure.getSchemaRoutineName().getSchemaName());
        res.setValue("procedure", procedure.getSchemaRoutineName().getRoutineName());
        return res;
    }

    private static RangerPrestoResource createCatalogSessionResource(String catalogName, String propertyName) {
        RangerPrestoResource res = new RangerPrestoResource();
        res.setValue("catalog", catalogName);
        res.setValue("sessionproperty", propertyName);
        return res;
    }

    private static RangerPrestoResource createSystemPropertyResource(String property) {
        RangerPrestoResource res = new RangerPrestoResource();
        res.setValue("systemproperty", property);
        return res;
    }

    private static RangerPrestoResource createResource(CatalogSchemaName catalogSchemaName) {
        return RangerSystemAccessControl.createResource(catalogSchemaName.getCatalogName(), catalogSchemaName.getSchemaName());
    }

    private static RangerPrestoResource createResource(CatalogSchemaTableName catalogSchemaTableName) {
        return RangerSystemAccessControl.createResource(catalogSchemaTableName.getCatalogName(), catalogSchemaTableName.getSchemaTableName().getSchemaName(), catalogSchemaTableName.getSchemaTableName().getTableName());
    }

    private static RangerPrestoResource createResource(String catalogName) {
        return new RangerPrestoResource(catalogName, Optional.empty(), Optional.empty());
    }

    private static RangerPrestoResource createResource(String catalogName, String schemaName) {
        return new RangerPrestoResource(catalogName, Optional.of(schemaName), Optional.empty());
    }

    private static RangerPrestoResource createResource(String catalogName, String schemaName, String tableName) {
        return new RangerPrestoResource(catalogName, Optional.of(schemaName), Optional.of(tableName));
    }

    private static RangerPrestoResource createResource(String catalogName, String schemaName, String tableName, Optional<String> column) {
        return new RangerPrestoResource(catalogName, Optional.of(schemaName), Optional.of(tableName), column);
    }

    private static List<RangerPrestoResource> createResource(CatalogSchemaTableName table, Set<String> columns) {
        ArrayList<RangerPrestoResource> colRequests = new ArrayList<RangerPrestoResource>();
        if (columns.size() > 0) {
            for (String column : columns) {
                RangerPrestoResource rangerPrestoResource = RangerSystemAccessControl.createResource(table.getCatalogName(), table.getSchemaTableName().getSchemaName(), table.getSchemaTableName().getTableName(), Optional.of(column));
                colRequests.add(rangerPrestoResource);
            }
        } else {
            colRequests.add(RangerSystemAccessControl.createResource(table.getCatalogName(), table.getSchemaTableName().getSchemaName(), table.getSchemaTableName().getTableName(), Optional.empty()));
        }
        return colRequests;
    }
}

